/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.facade.def.element.impl.IterationDescriptor;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.TransitionDefinition;
import org.ow2.bonita.facade.def.majorElement.impl.ActivityDefinitionImpl;
import org.ow2.bonita.facade.def.majorElement.impl.ProcessDefinitionImpl;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IterationDetection {
    private static final Logger LOG = Logger.getLogger(IterationDetection.class.getName());

    private IterationDetection() {
    }

    private static List<TransitionDefinition> createSpanningTree(ProcessDefinition inProcess, InnerProcess spanningTree) {
        ArrayList<TransitionDefinition> transitions = new ArrayList<TransitionDefinition>();
        for (ActivityDefinition inNode : inProcess.getInitialActivities().values()) {
            Node outNode = new Node(inNode.getName());
            spanningTree.addNode(outNode);
            transitions.addAll(IterationDetection.processNode(inProcess, inNode, outNode, spanningTree));
        }
        return transitions;
    }

    private static List<TransitionDefinition> processNode(ProcessDefinition inProcess, ActivityDefinition inNode, Node outNode, InnerProcess outProcess) {
        ArrayList<TransitionDefinition> nonProcessedTransitions = new ArrayList<TransitionDefinition>();
        if (inNode.hasOutgoingTransitions()) {
            for (TransitionDefinition t : inNode.getOutgoingTransitions()) {
                ActivityDefinition destNode = inProcess.getActivity(t.getTo());
                String destName = destNode.getName();
                if (!outProcess.hasNode(destName)) {
                    Node newNode = new Node(destName);
                    outProcess.addNode(newNode);
                    Transition transition = new Transition(outNode, newNode);
                    outNode.addOutgoingTransition(transition);
                    newNode.addIncomingTransition(transition);
                    nonProcessedTransitions.addAll(IterationDetection.processNode(inProcess, inProcess.getActivity(t.getTo()), newNode, outProcess));
                    continue;
                }
                nonProcessedTransitions.add(t);
            }
        }
        return nonProcessedTransitions;
    }

    private static boolean existsPath(Node sourceNode, Node destNode) {
        if (sourceNode.equals(destNode)) {
            return true;
        }
        if (sourceNode.hasOutgoingTransitions()) {
            for (Transition t : sourceNode.getOutgoingTransitions()) {
                if (!IterationDetection.existsPath(t.getDestination(), destNode)) continue;
                return true;
            }
        }
        return false;
    }

    private static List<TransitionDefinition> findCycleTransitions(ProcessDefinition inProcess, InnerProcess process, List<TransitionDefinition> transitions) {
        ArrayList<TransitionDefinition> cycleTransitions = new ArrayList<TransitionDefinition>();
        for (TransitionDefinition t : transitions) {
            String sourceNodeName = t.getFrom();
            String destNodeName = t.getTo();
            Node sourceNode = process.getNode(sourceNodeName);
            Node destNode = process.getNode(destNodeName);
            if (IterationDetection.existsPath(destNode, sourceNode)) {
                cycleTransitions.add(t);
                continue;
            }
            Transition transition = new Transition(sourceNode, destNode);
            sourceNode.addOutgoingTransition(transition);
            destNode.addIncomingTransition(transition);
        }
        return cycleTransitions;
    }

    private static boolean fillCycleObject(CycleObject c, Node sourceNode, Node destNode) {
        if (sourceNode.equals(destNode)) {
            c.nodesInPath.add(sourceNode.getName());
            return true;
        }
        if (sourceNode.hasOutgoingTransitions()) {
            boolean res = false;
            for (Transition t : sourceNode.getOutgoingTransitions()) {
                if (!IterationDetection.fillCycleObject(c, t.getDestination(), destNode)) continue;
                c.nodesInPath.add(sourceNode.getName());
                MyTransition myT = new MyTransition();
                myT.fromNode = t.getSource().getName();
                myT.toNode = t.getDestination().getName();
                c.transitions.add(myT);
                res = true;
            }
            return res;
        }
        return false;
    }

    private static void fillCycleObjectEntryNodes(CycleObject c, ProcessDefinition inProcess) {
        String message;
        boolean hasEntryPointXor = false;
        for (String nodeName : c.nodesInPath) {
            ActivityDefinition sourceNode = inProcess.getActivity(nodeName);
            if (!sourceNode.hasIncomingTransitions()) continue;
            for (TransitionDefinition t : sourceNode.getIncomingTransitions()) {
                boolean isEntryNode = true;
                if (c.nodesInPath.contains(t.getFrom())) {
                    for (MyTransition myTr : c.transitions) {
                        if (!myTr.fromNode.equals(t.getFrom()) || !myTr.toNode.equals(t.getTo())) continue;
                        isEntryNode = false;
                    }
                }
                if (!isEntryNode) continue;
                c.entryNodes.add(sourceNode.getName());
                ActivityDefinition.JoinType joinType = sourceNode.getJoinType();
                if (ActivityDefinition.JoinType.XOR.equals((Object)joinType)) {
                    hasEntryPointXor = true;
                    continue;
                }
                if (!ActivityDefinition.JoinType.AND.equals((Object)joinType)) continue;
                String message2 = ExceptionManager.getInstance().getFullMessage("bd_ID_1", c, sourceNode.getName());
                throw new BonitaRuntimeException(message2);
            }
        }
        if (c.entryNodes.size() == 0) {
            message = ExceptionManager.getInstance().getFullMessage("bd_ID_2", c);
            throw new BonitaRuntimeException(message);
        }
        if (!hasEntryPointXor) {
            message = ExceptionManager.getInstance().getFullMessage("bd_ID_3", c);
            throw new BonitaRuntimeException(message);
        }
    }

    private static void checkExitNodes(CycleObject c, ProcessDefinition inProcess) {
        for (String nodeName : c.nodesInPath) {
            ActivityDefinition sourceNode = inProcess.getActivity(nodeName);
            if (!sourceNode.hasOutgoingTransitions()) continue;
            for (TransitionDefinition t : sourceNode.getOutgoingTransitions()) {
                if (c.nodesInPath.contains(t.getTo())) continue;
                c.exitNodes.add(sourceNode.getName());
                ActivityDefinition.SplitType splitType = sourceNode.getSplitType();
                if (ActivityDefinition.SplitType.XOR.equals((Object)splitType)) continue;
                LOG.severe("Potential issue in iteration : " + nodeName + " is an exit node for cycle " + c.nodesInPath + "." + Misc.LINE_SEPARATOR + "Split type of this node is " + (Object)((Object)splitType) + " but only XOR is supported." + Misc.LINE_SEPARATOR + "An exception will be thrown at runtime if more than one transition is enabled at the same time.");
            }
        }
    }

    private static Set<IterationDescriptor> findCycleInits(ProcessDefinition inProcess, InnerProcess dag, List<TransitionDefinition> transitions) {
        HashSet<IterationDescriptor> iterationDescriptors = new HashSet<IterationDescriptor>();
        for (TransitionDefinition t : transitions) {
            String sourceNodeName = t.getFrom();
            String destNodeName = t.getTo();
            Node sourceNode = dag.getNode(sourceNodeName);
            Node destNode = dag.getNode(destNodeName);
            Transition transition = new Transition(sourceNode, destNode);
            sourceNode.addOutgoingTransition(transition);
            destNode.addIncomingTransition(transition);
            CycleObject c = new CycleObject();
            if (IterationDetection.fillCycleObject(c, destNode, sourceNode)) {
                MyTransition myT = new MyTransition();
                myT.fromNode = sourceNodeName;
                myT.toNode = destNodeName;
                c.transitions.add(myT);
            }
            IterationDetection.fillCycleObjectEntryNodes(c, inProcess);
            IterationDetection.checkExitNodes(c, inProcess);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("CycleObject :" + c);
            }
            sourceNode.removeOutgoingTransition(transition);
            destNode.removeIncomingTransition(transition);
            HashSet<String> entryNodes = new HashSet<String>();
            HashSet<String> exitNodes = new HashSet<String>();
            HashSet<String> otherNodes = new HashSet<String>();
            for (String nodeName : c.nodesInPath) {
                if (c.entryNodes.contains(nodeName)) {
                    entryNodes.add(nodeName);
                }
                if (c.exitNodes.contains(nodeName)) {
                    exitNodes.add(nodeName);
                }
                if (c.entryNodes.contains(nodeName) || c.exitNodes.contains(nodeName)) continue;
                otherNodes.add(nodeName);
            }
            IterationDescriptor itDescr = new IterationDescriptor(otherNodes, entryNodes, exitNodes);
            iterationDescriptors.add(itDescr);
        }
        return iterationDescriptors;
    }

    public static ProcessDefinition findIterations(ProcessDefinitionImpl inProcess) {
        InnerProcess outProcess = new InnerProcess();
        List<TransitionDefinition> unprocessedTransitions = IterationDetection.createSpanningTree(inProcess, outProcess);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.info("Unprocessed transitions: " + unprocessedTransitions);
        }
        List<TransitionDefinition> cycleTransitions = IterationDetection.findCycleTransitions(inProcess, outProcess, unprocessedTransitions);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.info("Cycle transitions: " + cycleTransitions);
        }
        Set<IterationDescriptor> iterationDescriptors = IterationDetection.findCycleInits(inProcess, outProcess, cycleTransitions);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.info("iteration descriptors: " + iterationDescriptors);
        }
        for (IterationDescriptor iterationDescriptor : iterationDescriptors) {
            inProcess.addIterationDescriptors(iterationDescriptor);
            for (String activityName : iterationDescriptor.getCycleNodes()) {
                ActivityDefinitionImpl activity = (ActivityDefinitionImpl)inProcess.getActivity(activityName);
                activity.setInCycle(true);
            }
        }
        return inProcess;
    }

    private static class Transition {
        Node source;
        Node destination;

        public Transition(Node source, Node destination) {
            this.source = source;
            this.destination = destination;
        }

        public Node getDestination() {
            return this.destination;
        }

        public Node getSource() {
            return this.source;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node {
        private String name;
        private Set<Transition> incomingTransitions = new HashSet<Transition>();
        private Set<Transition> outgoingTransitions = new HashSet<Transition>();

        public Node(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Set<Transition> getOutgoingTransitions() {
            return this.outgoingTransitions;
        }

        public void addIncomingTransition(Transition t) {
            this.incomingTransitions.add(t);
        }

        public void addOutgoingTransition(Transition t) {
            this.outgoingTransitions.add(t);
        }

        public void removeOutgoingTransition(Transition transition) {
            this.outgoingTransitions.remove(transition);
        }

        public void removeIncomingTransition(Transition transition) {
            this.incomingTransitions.remove(transition);
        }

        public boolean hasOutgoingTransitions() {
            return !this.outgoingTransitions.isEmpty();
        }
    }

    private static class InnerProcess {
        Map<String, Node> nodes = new HashMap<String, Node>();

        private InnerProcess() {
        }

        public void addNode(Node node) {
            this.nodes.put(node.getName(), node);
        }

        public Node getNode(String nodeName) {
            return this.nodes.get(nodeName);
        }

        public boolean hasNode(String name) {
            return this.nodes.containsKey(name);
        }
    }

    private static class MyTransition {
        protected String fromNode;
        protected String toNode;

        private MyTransition() {
        }

        public String toString() {
            return this.fromNode + "->" + this.toNode;
        }
    }

    private static class CycleObject {
        protected Set<String> entryNodes = new HashSet<String>();
        protected Set<String> exitNodes = new HashSet<String>();
        protected Set<String> nodesInPath = new HashSet<String>();
        protected Set<MyTransition> transitions = new HashSet<MyTransition>();

        private CycleObject() {
        }

        public String toString() {
            return "entryNodes: " + this.entryNodes + ", exitNodes: " + this.exitNodes + " path: " + this.nodesInPath + ", transitions: " + this.transitions;
        }
    }
}

