/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class MBeanInvocationHandler
implements InvocationHandler {
    private final MBeanServerConnection mbsc;
    private final ObjectName mbeanObjectName;

    public MBeanInvocationHandler(String jmxServiceUrl, String jmxObjectName) throws IOException, MalformedObjectNameException {
        JMXServiceURL url = new JMXServiceURL(jmxServiceUrl);
        JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
        this.mbsc = jmxc.getMBeanServerConnection();
        this.mbeanObjectName = ObjectName.getInstance(jmxObjectName);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String[] signature;
        String[] stringArray = signature = args == null ? null : new String[args.length];
        if (args != null) {
            Class<?>[] types = method.getParameterTypes();
            for (int i = 0; i < signature.length; ++i) {
                signature[i] = types[i].getName();
            }
        }
        return this.mbsc.invoke(this.mbeanObjectName, method.getName(), args, signature);
    }
}

