/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.definition.activity.ConnectorExecutor;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.AttachmentDefinition;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.def.majorElement.DataFieldDefinition;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.impl.FacadeUtil;
import org.ow2.bonita.facade.runtime.InitialAttachment;
import org.ow2.bonita.facade.runtime.impl.AttachmentInstanceImpl;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.services.LargeDataRepository;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.type.Converter;
import org.ow2.bonita.type.Type;
import org.ow2.bonita.type.Variable;
import org.ow2.bonita.type.VariableTypeResolver;
import org.ow2.bonita.type.variable.NullVariable;
import org.ow2.bonita.type.variable.UnpersistableVariable;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.DateUtil;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.GroovyException;
import org.ow2.bonita.util.GroovyUtil;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.VariableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessUtil {
    static final Logger LOG = Logger.getLogger(ProcessUtil.class.getName());

    public static void removeAllInstanceEvents(ProcessInstanceUUID instanceUUID) {
        EventService eventService = EnvTool.getEventService();
        eventService.removeSubscriptions(instanceUUID);
        Set<OutgoingEventInstance> outgoings = eventService.getOutgoingEvents(instanceUUID);
        for (OutgoingEventInstance outgoing : outgoings) {
            eventService.removeEvent(outgoing);
        }
    }

    public static void removeInternalInstanceEvents(ProcessInstanceUUID instanceUUID) {
        EventService eventService = EnvTool.getEventService();
        eventService.removeSubscriptions(instanceUUID);
        Set<OutgoingEventInstance> outgoings = eventService.getOutgoingEvents(instanceUUID);
        for (OutgoingEventInstance outgoing : outgoings) {
            String name = outgoing.getName();
            if (!name.startsWith("**bonita_timer**-") && !name.startsWith("**bonita_deadline**-") && !name.startsWith("**bonita_async**-")) continue;
            eventService.removeEvent(outgoing);
        }
    }

    public static Date getTimerDate(String condition, ActivityInstanceUUID activityUUID, Execution execution) throws GroovyException {
        Misc.checkArgsNotNull(condition, execution);
        Date dueDate = null;
        String evaluatedCondition = condition;
        if (Misc.isJustAGroovyExpression(condition)) {
            Object value = GroovyUtil.evaluate(condition, null, activityUUID, false, false);
            if (value instanceof Date) {
                dueDate = (Date)value;
            } else if (value instanceof String) {
                evaluatedCondition = (String)value;
            } else if (value instanceof Long) {
                evaluatedCondition = ((Long)value).toString();
            } else if (value instanceof Integer) {
                evaluatedCondition = ((Integer)value).toString();
            }
        }
        try {
            dueDate = new Date(System.currentTimeMillis() + Long.parseLong(evaluatedCondition));
        }
        catch (NumberFormatException e1) {
            try {
                if (dueDate == null) {
                    dueDate = DateUtil.parseDate(evaluatedCondition);
                }
            }
            catch (IllegalArgumentException e2) {
                throw new BonitaRuntimeException("Timer condition '" + evaluatedCondition + "' is neither a Long nor a formatted date", e2);
            }
        }
        return dueDate;
    }

    public static Map<String, Variable> createVariables(Collection<DataFieldDefinition> datafields, ProcessInstanceUUID instanceUUID) {
        if (datafields == null || datafields.isEmpty()) {
            return null;
        }
        HashMap<String, Variable> variables = new HashMap<String, Variable>();
        for (DataFieldDefinition df : datafields) {
            String script;
            Object value = df.getInitialValue();
            if (value == null && (script = df.getScriptingValue()) != null) {
                try {
                    value = instanceUUID != null ? GroovyUtil.evaluate(df.getScriptingValue(), null, instanceUUID, false) : GroovyUtil.evaluate(df.getScriptingValue(), null, df.getProcessDefinitionUUID(), false);
                }
                catch (Exception e) {
                    throw new BonitaRuntimeException(e);
                }
            }
            variables.put(df.getName(), ProcessUtil.createVariable(df.getProcessDefinitionUUID(), df.getName(), value));
        }
        return variables;
    }

    public static Variable createVariable(ProcessDefinitionUUID processUUID, String key, Object value) {
        Type type = null;
        VariableTypeResolver variableTypeResolver = EnvTool.getVariableTypeResolver();
        if (variableTypeResolver != null) {
            type = variableTypeResolver.findTypeByMatch(key, value);
        }
        Variable variable = null;
        if (type != null) {
            Class<?> variableClass = type.getVariableClass();
            try {
                variable = (Variable)variableClass.newInstance();
                variable.setProcessUUID(processUUID);
            }
            catch (Exception e) {
                String message = ExceptionManager.getInstance().getFullMessage("bp_EI_14", variableClass.getName());
                throw new BonitaRuntimeException(message);
            }
            Converter converter = type.getConverter();
            variable.setConverter(converter);
        } else {
            variable = value == null ? new NullVariable() : new UnpersistableVariable();
        }
        variable.setKey(key);
        variable.setValue(value);
        return variable;
    }

    public static Execution createProcessInstance(ProcessDefinitionUUID processUUID, Map<String, Object> variables, Collection<InitialAttachment> attachments, ProcessInstanceUUID parentInstanceUUID, ProcessInstanceUUID rootInstanceUUID) throws ProcessNotFoundException {
        InternalProcessDefinition process = FacadeUtil.getProcessDefinition(processUUID);
        Execution rootExecution = ProcessUtil.createProcessInstance(process, rootInstanceUUID);
        InternalProcessInstance instance = rootExecution.getInstance();
        Recorder recorder = EnvTool.getRecorder();
        Map<String, Variable> givenVariables = VariableUtil.createVariableMap(processUUID, variables);
        Map<String, Variable> processVariables = ProcessUtil.createVariables(process.getDataFields(), null);
        HashMap<String, Variable> initialVariables = new HashMap<String, Variable>();
        if (processVariables != null) {
            initialVariables.putAll(processVariables);
        }
        if (givenVariables != null) {
            initialVariables.putAll(givenVariables);
        }
        instance.setParentInstanceUUID(parentInstanceUUID);
        instance.setInitialVaribales(initialVariables);
        recorder.recordInstanceStarted(instance, EnvTool.getUserId());
        HashSet<String> runtimeAttachmentNames = new HashSet<String>();
        if (attachments != null) {
            for (InitialAttachment attachment : attachments) {
                runtimeAttachmentNames.add(attachment.getName());
                AttachmentInstanceImpl newAttachment = new AttachmentInstanceImpl(attachment, instance.getUUID(), EnvTool.getUserId(), new Date());
                ProcessUtil.addAttachment(instance, newAttachment, attachment.getContent());
            }
        }
        LargeDataRepository ldr = EnvTool.getLargeDataRepository();
        for (AttachmentDefinition attachmentDefinition : process.getAttachments().values()) {
            if (runtimeAttachmentNames.contains(attachmentDefinition.getName())) continue;
            byte[] initialValue = null;
            if (attachmentDefinition.getFilePath() != null) {
                initialValue = ldr.getData(byte[].class, Misc.getAttachmentCategories(processUUID), attachmentDefinition.getFilePath());
            }
            AttachmentInstanceImpl attachmentInstance = new AttachmentInstanceImpl(attachmentDefinition.getName(), instance.getUUID(), EnvTool.getUserId(), new Date());
            attachmentInstance.setLabel(attachmentDefinition.getLabel());
            attachmentInstance.setDescription(attachmentDefinition.getDescription());
            attachmentInstance.setFileName(attachmentDefinition.getFileName());
            ProcessUtil.addAttachment(instance, attachmentInstance, initialValue);
        }
        ConnectorExecutor.executeConnectors(rootExecution, HookDefinition.Event.instanceOnStart);
        return rootExecution;
    }

    public static void addAttachment(InternalProcessInstance processInstance, AttachmentInstanceImpl attachmentInstance, byte[] value) {
        LargeDataRepository largeDataRepository = EnvTool.getLargeDataRepository();
        ProcessInstanceUUID instanceUUID = attachmentInstance.getProcessInstanceUUID();
        processInstance.addAttachment(attachmentInstance);
        Date versionDate = attachmentInstance.getVersionDate();
        String name = Misc.getAttachmentIndexName(attachmentInstance.getName(), versionDate);
        List<String> categories = Misc.getAttachmentCategories(instanceUUID);
        largeDataRepository.storeData(categories, name, (Serializable)value, false);
        String filePath = largeDataRepository.getDataPath(categories, name);
        attachmentInstance.setFilePath(filePath);
    }

    private static Execution createProcessInstance(InternalProcessDefinition process, ProcessInstanceUUID rootInstanceUUID) {
        ProcessDefinitionUUID processUUID = process.getUUID();
        ProcessInstanceUUID instanceUUID = EnvTool.getUUIDService().getNewProcessInstanceUUID(processUUID);
        ProcessInstanceUUID theRootInstanceUUID = null;
        theRootInstanceUUID = rootInstanceUUID == null ? instanceUUID : rootInstanceUUID;
        InternalProcessInstance instance = new InternalProcessInstance(instanceUUID, process, theRootInstanceUUID);
        Execution processInstance = instance.getRootExecution();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("creating new execution for process '" + process.getName() + "'");
        }
        return processInstance;
    }
}

