/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.descriptor.ArgDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectUtilDescriptor {
    static final Logger LOG = Logger.getLogger(ReflectUtilDescriptor.class.getName());

    public static Method findMethod(Class<?> clazz, String methodName, List<ArgDescriptor> argDescriptors, Object[] args) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("searching for method " + methodName + " in " + clazz.getName());
        }
        Method[] candidates = clazz.getDeclaredMethods();
        for (int i = 0; i < candidates.length; ++i) {
            Method candidate = candidates[i];
            if (!candidate.getName().equals(methodName) || !ReflectUtilDescriptor.isArgumentMatch(candidate.getParameterTypes(), argDescriptors, args)) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("found matching method " + clazz.getName() + "." + methodName);
            }
            return candidate;
        }
        if (clazz.getSuperclass() != null) {
            return ReflectUtilDescriptor.findMethod(clazz.getSuperclass(), methodName, argDescriptors, args);
        }
        return null;
    }

    public static Constructor<?> findConstructor(Class<?> clazz, List<ArgDescriptor> argDescriptors, Object[] args) {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            if (!ReflectUtilDescriptor.isArgumentMatch(constructors[i].getParameterTypes(), argDescriptors, args)) continue;
            return constructors[i];
        }
        return null;
    }

    public static boolean isArgumentMatch(Class<?>[] parameterTypes, List<ArgDescriptor> argDescriptors, Object[] args) {
        int nbrOfArgs = 0;
        if (args != null) {
            nbrOfArgs = args.length;
        }
        int nbrOfParameterTypes = 0;
        if (parameterTypes != null) {
            nbrOfParameterTypes = parameterTypes.length;
        }
        if (nbrOfArgs == 0 && nbrOfParameterTypes == 0) {
            return true;
        }
        if (nbrOfArgs != nbrOfParameterTypes) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            String argTypeName;
            Class<?> parameterType = parameterTypes[i];
            String string = argTypeName = argDescriptors != null ? argDescriptors.get(i).getTypeName() : null;
            if (!(argTypeName != null ? !argTypeName.equals(parameterType.getName()) : args[i] != null && !parameterType.isAssignableFrom(args[i].getClass()))) continue;
            return false;
        }
        return true;
    }

    public static String getSignature(String methodName, List<ArgDescriptor> argDescriptors, Object[] args) {
        String signature = methodName + "(";
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                ArgDescriptor argDescriptor;
                String argType = null;
                if (argDescriptors != null && (argDescriptor = argDescriptors.get(i)) != null && argDescriptor.getTypeName() != null) {
                    argType = argDescriptor.getTypeName();
                }
                if (argType == null && args[i] != null) {
                    argType = args[i].getClass().getName();
                }
                signature = signature + argType;
                if (i >= args.length - 1) continue;
                signature = signature + ", ";
            }
        }
        signature = signature + ")";
        return signature;
    }
}

