/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.util.HashMap;
import java.util.Map;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.type.Converter;
import org.ow2.bonita.type.Type;
import org.ow2.bonita.type.Variable;
import org.ow2.bonita.type.VariableTypeResolver;
import org.ow2.bonita.type.variable.NullVariable;
import org.ow2.bonita.type.variable.UnpersistableVariable;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VariableUtil {
    public static final String DEPLOYMENT_IDPREFIX = "deployment$";

    protected VariableUtil() {
    }

    public static Map<String, Variable> createVariableMap(ProcessDefinitionUUID processUUID, Map<String, Object> variables) {
        if (variables == null || variables.isEmpty()) {
            return null;
        }
        HashMap<String, Variable> variableMap = new HashMap<String, Variable>();
        for (Map.Entry<String, Object> e : variables.entrySet()) {
            Object value = e.getValue();
            variableMap.put(e.getKey(), VariableUtil.createVariable(processUUID, e.getKey(), value));
        }
        return variableMap;
    }

    public static Variable createVariable(ProcessDefinitionUUID processUUID, String key, Object value) {
        VariableTypeResolver variableTypeResolver;
        Type type = null;
        Environment environment = Environment.getCurrent();
        if (environment != null && (variableTypeResolver = environment.get(VariableTypeResolver.class)) != null) {
            type = variableTypeResolver.findTypeByMatch(key, value);
        }
        Variable variable = null;
        if (type != null) {
            Class<?> variableClass = type.getVariableClass();
            try {
                variable = (Variable)variableClass.newInstance();
                variable.setProcessUUID(processUUID);
            }
            catch (Exception e) {
                String message = ExceptionManager.getInstance().getFullMessage("bafi_FCT_1", variableClass.getName());
                throw new BonitaRuntimeException(message);
            }
            Converter converter = type.getConverter();
            variable.setConverter(converter);
        } else {
            variable = value == null ? new NullVariable() : new UnpersistableVariable();
        }
        variable.setKey(key);
        variable.setValue(value);
        return variable;
    }

    public static Map<String, Variable> copyVariableMap(ProcessDefinitionUUID processUUID, Map<String, Variable> variables) {
        if (variables == null || variables.isEmpty()) {
            return null;
        }
        HashMap<String, Variable> variableMap = new HashMap<String, Variable>();
        for (Map.Entry<String, Variable> e : variables.entrySet()) {
            Variable var = VariableUtil.copyVariable(e.getValue());
            variableMap.put(var.getKey(), var);
        }
        return variableMap;
    }

    public static Variable copyVariable(Variable var) {
        Object value = var.getValue();
        String key = var.getKey();
        return VariableUtil.createVariable(var.getProcessUUID(), key, value);
    }
}

