/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util.stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.stream.StreamSource;

public class FileStreamSource
extends StreamSource {
    protected File file;

    public FileStreamSource(File file) {
        if (file == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_FSS_1", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        try {
            this.name = file.toURL().toString();
        }
        catch (MalformedURLException e) {
            this.name = file.toString();
        }
        this.file = file;
    }

    public InputStream openStream() {
        FileInputStream stream = null;
        try {
            if (!this.file.exists()) {
                String message = ExceptionManager.getInstance().getFullMessage("bp_FSS_2", this.file);
                throw new BonitaRuntimeException(message);
            }
            if (this.file.isDirectory()) {
                String message = ExceptionManager.getInstance().getFullMessage("bp_FSS_3", this.file);
                throw new BonitaRuntimeException(message);
            }
            stream = new FileInputStream(this.file);
        }
        catch (Exception e) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_FSS_4", this.file, e.getMessage());
            throw new BonitaRuntimeException(message, e);
        }
        return stream;
    }
}

