/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util.xml;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import org.ow2.bonita.util.stream.FileStreamSource;
import org.ow2.bonita.util.stream.InputStreamSource;
import org.ow2.bonita.util.stream.ResourceStreamSource;
import org.ow2.bonita.util.stream.StreamSource;
import org.ow2.bonita.util.stream.StringStreamSource;
import org.ow2.bonita.util.stream.UrlStreamSource;
import org.ow2.bonita.util.xml.Parser;
import org.ow2.bonita.util.xml.Problem;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parse
implements Serializable,
ErrorHandler {
    private static final long serialVersionUID = 1L;
    protected Parser parser;
    protected ClassLoader classLoader;
    protected StreamSource streamSource;
    protected InputStream inputStream;
    protected InputSource inputSource;
    protected DocumentBuilder documentBuilder = null;
    protected Document document = null;
    protected Stack<Object> objectStack;
    protected List<Problem> problems = null;
    protected Object documentObject;

    protected Parse(Parser parser) {
        this.parser = parser;
    }

    public Parse setInputStream(InputStream inputStream) {
        this.streamSource = new InputStreamSource(inputStream);
        return this;
    }

    public Parse setUrl(URL url) {
        this.streamSource = new UrlStreamSource(url);
        return this;
    }

    public Parse setFile(File file) {
        this.streamSource = new FileStreamSource(file);
        return this;
    }

    public Parse setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public Parse setResource(String resource) {
        this.streamSource = new ResourceStreamSource(resource, this.classLoader);
        return this;
    }

    public Parse setString(String xmlString) {
        this.streamSource = new StringStreamSource(xmlString);
        return this;
    }

    public Parse setStreamSource(StreamSource streamSource) {
        this.streamSource = streamSource;
        return this;
    }

    public Parse setInputSource(InputSource inputSource) {
        this.inputSource = inputSource;
        return this;
    }

    public Parse setDocument(Document document) {
        this.document = document;
        return this;
    }

    public Parse setDocumentObject(Object object) {
        this.documentObject = object;
        return this;
    }

    public Parse execute() {
        this.parser.execute(this);
        return this;
    }

    public List<Problem> getProblems() {
        return this.problems;
    }

    public void addProblem(Problem problem) {
        if (this.problems == null) {
            this.problems = new ArrayList<Problem>();
        }
        this.problems.add(problem);
    }

    public void addProblem(String msg) {
        this.addProblem(msg, null);
    }

    public void addProblem(String msg, Exception e) {
        this.addProblem(msg, e, "error");
    }

    public void addWarning(String msg) {
        this.addWarning(msg, null);
    }

    public void addWarning(String msg, Exception e) {
        this.addProblem(msg, e, "warning");
    }

    public void addProblem(String msg, Exception e, String severity) {
        this.addProblem(new Problem(msg, e, severity));
    }

    public boolean hasProblems() {
        return this.problems != null && this.problems.size() > 0;
    }

    public Parse setProblems(List<Problem> problems) {
        this.problems = problems;
        return this;
    }

    @Override
    public void error(SAXParseException e) {
        this.addProblem(e.getMessage(), e, "error");
    }

    @Override
    public void fatalError(SAXParseException e) {
        this.addProblem(e.getMessage(), e, "fatal-error");
    }

    @Override
    public void warning(SAXParseException e) {
        this.addProblem(e.getMessage(), e, "warning");
    }

    public Parse pushObject(Object object) {
        if (this.objectStack == null) {
            this.objectStack = new Stack();
        }
        this.objectStack.push(object);
        return this;
    }

    public Object popObject() {
        if (this.objectStack != null) {
            return this.objectStack.pop();
        }
        return null;
    }

    public Object peekObject() {
        if (this.objectStack != null) {
            return this.objectStack.peek();
        }
        return null;
    }

    public <T> T findObject(Class<T> clazz) {
        if (this.objectStack != null && !this.objectStack.isEmpty()) {
            ListIterator listIter = this.objectStack.listIterator(this.objectStack.size());
            while (listIter.hasPrevious()) {
                Object object = listIter.previous();
                if (object == null || !clazz.isAssignableFrom(object.getClass())) continue;
                return (T)object;
            }
            return null;
        }
        return null;
    }

    public Object getDocumentObject() {
        return this.documentObject;
    }

    public Document getDocument() {
        return this.document;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

