/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.ow2.bonita.util.stream.StreamSource;
import org.ow2.bonita.util.xml.Binding;
import org.ow2.bonita.util.xml.Bindings;
import org.ow2.bonita.util.xml.Entity;
import org.ow2.bonita.util.xml.Parse;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser
implements EntityResolver {
    static final Logger LOG = Logger.getLogger(Parser.class.getName());
    protected DocumentBuilderFactory documentBuilderFactory = null;
    protected Map<String, Entity> entities = null;
    protected Bindings bindings = null;
    protected ClassLoader classLoader = null;

    public Parser() {
    }

    public Parser(Bindings bindings) {
        this.bindings = bindings;
    }

    public Parser(Bindings bindings, Map<String, Entity> entities) {
        this.bindings = bindings;
        this.entities = entities;
    }

    public synchronized DocumentBuilderFactory getDocumentBuilderFactory() {
        if (this.documentBuilderFactory == null) {
            this.documentBuilderFactory = this.newDocumentBuilderFactory();
        }
        return this.documentBuilderFactory;
    }

    public void setDocumentBuilderFactory(DocumentBuilderFactory documentBuilderFactory) {
        this.documentBuilderFactory = documentBuilderFactory;
    }

    protected DocumentBuilderFactory newDocumentBuilderFactory() {
        return DocumentBuilderFactory.newInstance();
    }

    public void addEntity(String publicId, Entity entity) {
        if (this.entities == null) {
            this.entities = new HashMap<String, Entity>();
        }
        this.entities.put(publicId, entity);
    }

    public void useParseEntityResolver() {
        if (this.entities == null) {
            this.entities = new HashMap<String, Entity>();
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        Entity entity;
        InputSource inputSource = null;
        if (this.entities != null && (entity = this.entities.get(publicId)) != null) {
            inputSource = entity.getInputSource();
        }
        if (inputSource == null) {
            if (systemId != null) {
                inputSource = new InputSource(systemId);
            } else if (LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("couldn't resolve entity with publicId " + publicId + " and systemId " + systemId);
            }
        }
        return inputSource;
    }

    public Bindings getBindings() {
        return this.bindings;
    }

    public void setBindings(Bindings bindings) {
        this.bindings = bindings;
    }

    public Binding getBinding(Element element) {
        return this.getBinding(element, null);
    }

    public Binding getBinding(Element element, String category) {
        return this.bindings != null ? this.bindings.getBinding(element, category) : null;
    }

    public Parse createParse() {
        return new Parse(this);
    }

    public void importStream(StreamSource importedStreamSource, Element destination, Parse importingParse) {
        try {
            Parse importedParse = this.createParse();
            importedParse.setStreamSource(importedStreamSource);
            Document importedDocument = this.buildDom(importedParse);
            Element importedDocumentElement = importedDocument.getDocumentElement();
            for (Element e : XmlUtil.elements(importedDocumentElement)) {
                destination.appendChild(destination.getOwnerDocument().importNode(e, true));
            }
        }
        catch (Exception e) {
            importingParse.addProblem("couldn't import " + importedStreamSource, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Parse parse) {
        try {
            if (parse.document == null) {
                parse.document = this.buildDom(parse);
            }
            if (parse.document != null) {
                try {
                    this.parseDocument(parse.document, parse);
                }
                catch (Exception e) {
                    parse.addProblem("couldn't interpret the dom model", e);
                }
            }
        }
        finally {
            if (parse.inputStream != null) {
                try {
                    parse.inputStream.close();
                }
                catch (Exception e) {
                    parse.addProblem("couldn't close input stream", e);
                }
            }
        }
    }

    protected Document buildDom(Parse parse) {
        DocumentBuilder documentBuilder = this.createDocumentBuilder(parse);
        InputSource inputSource = this.getInputSource(parse);
        try {
            parse.document = documentBuilder.parse(inputSource);
        }
        catch (Exception e) {
            parse.addProblem("couldn't parse xml document", e);
        }
        return parse.document;
    }

    protected DocumentBuilder createDocumentBuilder(Parse parse) {
        DocumentBuilderFactory documentBuilderFactory = this.getDocumentBuilderFactory();
        try {
            parse.documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            parse.addProblem("couldn't get new document builder", e);
            return null;
        }
        parse.documentBuilder.setErrorHandler(parse);
        parse.documentBuilder.setEntityResolver(this);
        return parse.documentBuilder;
    }

    protected InputSource getInputSource(Parse parse) {
        if (parse.inputSource != null) {
            return parse.inputSource;
        }
        if (parse.streamSource != null) {
            parse.inputStream = parse.streamSource.openStream();
            return new InputSource(parse.inputStream);
        }
        parse.addProblem("no source specified to parse");
        return null;
    }

    public Object parseDocument(Document document, Parse parse) {
        Object object;
        parse.documentObject = object = this.parseDocumentElement(document.getDocumentElement(), parse);
        return object;
    }

    public Object parseDocumentElement(Element documentElement, Parse parse) {
        return this.parseElement(documentElement, parse);
    }

    public Object parseElement(Element element, Parse parse) {
        return this.parseElement(element, parse, null);
    }

    public Object parseElement(Element element, Parse parse, String category) {
        Object object = null;
        String tagName = XmlUtil.getTagLocalName(element);
        Binding binding = this.getBinding(element, category);
        if (binding != null) {
            object = binding.parse(element, parse, this);
        } else {
            parse.addProblem("no element parser for tag " + tagName + (category != null ? " in category " + category : " in the default category"));
        }
        return object;
    }
}

