/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.xml.Entity;
import org.xml.sax.InputSource;

public class UrlEntity
implements Entity {
    protected String systemId = null;
    protected URL url = null;

    public UrlEntity(URL url, String systemId) {
        this.url = url;
        this.systemId = systemId;
    }

    public UrlEntity(String resource, ClassLoader classLoader) {
        this.url = classLoader.getResource(resource);
        if (this.url == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_UE_1", resource);
            throw new BonitaRuntimeException(message);
        }
        this.systemId = this.url.toString();
    }

    public InputSource getInputSource() {
        try {
            InputStream stream = this.url.openStream();
            InputSource inputSource = new InputSource(stream);
            inputSource.setSystemId(this.systemId);
            return inputSource;
        }
        catch (IOException e) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_UE_2", this.url);
            throw new BonitaRuntimeException(message, e);
        }
    }
}

