/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util.xml;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.xml.Parse;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlUtil {
    static final Logger LOG = Logger.getLogger(XmlUtil.class.getName());

    public static List<Element> elements(Element element, String tagName) {
        ArrayList<Element> elements = null;
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element childElement;
                String childTagName;
                Node child = nodeList.item(i);
                if (!Element.class.isAssignableFrom(child.getClass()) || !(childTagName = XmlUtil.getTagLocalName(childElement = (Element)child)).equals(tagName)) continue;
                if (elements == null) {
                    elements = new ArrayList<Element>();
                }
                elements.add(childElement);
            }
        }
        return elements;
    }

    public static List<Element> elements(Element element, Set<String> allowedTagNames) {
        ArrayList<Element> elements = null;
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element childElement;
                String childTagName;
                Node child = nodeList.item(i);
                if (!Element.class.isAssignableFrom(child.getClass()) || !allowedTagNames.contains(childTagName = XmlUtil.getTagLocalName(childElement = (Element)child))) continue;
                if (elements == null) {
                    elements = new ArrayList<Element>();
                }
                elements.add(childElement);
            }
        }
        return elements;
    }

    public static Element element(Element element, String tagName) {
        Element childElement = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength() && childElement == null; ++i) {
            Node child = nodeList.item(i);
            if (!Element.class.isAssignableFrom(child.getClass()) || !XmlUtil.getTagLocalName((Element)child).equals(tagName)) continue;
            childElement = (Element)child;
        }
        return childElement;
    }

    public static List<Element> elements(Element element) {
        NodeList nodeList;
        ArrayList<Element> elements = null;
        if (element != null && (nodeList = element.getChildNodes()) != null && nodeList.getLength() > 0) {
            elements = new ArrayList<Element>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                elements.add((Element)node);
            }
        }
        return elements;
    }

    public static List<Element> elements(Element father, String ns, String localName) {
        ArrayList<Element> matchingElements = new ArrayList<Element>();
        NodeList nl = father.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element) || n.getLocalName() == null || !n.getLocalName().equals(localName) || n.getNamespaceURI() == null || !n.getNamespaceURI().equals(ns)) continue;
            matchingElements.add((Element)n);
        }
        return matchingElements;
    }

    public static List<Element> elementsQName(Element element, Set<QName> allowedTagNames) {
        ArrayList<Element> elements = null;
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element childElement;
                QName childElementQName;
                Node child = nodeList.item(i);
                if (!Element.class.isAssignableFrom(child.getClass()) || !allowedTagNames.contains(childElementQName = new QName((childElement = (Element)child).getNamespaceURI(), childElement.getLocalName()))) continue;
                if (elements == null) {
                    elements = new ArrayList<Element>();
                }
                elements.add(childElement);
            }
        }
        return elements;
    }

    public static Element element(Element element) {
        Element onlyChild = null;
        List<Element> elements = XmlUtil.elements(element);
        if (elements != null) {
            onlyChild = elements.get(0);
        }
        return onlyChild;
    }

    public static String toString(Element element) {
        if (element == null) {
            return "null";
        }
        DOMSource source = new DOMSource(element);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StreamResult result = new StreamResult(printWriter);
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.SEVERE)) {
                LOG.severe("couldn't transform dom element into string representation");
            }
            return "<" + element.getTagName() + " ... >...</" + element.getTagName() + ">";
        }
        printWriter.close();
        return stringWriter.toString();
    }

    public static String getContentText(Element element) {
        StringBuffer buffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof CharacterData)) continue;
            CharacterData characterData = (CharacterData)node;
            buffer.append(characterData.getData());
        }
        return buffer.toString();
    }

    public static boolean isTextOnly(Element element) {
        boolean isTextOnly = true;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength() && isTextOnly; ++i) {
            if (!Element.class.isAssignableFrom(nodeList.item(i).getClass())) continue;
            isTextOnly = false;
        }
        return isTextOnly;
    }

    public static List<Attr> attributes(Element element) {
        NamedNodeMap attributeMap = element.getAttributes();
        if (attributeMap == null || attributeMap.getLength() == 0) {
            return null;
        }
        ArrayList<Attr> attributes = new ArrayList<Attr>();
        for (int i = 0; i < attributeMap.getLength(); ++i) {
            attributes.add((Attr)attributeMap.item(i));
        }
        return attributes;
    }

    public static String getTagLocalName(Element element) {
        if (element == null) {
            return null;
        }
        String localName = element.getLocalName();
        if (localName != null) {
            return localName;
        }
        return element.getTagName();
    }

    public static String attribute(Element element, String attributeName) {
        if (element.hasAttribute(attributeName)) {
            return element.getAttribute(attributeName);
        }
        return null;
    }

    public static String attribute(Element element, String attributeName, boolean required, Parse parse) {
        if (element.hasAttribute(attributeName)) {
            String value = element.getAttribute(attributeName);
            if (required && "".equals(value)) {
                parse.addProblem("attribute <" + XmlUtil.getTagLocalName(element) + " " + attributeName + "=\"\" is empty");
            }
            return value;
        }
        if (required) {
            parse.addProblem("attribute <" + XmlUtil.getTagLocalName(element) + " " + attributeName + "=\"...\" is required");
        }
        return null;
    }

    public static Integer attributeInteger(Element element, String attributeName, boolean required, Parse parse) {
        String valueText = XmlUtil.attribute(element, attributeName, required, parse);
        if (valueText != null) {
            try {
                return Integer.parseInt(valueText);
            }
            catch (NumberFormatException e) {
                parse.addProblem(XmlUtil.errorMessageAttribute(element, attributeName, valueText, "value not parsable as integer"));
            }
        }
        return null;
    }

    public static Boolean attributeBoolean(Element element, String attributeName, boolean required, Parse parse) {
        return XmlUtil.attributeBoolean(element, attributeName, required, parse, null);
    }

    public static Boolean attributeBoolean(Element element, String attributeName, boolean required, Parse parse, Boolean defaultValue) {
        String valueText = XmlUtil.attribute(element, attributeName, required, parse);
        if (valueText != null) {
            Boolean value = XmlUtil.parseBooleanValue(valueText);
            if (value == null) {
                parse.addProblem(XmlUtil.errorMessageAttribute(element, attributeName, valueText, "value not in {true, enabled, on, false, disabled, off}"));
            }
            return value;
        }
        return defaultValue;
    }

    public static Boolean parseBooleanValue(String valueText) {
        if (valueText != null) {
            if ("true".equals(valueText) || "enabled".equals(valueText) || "on".equals(valueText)) {
                return Boolean.TRUE;
            }
            if ("false".equals(valueText) || "disabled".equals(valueText) || "off".equals(valueText)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static String errorMessageAttribute(Element element, String attributeName, String attributeValue, String message) {
        return "attribute <" + XmlUtil.getTagLocalName(element) + " " + attributeName + "=\"" + attributeValue + "\" " + message;
    }

    public static List<String> parseList(Element element, String singularTagName) {
        String text = XmlUtil.attribute(element, singularTagName + "s");
        if ("*".equals(text)) {
            text = null;
        }
        if (element.hasAttribute(singularTagName)) {
            String eventText = element.getAttribute(singularTagName);
            text = text == null ? eventText : text + "," + eventText;
        }
        List<String> eventNames = XmlUtil.parseCommaSeparatedList(text);
        return eventNames;
    }

    public static List<String> parseCommaSeparatedList(String commaSeparatedListText) {
        ArrayList<String> entries = null;
        if (commaSeparatedListText != null && !"*".equals(commaSeparatedListText)) {
            StringTokenizer tokenizer = new StringTokenizer(commaSeparatedListText, ", ");
            while (tokenizer.hasMoreTokens()) {
                if (entries == null) {
                    entries = new ArrayList<String>();
                }
                entries.add(tokenizer.nextToken());
            }
        }
        return entries;
    }

    public static NamespaceValue attributeNamespaceValue(Element element, String attributeName) {
        NamespaceValue namespaceValue = null;
        String text = XmlUtil.attribute(element, attributeName);
        if (text != null) {
            int colonIndex = text.indexOf(58);
            if (colonIndex == -1) {
                namespaceValue = new NamespaceValue(null, text);
            } else {
                String prefix = text.substring(0, colonIndex);
                String localPart = null;
                if (text.length() > colonIndex + 1) {
                    localPart = text.substring(colonIndex + 1);
                }
                namespaceValue = new NamespaceValue(prefix, localPart);
            }
        }
        return namespaceValue;
    }

    public static QName attributeQName(Element element, String attributeName) {
        QName qname = null;
        NamespaceValue namespaceValue = XmlUtil.attributeNamespaceValue(element, attributeName);
        String text = XmlUtil.attribute(element, attributeName);
        if (namespaceValue != null) {
            if (namespaceValue.prefix == null) {
                qname = new QName(text);
            } else {
                String uri = element.lookupNamespaceURI(namespaceValue.prefix);
                if (uri == null) {
                    String message = ExceptionManager.getInstance().getFullMessage("bp_XU_1", text);
                    throw new BonitaRuntimeException(message);
                }
                if (namespaceValue.localPart == null) {
                    String message = ExceptionManager.getInstance().getFullMessage("bp_XU_2", text);
                    throw new BonitaRuntimeException(message);
                }
                qname = new QName(uri, namespaceValue.localPart, namespaceValue.prefix);
            }
        }
        return qname;
    }

    public static QName getQNameFromString(Element element, String qnameAsString) {
        if (qnameAsString == null || element == null) {
            return null;
        }
        int colonIndex = qnameAsString.indexOf(58);
        String prefix = qnameAsString.substring(0, colonIndex);
        String localName = qnameAsString.substring(colonIndex + 1);
        String ns = XmlUtil.getNamespaceURI(element, prefix);
        return new QName(ns, localName, prefix);
    }

    public static String getNamespaceURI(Node n, String prefix) {
        Node prefixDeclaration = n.getAttributes().getNamedItem("xmlns:" + prefix);
        if (prefixDeclaration != null) {
            return prefixDeclaration.getNodeValue();
        }
        return XmlUtil.getNamespaceURI(n.getParentNode(), prefix);
    }

    public static class NamespaceValue {
        public String prefix;
        public String localPart;

        public NamespaceValue(String prefix, String localPart) {
            this.prefix = prefix;
            this.localPart = localPart;
        }
    }
}

