/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ahc;

import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import java.net.URI;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.camel.AsyncEndpoint;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.ahc.AhcBinding;
import org.apache.camel.component.ahc.AhcComponent;
import org.apache.camel.component.ahc.AhcProducer;
import org.apache.camel.component.ahc.HttpHeaderFilterStrategy;
import org.apache.camel.http.common.cookie.CookieHandler;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.HeaderFilterStrategyAware;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;

@UriEndpoint(firstVersion="2.8.0", scheme="ahc", title="AHC", syntax="ahc:httpUri", producerOnly=true, label="http", lenientProperties=true)
public class AhcEndpoint
extends DefaultEndpoint
implements AsyncEndpoint,
HeaderFilterStrategyAware {
    private AsyncHttpClient client;
    @UriPath
    @Metadata(required="true")
    private URI httpUri;
    @UriParam
    private boolean bridgeEndpoint;
    @UriParam(defaultValue="true")
    private boolean throwExceptionOnFailure = true;
    @UriParam
    private boolean transferException;
    @UriParam(defaultValue="4096")
    private int bufferSize = 4096;
    @UriParam
    private HeaderFilterStrategy headerFilterStrategy = new HttpHeaderFilterStrategy();
    @UriParam(label="advanced")
    private AhcBinding binding;
    @UriParam(label="security")
    private SSLContextParameters sslContextParameters;
    @UriParam(label="advanced")
    private AsyncHttpClientConfig clientConfig;
    @UriParam(label="advanced", prefix="clientConfig.", multiValue=true)
    private Map<String, Object> clientConfigOptions;
    @UriParam(label="advanced,security", prefix="clientConfig.realm.", multiValue=true)
    private Map<String, Object> clientConfigRealmOptions;
    @UriParam(label="producer", defaultValue="false")
    private boolean connectionClose;
    @UriParam(label="producer")
    private CookieHandler cookieHandler;

    public AhcEndpoint(String endpointUri, AhcComponent component, URI httpUri) {
        super(endpointUri, (Component)component);
        this.httpUri = httpUri;
    }

    public AhcComponent getComponent() {
        return (AhcComponent)super.getComponent();
    }

    public Producer createProducer() throws Exception {
        ObjectHelper.notNull((Object)this.client, (String)"AsyncHttpClient", (Object)((Object)this));
        ObjectHelper.notNull((Object)this.httpUri, (String)"HttpUri", (Object)((Object)this));
        ObjectHelper.notNull((Object)this.binding, (String)"AhcBinding", (Object)((Object)this));
        return new AhcProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("This component does not support consuming from this endpoint");
    }

    public boolean isLenientProperties() {
        return true;
    }

    public boolean isSingleton() {
        return true;
    }

    public AsyncHttpClient getClient() {
        return this.client;
    }

    public void setClient(AsyncHttpClient client) {
        this.client = client;
    }

    public AsyncHttpClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(AsyncHttpClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public URI getHttpUri() {
        return this.httpUri;
    }

    public void setHttpUri(URI httpUri) {
        this.httpUri = httpUri;
    }

    public AhcBinding getBinding() {
        return this.binding;
    }

    public void setBinding(AhcBinding binding) {
        this.binding = binding;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public boolean isBridgeEndpoint() {
        return this.bridgeEndpoint;
    }

    public void setBridgeEndpoint(boolean bridgeEndpoint) {
        this.bridgeEndpoint = bridgeEndpoint;
    }

    public boolean isThrowExceptionOnFailure() {
        return this.throwExceptionOnFailure;
    }

    public void setThrowExceptionOnFailure(boolean throwExceptionOnFailure) {
        this.throwExceptionOnFailure = throwExceptionOnFailure;
    }

    public boolean isTransferException() {
        return this.transferException;
    }

    public void setTransferException(boolean transferException) {
        this.transferException = transferException;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public Map<String, Object> getClientConfigOptions() {
        return this.clientConfigOptions;
    }

    public void setClientConfigOptions(Map<String, Object> clientConfigOptions) {
        this.clientConfigOptions = clientConfigOptions;
    }

    public Map<String, Object> getClientConfigRealmOptions() {
        return this.clientConfigRealmOptions;
    }

    public void setClientConfigRealmOptions(Map<String, Object> clientConfigRealmOptions) {
        this.clientConfigRealmOptions = clientConfigRealmOptions;
    }

    public boolean isConnectionClose() {
        return this.connectionClose;
    }

    public void setConnectionClose(boolean connectionClose) {
        this.connectionClose = connectionClose;
    }

    public CookieHandler getCookieHandler() {
        return this.cookieHandler;
    }

    public void setCookieHandler(CookieHandler cookieHandler) {
        this.cookieHandler = cookieHandler;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.client == null) {
            DefaultAsyncHttpClientConfig config = null;
            if (this.clientConfig != null) {
                DefaultAsyncHttpClientConfig.Builder builder = AhcComponent.cloneConfig(this.clientConfig);
                if (this.sslContextParameters != null) {
                    SSLContext sslContext = this.sslContextParameters.createSSLContext(this.getCamelContext());
                    JdkSslContext ssl = new JdkSslContext(sslContext, true, ClientAuth.REQUIRE);
                    builder.setSslContext(ssl);
                }
                config = builder.build();
            } else if (this.sslContextParameters != null) {
                DefaultAsyncHttpClientConfig.Builder builder = new DefaultAsyncHttpClientConfig.Builder();
                SSLContext sslContext = this.sslContextParameters.createSSLContext(this.getCamelContext());
                JdkSslContext ssl = new JdkSslContext(sslContext, true, ClientAuth.REQUIRE);
                builder.setSslContext(ssl);
                config = builder.build();
            }
            this.client = this.createClient(config);
        }
    }

    protected AsyncHttpClient createClient(AsyncHttpClientConfig config) {
        if (config == null) {
            return new DefaultAsyncHttpClient();
        }
        return new DefaultAsyncHttpClient(config);
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.client != null && !this.client.isClosed()) {
            this.client.close();
        }
        this.client = null;
    }
}

