/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.AsyncHttpClientState;
import org.asynchttpclient.handler.AsyncHandlerExtensions;
import org.asynchttpclient.handler.AsyncHandlerExtensionsUtils;
import org.asynchttpclient.netty.SimpleChannelFutureListener;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.channel.NettyConnectListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyChannelConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyChannelConnector.class);
    private final AsyncHandlerExtensions asyncHandlerExtensions;
    private final InetSocketAddress localAddress;
    private final List<InetSocketAddress> remoteAddresses;
    private final AsyncHttpClientState clientState;
    private final boolean connectionTtlEnabled;
    private volatile int i = 0;

    public NettyChannelConnector(InetAddress localAddress, List<InetSocketAddress> remoteAddresses, AsyncHandler<?> asyncHandler, AsyncHttpClientState clientState, AsyncHttpClientConfig config) {
        this.localAddress = localAddress != null ? new InetSocketAddress(localAddress, 0) : null;
        this.remoteAddresses = remoteAddresses;
        this.asyncHandlerExtensions = AsyncHandlerExtensionsUtils.toAsyncHandlerExtensions(asyncHandler);
        this.clientState = clientState;
        this.connectionTtlEnabled = config.getConnectionTtl() > 0;
    }

    private boolean pickNextRemoteAddress() {
        ++this.i;
        return this.i < this.remoteAddresses.size();
    }

    public void connect(Bootstrap bootstrap, NettyConnectListener<?> connectListener) {
        InetSocketAddress remoteAddress = this.remoteAddresses.get(this.i);
        if (this.asyncHandlerExtensions != null) {
            this.asyncHandlerExtensions.onTcpConnectAttempt(remoteAddress);
        }
        try {
            this.connect0(bootstrap, connectListener, remoteAddress);
        }
        catch (RejectedExecutionException e) {
            if (this.clientState.isClosed()) {
                LOGGER.info("Connect crash but engine is shutting down");
            }
            connectListener.onFailure(null, e);
        }
    }

    private void connect0(final Bootstrap bootstrap, final NettyConnectListener<?> connectListener, final InetSocketAddress remoteAddress) {
        bootstrap.connect(remoteAddress, this.localAddress).addListener(new SimpleChannelFutureListener(){

            @Override
            public void onSuccess(Channel channel) {
                if (NettyChannelConnector.this.asyncHandlerExtensions != null) {
                    NettyChannelConnector.this.asyncHandlerExtensions.onTcpConnectSuccess(remoteAddress, channel);
                }
                if (NettyChannelConnector.this.connectionTtlEnabled) {
                    Channels.initChannelId(channel);
                }
                connectListener.onSuccess(channel, remoteAddress);
            }

            @Override
            public void onFailure(Channel channel, Throwable t) {
                boolean retry;
                if (NettyChannelConnector.this.asyncHandlerExtensions != null) {
                    NettyChannelConnector.this.asyncHandlerExtensions.onTcpConnectFailure(remoteAddress, t);
                }
                if (retry = NettyChannelConnector.this.pickNextRemoteAddress()) {
                    NettyChannelConnector.this.connect(bootstrap, connectListener);
                } else {
                    connectListener.onFailure(channel, t);
                }
            }
        });
    }
}

