/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.resolver;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.Request;
import org.asynchttpclient.handler.AsyncHandlerExtensions;
import org.asynchttpclient.handler.AsyncHandlerExtensionsUtils;
import org.asynchttpclient.netty.SimpleFutureListener;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.uri.Uri;

public enum RequestHostnameResolver {
    INSTANCE;


    public Future<List<InetSocketAddress>> resolve(Request request, ProxyServer proxy, AsyncHandler<?> asyncHandler) {
        int port;
        String name;
        AsyncHandlerExtensions asyncHandlerExtensions;
        Uri uri = request.getUri();
        final Promise<List<InetSocketAddress>> promise = ImmediateEventExecutor.INSTANCE.newPromise();
        if (request.getAddress() != null) {
            List<InetSocketAddress> resolved = Collections.singletonList(new InetSocketAddress(request.getAddress(), uri.getExplicitPort()));
            return promise.setSuccess(resolved);
        }
        AsyncHandlerExtensions asyncHandlerExtensions2 = asyncHandlerExtensions = request.getAddress() == null ? AsyncHandlerExtensionsUtils.toAsyncHandlerExtensions(asyncHandler) : null;
        if (proxy != null && !proxy.isIgnoredForHost(uri.getHost())) {
            name = proxy.getHost();
            port = uri.isSecured() ? proxy.getSecuredPort() : proxy.getPort();
        } else {
            name = uri.getHost();
            port = uri.getExplicitPort();
        }
        if (asyncHandlerExtensions != null) {
            asyncHandlerExtensions.onHostnameResolutionAttempt(name);
        }
        Future<List<InetAddress>> whenResolved = request.getNameResolver().resolveAll(name);
        whenResolved.addListener((GenericFutureListener<Future<List<InetAddress>>>)new SimpleFutureListener<List<InetAddress>>(){

            @Override
            protected void onSuccess(List<InetAddress> value) throws Exception {
                ArrayList<InetSocketAddress> socketAddresses = new ArrayList<InetSocketAddress>(value.size());
                for (InetAddress a : value) {
                    socketAddresses.add(new InetSocketAddress(a, port));
                }
                if (asyncHandlerExtensions != null) {
                    asyncHandlerExtensions.onHostnameResolutionSuccess(name, socketAddresses);
                }
                promise.trySuccess(socketAddresses);
            }

            @Override
            protected void onFailure(Throwable t) throws Exception {
                if (asyncHandlerExtensions != null) {
                    asyncHandlerExtensions.onHostnameResolutionFailure(name, t);
                }
                promise.tryFailure(t);
            }
        });
        return promise;
    }
}

