/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import java.io.IOException;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;

final class SwitchingSSLFilter
extends SSLFilter {
    private final boolean secureByDefault;
    final Attribute<Boolean> CONNECTION_IS_SECURE = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(SwitchingSSLFilter.class.getName());

    SwitchingSSLFilter(SSLEngineConfigurator clientConfig, boolean secureByDefault) {
        super(null, clientConfig);
        this.secureByDefault = secureByDefault;
    }

    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        if (event.type() == SSLSwitchingEvent.class) {
            SSLSwitchingEvent se = (SSLSwitchingEvent)event;
            this.CONNECTION_IS_SECURE.set((AttributeStorage)se.connection, (Object)se.secure);
            return ctx.getStopAction();
        }
        return ctx.getInvokeAction();
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        if (this.isSecure(ctx.getConnection())) {
            return super.handleRead(ctx);
        }
        return ctx.getInvokeAction();
    }

    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        if (this.isSecure(ctx.getConnection())) {
            return super.handleWrite(ctx);
        }
        return ctx.getInvokeAction();
    }

    public void onFilterChainChanged(FilterChain filterChain) {
    }

    public void onAdded(FilterChain filterChain) {
    }

    public void onRemoved(FilterChain filterChain) {
    }

    private boolean isSecure(Connection c) {
        Boolean secStatus = (Boolean)this.CONNECTION_IS_SECURE.get((AttributeStorage)c);
        if (secStatus == null) {
            secStatus = this.secureByDefault;
        }
        return secStatus;
    }

    static final class SSLSwitchingEvent
    implements FilterChainEvent {
        final boolean secure;
        final Connection connection;

        SSLSwitchingEvent(boolean secure, Connection c) {
            this.secure = secure;
            this.connection = c;
        }

        public Object type() {
            return SSLSwitchingEvent.class;
        }
    }
}

