/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ahc.ws;

import java.io.InputStream;
import java.io.Reader;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.ahc.ws.WsEndpoint;
import org.apache.camel.support.DefaultConsumer;

public class WsConsumer
extends DefaultConsumer {
    public WsConsumer(WsEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        this.getEndpoint().connect(this);
    }

    @Override
    public void doStop() throws Exception {
        this.getEndpoint().disconnect(this);
        super.doStop();
    }

    @Override
    public WsEndpoint getEndpoint() {
        return (WsEndpoint)super.getEndpoint();
    }

    public void sendMessage(String message) {
        this.sendMessageInternal(message);
    }

    public void sendMessage(Throwable throwable) {
        this.sendMessageInternal(throwable);
    }

    public void sendMessage(byte[] message) {
        this.sendMessageInternal(message);
    }

    public void sendMessage(InputStream message) {
        this.sendMessageInternal(message);
    }

    public void sendMessage(Reader message) {
        this.sendMessageInternal(message);
    }

    private void sendMessageInternal(Object message) {
        Exchange exchange = this.createExchange(true);
        if (message instanceof Throwable) {
            exchange.setException((Throwable)message);
        } else {
            exchange.getIn().setBody(message);
        }
        AsyncCallback cb = this.defaultConsumerCallback(exchange, true);
        this.getAsyncProcessor().process(exchange, cb);
    }
}

