/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.base;

import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public final class HttpHelper {
    private HttpHelper() {
    }

    public static boolean isSecureConnection(String uri) {
        return uri.startsWith("https");
    }

    public static int[] parserHttpVersion(String s) throws ProtocolException {
        int minor;
        int major;
        if (s == null) {
            throw new IllegalArgumentException("String may not be null");
        }
        if (!s.startsWith("HTTP/")) {
            throw new ProtocolException("Invalid HTTP version string: " + s);
        }
        int i1 = "HTTP/".length();
        int i2 = s.indexOf(46, i1);
        if (i2 == -1) {
            throw new ProtocolException("Invalid HTTP version number: " + s);
        }
        try {
            major = Integer.parseInt(s.substring(i1, i2));
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Invalid HTTP major version number: " + s);
        }
        i1 = i2 + 1;
        i2 = s.length();
        try {
            minor = Integer.parseInt(s.substring(i1, i2));
        }
        catch (NumberFormatException e) {
            throw new ProtocolException("Invalid HTTP minor version number: " + s);
        }
        return new int[]{major, minor};
    }

    public static void setCharsetFromContentType(String contentType, Exchange exchange) {
        String charset;
        if (contentType != null && (charset = IOHelper.getCharsetNameFromContentType(contentType)) != null) {
            exchange.setProperty(ExchangePropertyKey.CHARSET_NAME, (Object)charset);
        }
    }

    @Deprecated
    public static String getCharsetFromContentType(String contentType) {
        int index;
        if (contentType != null && (index = contentType.indexOf("charset=")) > 0) {
            String charset = contentType.substring(index + 8);
            if (charset.contains(";")) {
                charset = StringHelper.before(charset, ";");
            }
            return IOHelper.normalizeCharset(charset);
        }
        return null;
    }

    public static void appendHeader(Map<String, Object> headers, String key, Object value) {
        if (headers.containsKey(key)) {
            ArrayList<Object> list;
            Object existing = headers.get(key);
            if (existing instanceof List) {
                list = (ArrayList<Object>)existing;
            } else {
                list = new ArrayList<Object>();
                list.add(existing);
            }
            list.add(value);
            value = list;
        }
        headers.put(key, value);
    }

    public static Object extractHttpParameterValue(String value) {
        if (value == null || ObjectHelper.isEmpty(value)) {
            return value;
        }
        String trimmed = value.trim();
        if (trimmed.startsWith("[") && trimmed.endsWith("]")) {
            String[] values;
            trimmed = trimmed.substring(1, trimmed.length() - 1);
            ArrayList<String> list = new ArrayList<String>();
            for (String s : values = trimmed.split(",")) {
                list.add(s.trim());
            }
            return list;
        }
        return value;
    }

    public static boolean isStatusCodeOk(int statusCode, String okStatusCodeRange) {
        String[] ranges;
        for (String range : ranges = okStatusCodeRange.split(",")) {
            boolean ok;
            if (range.contains("-")) {
                int from = Integer.parseInt(StringHelper.before(range, "-"));
                int to = Integer.parseInt(StringHelper.after(range, "-"));
                ok = statusCode >= from && statusCode <= to;
            } else {
                int exact = Integer.parseInt(range);
                boolean bl = ok = exact == statusCode;
            }
            if (!ok) continue;
            return true;
        }
        return false;
    }
}

