/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Ordered;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Service;
import org.apache.camel.StartupListener;
import org.apache.camel.support.service.ServiceHelper;

public class DeferServiceStartupListener
implements StartupListener,
Ordered {
    private final Set<Service> earlyServices = new CopyOnWriteArraySet<Service>();
    private final Set<Service> services = new CopyOnWriteArraySet<Service>();

    public void addService(Service service, boolean startEarly) {
        if (startEarly) {
            this.earlyServices.add(service);
        } else {
            this.services.add(service);
        }
    }

    @Override
    public void onCamelContextStarting(CamelContext context, boolean alreadyStarted) throws Exception {
        this.doStart(this.earlyServices, context, alreadyStarted);
    }

    @Override
    public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
        this.doStart(this.services, context, alreadyStarted);
    }

    protected void doStart(Set<Service> services, CamelContext context, boolean alreadyStarted) throws Exception {
        while (!services.isEmpty()) {
            Service service = services.iterator().next();
            try {
                ServiceHelper.startService((Object)service);
            }
            catch (Exception e) {
                if (service instanceof Endpoint) {
                    Endpoint endpoint = (Endpoint)service;
                    throw new ResolveEndpointFailedException(endpoint.getEndpointUri(), e);
                }
                throw e;
            }
            finally {
                services.remove(service);
            }
        }
    }

    @Override
    public int getOrder() {
        return 2147482647;
    }
}

