/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Ordered;
import org.apache.camel.VetoCamelContextStartException;
import org.apache.camel.spi.AutowiredLifecycleStrategy;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.LifecycleStrategySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainAutowiredLifecycleStrategy
extends LifecycleStrategySupport
implements AutowiredLifecycleStrategy,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(MainAutowiredLifecycleStrategy.class);
    private final Map<String, Component> autowrieComponents = new HashMap<String, Component>();
    private final Map<String, DataFormat> autowrieDataFormats = new HashMap<String, DataFormat>();
    private final Map<String, Language> autowrieLanguages = new HashMap<String, Language>();
    private final ExtendedCamelContext camelContext;
    private volatile boolean initializing;

    public MainAutowiredLifecycleStrategy(CamelContext camelContext) {
        this.camelContext = (ExtendedCamelContext)camelContext;
    }

    @Override
    public int getOrder() {
        return 2147482647;
    }

    @Override
    public void onContextInitializing(CamelContext context) throws VetoCamelContextStartException {
        this.autowrieComponents.forEach(this::autowireComponent);
        this.autowrieDataFormats.forEach(this::autowireDataFormat);
        this.autowrieLanguages.forEach(this::autowireLanguage);
        this.autowrieComponents.clear();
        this.autowrieDataFormats.clear();
        this.autowrieLanguages.clear();
        this.initializing = true;
    }

    @Override
    public void onContextStopped(CamelContext context) {
        this.initializing = false;
    }

    @Override
    public void onComponentAdd(String name, Component component) {
        if (this.initializing) {
            this.autowireComponent(name, component);
        } else {
            this.autowrieComponents.put(name, component);
        }
    }

    @Override
    public void onDataFormatCreated(String name, DataFormat dataFormat) {
        if (this.initializing) {
            this.autowireDataFormat(name, dataFormat);
        } else {
            this.autowrieDataFormats.put(name, dataFormat);
        }
    }

    @Override
    public void onLanguageCreated(String name, Language language) {
        if (this.initializing) {
            this.autowireLanguage(name, language);
        } else {
            this.autowrieLanguages.put(name, language);
        }
    }

    private void autowireComponent(String name, Component component) {
        boolean enabled;
        boolean bl = enabled = this.camelContext.isAutowiredEnabled() != false && component.isAutowiredEnabled();
        if (enabled) {
            this.autwire(name, "component", component);
        }
    }

    private void autowireDataFormat(String name, DataFormat dataFormat) {
        boolean enabled = this.camelContext.isAutowiredEnabled();
        if (enabled) {
            this.autwire(name, "dataformat", dataFormat);
        }
    }

    private void autowireLanguage(String name, Language language) {
        boolean enabled = this.camelContext.isAutowiredEnabled();
        if (enabled) {
            this.autwire(name, "language", language);
        }
    }

    private void autwire(String name, String kind, Object target) {
        PropertyConfigurerGetter getter;
        String[] names;
        PropertyConfigurer pc = this.camelContext.getConfigurerResolver().resolvePropertyConfigurer(name + "-" + kind, this.camelContext);
        if (pc instanceof PropertyConfigurerGetter && (names = (getter = (PropertyConfigurerGetter)((Object)pc)).getAutowiredNames()) != null) {
            for (String option : names) {
                boolean hit;
                Set<?> set;
                Object value = getter.getOptionValue(target, option, true);
                if (value != null) continue;
                Class<?> type = getter.getOptionType(option, true);
                if (type != null && (set = this.camelContext.getRegistry().findByType(type)).size() == 1) {
                    value = set.iterator().next();
                }
                if (value == null || !(hit = pc.configure(this.camelContext, target, option, value, true))) continue;
                LOG.info("Autowired property: {} on {}: {} as exactly one instance of type: {} ({}) found in the registry", new Object[]{option, kind, name, type.getName(), value.getClass().getName()});
            }
        }
    }
}

