/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileProcessStrategy;
import org.apache.camel.component.file.GenericFileProcessStrategyFactory;
import org.apache.camel.component.file.strategy.FileChangedExclusiveReadLockStrategy;
import org.apache.camel.component.file.strategy.FileIdempotentChangedRepositoryReadLockStrategy;
import org.apache.camel.component.file.strategy.FileIdempotentRenameRepositoryReadLockStrategy;
import org.apache.camel.component.file.strategy.FileIdempotentRepositoryReadLockStrategy;
import org.apache.camel.component.file.strategy.FileLockExclusiveReadLockStrategy;
import org.apache.camel.component.file.strategy.FileRenameExclusiveReadLockStrategy;
import org.apache.camel.component.file.strategy.GenericFileDeleteProcessStrategy;
import org.apache.camel.component.file.strategy.GenericFileExpressionRenamer;
import org.apache.camel.component.file.strategy.GenericFileRenameProcessStrategy;
import org.apache.camel.component.file.strategy.MarkerFileExclusiveReadLockStrategy;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.Language;
import org.apache.camel.util.ObjectHelper;

public final class FileProcessStrategyFactory
implements GenericFileProcessStrategyFactory<File> {
    @Override
    public GenericFileProcessStrategy<File> createGenericFileProcessStrategy(CamelContext context, Map<String, Object> params) {
        boolean isMove;
        Expression moveExpression = (Expression)params.get("move");
        Expression moveFailedExpression = (Expression)params.get("moveFailed");
        Expression preMoveExpression = (Expression)params.get("preMove");
        boolean isNoop = params.get("noop") != null;
        boolean isDelete = params.get("delete") != null;
        boolean bl = isMove = moveExpression != null || preMoveExpression != null || moveFailedExpression != null;
        if (isDelete) {
            GenericFileExpressionRenamer renamer;
            GenericFileDeleteProcessStrategy<File> strategy = new GenericFileDeleteProcessStrategy<File>();
            strategy.setExclusiveReadLockStrategy(FileProcessStrategyFactory.getExclusiveReadLockStrategy(params));
            if (preMoveExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(preMoveExpression);
                strategy.setBeginRenamer(renamer);
            }
            if (moveFailedExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(moveFailedExpression);
                strategy.setFailureRenamer(renamer);
            }
            return strategy;
        }
        if (isMove || isNoop) {
            GenericFileExpressionRenamer renamer;
            GenericFileRenameProcessStrategy<File> strategy = new GenericFileRenameProcessStrategy<File>();
            strategy.setExclusiveReadLockStrategy(FileProcessStrategyFactory.getExclusiveReadLockStrategy(params));
            if (!isNoop) {
                if (moveExpression != null) {
                    renamer = new GenericFileExpressionRenamer();
                    renamer.setExpression(moveExpression);
                    strategy.setCommitRenamer(renamer);
                } else {
                    strategy.setCommitRenamer(FileProcessStrategyFactory.getDefaultCommitRenamer(context));
                }
            }
            if (preMoveExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(preMoveExpression);
                strategy.setBeginRenamer(renamer);
            }
            if (moveFailedExpression != null) {
                renamer = new GenericFileExpressionRenamer();
                renamer.setExpression(moveFailedExpression);
                strategy.setFailureRenamer(renamer);
            }
            return strategy;
        }
        GenericFileRenameProcessStrategy<File> strategy = new GenericFileRenameProcessStrategy<File>();
        strategy.setExclusiveReadLockStrategy(FileProcessStrategyFactory.getExclusiveReadLockStrategy(params));
        strategy.setCommitRenamer(FileProcessStrategyFactory.getDefaultCommitRenamer(context));
        return strategy;
    }

    private static GenericFileExpressionRenamer<File> getDefaultCommitRenamer(CamelContext context) {
        Language language = context.resolveLanguage("file");
        Expression expression = language.createExpression("${file:parent}/.camel/${file:onlyname}");
        return new GenericFileExpressionRenamer<File>(expression);
    }

    private static GenericFileExclusiveReadLockStrategy<File> getExclusiveReadLockStrategy(Map<String, Object> params) {
        GenericFileExclusiveReadLockStrategy<File> strategy = (GenericFileExclusiveReadLockStrategy<File>)params.get("exclusiveReadLockStrategy");
        if (strategy != null) {
            return strategy;
        }
        String readLock = (String)params.get("readLock");
        if (ObjectHelper.isNotEmpty(readLock)) {
            IdempotentRepository repo;
            Boolean readLockRemoveOnCommit;
            Boolean readLockRemoveOnRollback;
            GenericFileExclusiveReadLockStrategy<File> readLockStrategy;
            if ("none".equals(readLock) || "false".equals(readLock)) {
                return null;
            }
            if ("markerFile".equals(readLock)) {
                strategy = new MarkerFileExclusiveReadLockStrategy();
            } else if ("fileLock".equals(readLock)) {
                strategy = new FileLockExclusiveReadLockStrategy();
            } else if ("rename".equals(readLock)) {
                strategy = new FileRenameExclusiveReadLockStrategy();
            } else if ("changed".equals(readLock)) {
                Long minAge;
                readLockStrategy = new FileChangedExclusiveReadLockStrategy();
                Long minLength = (Long)params.get("readLockMinLength");
                if (minLength != null) {
                    ((FileChangedExclusiveReadLockStrategy)readLockStrategy).setMinLength(minLength);
                }
                if (null != (minAge = (Long)params.get("readLockMinAge"))) {
                    ((FileChangedExclusiveReadLockStrategy)readLockStrategy).setMinAge(minAge);
                }
                strategy = readLockStrategy;
            } else if ("idempotent".equals(readLock)) {
                ScheduledExecutorService readLockIdempotentReleaseExecutorService;
                Integer readLockIdempotentReleaseAsyncPoolSize;
                Boolean readLockIdempotentReleaseAsync;
                Integer readLockIdempotentReleaseDelay;
                readLockStrategy = new FileIdempotentRepositoryReadLockStrategy();
                readLockRemoveOnRollback = (Boolean)params.get("readLockRemoveOnRollback");
                if (readLockRemoveOnRollback != null) {
                    ((FileIdempotentRepositoryReadLockStrategy)readLockStrategy).setRemoveOnRollback(readLockRemoveOnRollback);
                }
                if ((readLockRemoveOnCommit = (Boolean)params.get("readLockRemoveOnCommit")) != null) {
                    ((FileIdempotentRepositoryReadLockStrategy)readLockStrategy).setRemoveOnCommit(readLockRemoveOnCommit);
                }
                if ((repo = (IdempotentRepository)params.get("readLockIdempotentRepository")) != null) {
                    ((FileIdempotentRepositoryReadLockStrategy)readLockStrategy).setIdempotentRepository(repo);
                }
                if ((readLockIdempotentReleaseDelay = (Integer)params.get("readLockIdempotentReleaseDelay")) != null) {
                    ((FileIdempotentRepositoryReadLockStrategy)readLockStrategy).setReadLockIdempotentReleaseDelay(readLockIdempotentReleaseDelay);
                }
                if ((readLockIdempotentReleaseAsync = (Boolean)params.get("readLockIdempotentReleaseAsync")) != null) {
                    ((FileIdempotentRepositoryReadLockStrategy)readLockStrategy).setReadLockIdempotentReleaseAsync(readLockIdempotentReleaseAsync);
                }
                if ((readLockIdempotentReleaseAsyncPoolSize = (Integer)params.get("readLockIdempotentReleaseAsyncPoolSize")) != null) {
                    ((FileIdempotentRepositoryReadLockStrategy)readLockStrategy).setReadLockIdempotentReleaseAsyncPoolSize(readLockIdempotentReleaseAsyncPoolSize);
                }
                if ((readLockIdempotentReleaseExecutorService = (ScheduledExecutorService)params.get("readLockIdempotentReleaseExecutorService")) != null) {
                    ((FileIdempotentRepositoryReadLockStrategy)readLockStrategy).setReadLockIdempotentReleaseExecutorService(readLockIdempotentReleaseExecutorService);
                }
                strategy = readLockStrategy;
            } else if ("idempotent-changed".equals(readLock)) {
                ScheduledExecutorService readLockIdempotentReleaseExecutorService;
                Integer readLockIdempotentReleaseAsyncPoolSize;
                Boolean readLockIdempotentReleaseAsync;
                Integer readLockIdempotentReleaseDelay;
                Long minAge;
                Long minLength;
                readLockStrategy = new FileIdempotentChangedRepositoryReadLockStrategy();
                readLockRemoveOnRollback = (Boolean)params.get("readLockRemoveOnRollback");
                if (readLockRemoveOnRollback != null) {
                    ((FileIdempotentChangedRepositoryReadLockStrategy)readLockStrategy).setRemoveOnRollback(readLockRemoveOnRollback);
                }
                if ((readLockRemoveOnCommit = (Boolean)params.get("readLockRemoveOnCommit")) != null) {
                    ((FileIdempotentChangedRepositoryReadLockStrategy)readLockStrategy).setRemoveOnCommit(readLockRemoveOnCommit);
                }
                if ((repo = (IdempotentRepository)params.get("readLockIdempotentRepository")) != null) {
                    ((FileIdempotentChangedRepositoryReadLockStrategy)readLockStrategy).setIdempotentRepository(repo);
                }
                if ((minLength = (Long)params.get("readLockMinLength")) != null) {
                    ((FileIdempotentChangedRepositoryReadLockStrategy)readLockStrategy).setMinLength(minLength);
                }
                if (null != (minAge = (Long)params.get("readLockMinAge"))) {
                    ((FileIdempotentChangedRepositoryReadLockStrategy)readLockStrategy).setMinAge(minAge);
                }
                if ((readLockIdempotentReleaseDelay = (Integer)params.get("readLockIdempotentReleaseDelay")) != null) {
                    ((FileIdempotentChangedRepositoryReadLockStrategy)readLockStrategy).setReadLockIdempotentReleaseDelay(readLockIdempotentReleaseDelay);
                }
                if ((readLockIdempotentReleaseAsync = (Boolean)params.get("readLockIdempotentReleaseAsync")) != null) {
                    ((FileIdempotentChangedRepositoryReadLockStrategy)readLockStrategy).setReadLockIdempotentReleaseAsync(readLockIdempotentReleaseAsync);
                }
                if ((readLockIdempotentReleaseAsyncPoolSize = (Integer)params.get("readLockIdempotentReleaseAsyncPoolSize")) != null) {
                    ((FileIdempotentChangedRepositoryReadLockStrategy)readLockStrategy).setReadLockIdempotentReleaseAsyncPoolSize(readLockIdempotentReleaseAsyncPoolSize);
                }
                if ((readLockIdempotentReleaseExecutorService = (ScheduledExecutorService)params.get("readLockIdempotentReleaseExecutorService")) != null) {
                    ((FileIdempotentChangedRepositoryReadLockStrategy)readLockStrategy).setReadLockIdempotentReleaseExecutorService(readLockIdempotentReleaseExecutorService);
                }
                strategy = readLockStrategy;
            } else if ("idempotent-rename".equals(readLock)) {
                readLockStrategy = new FileIdempotentRenameRepositoryReadLockStrategy();
                readLockRemoveOnRollback = (Boolean)params.get("readLockRemoveOnRollback");
                if (readLockRemoveOnRollback != null) {
                    ((FileIdempotentRenameRepositoryReadLockStrategy)readLockStrategy).setRemoveOnRollback(readLockRemoveOnRollback);
                }
                if ((readLockRemoveOnCommit = (Boolean)params.get("readLockRemoveOnCommit")) != null) {
                    ((FileIdempotentRenameRepositoryReadLockStrategy)readLockStrategy).setRemoveOnCommit(readLockRemoveOnCommit);
                }
                if ((repo = (IdempotentRepository)params.get("readLockIdempotentRepository")) != null) {
                    ((FileIdempotentRenameRepositoryReadLockStrategy)readLockStrategy).setIdempotentRepository(repo);
                }
                strategy = readLockStrategy;
            }
            if (strategy != null) {
                Boolean readLockDeleteOrphanLockFiles;
                Boolean readLockMarkerFile;
                LoggingLevel readLockLoggingLevel;
                Long checkInterval;
                Long timeout = (Long)params.get("readLockTimeout");
                if (timeout != null) {
                    strategy.setTimeout(timeout);
                }
                if ((checkInterval = (Long)params.get("readLockCheckInterval")) != null) {
                    strategy.setCheckInterval(checkInterval);
                }
                if ((readLockLoggingLevel = (LoggingLevel)((Object)params.get("readLockLoggingLevel"))) != null) {
                    strategy.setReadLockLoggingLevel(readLockLoggingLevel);
                }
                if ((readLockMarkerFile = (Boolean)params.get("readLockMarkerFile")) != null) {
                    strategy.setMarkerFiler(readLockMarkerFile);
                }
                if ((readLockDeleteOrphanLockFiles = (Boolean)params.get("readLockDeleteOrphanLockFiles")) != null) {
                    strategy.setDeleteOrphanLockFiles(readLockDeleteOrphanLockFiles);
                }
            }
        }
        return strategy;
    }
}

