/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import java.util.Locale;
import org.apache.camel.spi.PropertiesFunction;
import org.apache.camel.util.StringHelper;

public class ServiceHostPropertiesFunction
implements PropertiesFunction {
    private static final String HOST_PREFIX = "_SERVICE_HOST";

    @Override
    public String getName() {
        return "service.host";
    }

    @Override
    public String apply(String remainder) {
        String key = remainder;
        String defaultValue = null;
        if (remainder.contains(":")) {
            key = StringHelper.before(remainder, ":");
            defaultValue = StringHelper.after(remainder, ":");
        }
        if (key != null) {
            String host = System.getenv((key = key.toUpperCase(Locale.ENGLISH).replace('-', '_')) + HOST_PREFIX);
            if (host != null) {
                return host;
            }
            return defaultValue;
        }
        return defaultValue;
    }
}

