/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinallyProcessor
extends DelegateAsyncProcessor
implements Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(FinallyProcessor.class);
    private String id;
    private String routeId;

    public FinallyProcessor(Processor processor) {
        super(processor);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Exception exception = exchange.getException();
        if (exception != null) {
            exchange.setException(null);
            exchange.setProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, (Object)exception);
        }
        if (exchange.getProperty(ExchangePropertyKey.FAILURE_ENDPOINT) == null) {
            exchange.setProperty(ExchangePropertyKey.FAILURE_ENDPOINT, exchange.getProperty(ExchangePropertyKey.TO_ENDPOINT));
        }
        return this.processor.process(exchange, new FinallyAsyncCallback(exchange, callback, exception));
    }

    @Override
    public String toString() {
        return this.id;
    }

    @Override
    public String getTraceLabel() {
        return "finally";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    private static final class FinallyAsyncCallback
    implements AsyncCallback {
        private final Exchange exchange;
        private final AsyncCallback callback;
        private final Exception exception;

        FinallyAsyncCallback(Exchange exchange, AsyncCallback callback, Exception exception) {
            this.exchange = exchange;
            this.callback = callback;
            this.exception = exception;
        }

        @Override
        public void done(boolean doneSync) {
            try {
                if (this.exception == null) {
                    this.exchange.removeProperty(ExchangePropertyKey.FAILURE_ENDPOINT);
                } else {
                    this.exchange.setException(this.exception);
                    this.exchange.setProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, (Object)this.exception);
                }
                if (!doneSync) {
                    ExchangeHelper.prepareOutToIn(this.exchange);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)this.exchange.getExchangeId(), (Object)this.exchange);
                    }
                }
            }
            finally {
                this.callback.done(doneSync);
            }
        }

        public String toString() {
            return "FinallyAsyncCallback";
        }
    }
}

