/*
 * Decompiled with CFR 0.152.
 */
package com.notnoop.apns.internal;

import com.notnoop.apns.ReconnectPolicy;

public final class ReconnectPolicies {

    public static class EveryHalfHour
    implements ReconnectPolicy {
        private static final long PERIOD = 1800000L;
        private long lastRunning = System.currentTimeMillis();

        @Override
        public boolean shouldReconnect() {
            return System.currentTimeMillis() - this.lastRunning > 1800000L;
        }

        @Override
        public void reconnected() {
            this.lastRunning = System.currentTimeMillis();
        }

        @Override
        public EveryHalfHour copy() {
            return new EveryHalfHour();
        }
    }

    public static class Always
    implements ReconnectPolicy {
        @Override
        public boolean shouldReconnect() {
            return true;
        }

        @Override
        public void reconnected() {
        }

        @Override
        public Always copy() {
            return this;
        }
    }

    public static class Never
    implements ReconnectPolicy {
        @Override
        public boolean shouldReconnect() {
            return false;
        }

        @Override
        public void reconnected() {
        }

        @Override
        public Never copy() {
            return this;
        }
    }
}

