/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.apns;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.apns.ApnsEndpoint;
import org.apache.camel.component.apns.model.InactiveDevice;
import org.apache.camel.support.ScheduledPollConsumer;

public class ApnsConsumer
extends ScheduledPollConsumer {
    private static final int DEFAULT_CONSUME_INITIAL_DELAY = 10;
    private static final int DEFAULT_CONSUME_DELAY = 3600;
    private static final boolean DEFAULT_APNS_FIXED_DELAY = true;

    public ApnsConsumer(ApnsEndpoint apnsEndpoint, Processor processor) {
        super(apnsEndpoint, processor);
        this.setInitialDelay(10L);
        this.setDelay(3600L);
        this.setUseFixedDelay(true);
    }

    @Override
    protected int poll() throws Exception {
        List<InactiveDevice> inactiveDeviceList = this.getInactiveDevices();
        for (InactiveDevice inactiveDevice : inactiveDeviceList) {
            Exchange e = this.createExchange(true);
            e.getIn().setBody(inactiveDevice);
            this.getProcessor().process(e);
        }
        return inactiveDeviceList.size();
    }

    private List<InactiveDevice> getInactiveDevices() {
        ApnsEndpoint ae = this.getEndpoint();
        Map<String, Date> inactiveDeviceMap = ae.getApnsService().getInactiveDevices();
        ArrayList<InactiveDevice> inactiveDeviceList = new ArrayList<InactiveDevice>();
        for (Map.Entry<String, Date> inactiveDeviceEntry : inactiveDeviceMap.entrySet()) {
            String deviceToken = inactiveDeviceEntry.getKey();
            Date date = inactiveDeviceEntry.getValue();
            InactiveDevice inactiveDevice = new InactiveDevice(deviceToken, date);
            inactiveDeviceList.add(inactiveDevice);
        }
        return inactiveDeviceList;
    }

    @Override
    public ApnsEndpoint getEndpoint() {
        return (ApnsEndpoint)super.getEndpoint();
    }

    @Override
    protected void doStart() throws Exception {
        if (!this.getEndpoint().getConsumers().contains(this)) {
            if (!this.getEndpoint().getConsumers().isEmpty()) {
                throw new IllegalStateException("Endpoint " + this.getEndpoint().getEndpointUri() + " only allows 1 active consumer but you attempted to start a 2nd consumer.");
            }
            this.getEndpoint().getConsumers().add(this);
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.getEndpoint().getConsumers().remove(this);
    }
}

