/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.camel.CamelContext;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceResolver;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceResolverSupport
extends ServiceSupport
implements ResourceResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceResolverSupport.class);
    private final String scheme;
    private CamelContext camelContext;

    protected ResourceResolverSupport(String scheme) {
        this.scheme = scheme;
    }

    @Override
    public String getSupportedScheme() {
        return this.scheme;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public Resource resolve(String location) {
        if (!location.startsWith(this.getSupportedScheme() + ":")) {
            throw new IllegalArgumentException("Unsupported scheme: " + location);
        }
        return this.createResource(location);
    }

    protected abstract Resource createResource(String var1);

    protected String tryDecodeUri(String uri) {
        try {
            uri = URLDecoder.decode(uri, StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            LOGGER.trace("Error URL decoding uri using UTF-8 encoding: {}. This exception is ignored.", (Object)uri);
        }
        return uri;
    }

    protected String getRemaining(String location) {
        return StringHelper.after(location, this.getSupportedScheme() + ":");
    }
}

