/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.async;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoMetrics;
import com.arangodb.ArangoSerializationAccessor;
import com.arangodb.DbName;
import com.arangodb.async.ArangoDatabaseAsync;
import com.arangodb.async.internal.ArangoDBAsyncImpl;
import com.arangodb.async.internal.velocystream.VstCommunicationAsync;
import com.arangodb.async.internal.velocystream.VstConnectionFactoryAsync;
import com.arangodb.entity.ArangoDBVersion;
import com.arangodb.entity.LoadBalancingStrategy;
import com.arangodb.entity.LogEntity;
import com.arangodb.entity.LogEntriesEntity;
import com.arangodb.entity.LogLevelEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.QueryOptimizerRule;
import com.arangodb.entity.ServerRole;
import com.arangodb.entity.UserEntity;
import com.arangodb.internal.ArangoContext;
import com.arangodb.internal.InternalArangoDBBuilder;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.net.HostResolver;
import com.arangodb.internal.util.ArangoDeserializerImpl;
import com.arangodb.internal.util.ArangoSerializationFactory;
import com.arangodb.internal.util.ArangoSerializerImpl;
import com.arangodb.internal.util.DefaultArangoSerialization;
import com.arangodb.internal.velocystream.VstCommunicationSync;
import com.arangodb.internal.velocystream.VstConnectionFactorySync;
import com.arangodb.model.DBCreateOptions;
import com.arangodb.model.LogOptions;
import com.arangodb.model.UserCreateOptions;
import com.arangodb.model.UserUpdateOptions;
import com.arangodb.util.ArangoDeserializer;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.util.ArangoSerializer;
import com.arangodb.velocypack.VPack;
import com.arangodb.velocypack.VPackAnnotationFieldFilter;
import com.arangodb.velocypack.VPackAnnotationFieldNaming;
import com.arangodb.velocypack.VPackDeserializer;
import com.arangodb.velocypack.VPackInstanceCreator;
import com.arangodb.velocypack.VPackJsonDeserializer;
import com.arangodb.velocypack.VPackJsonSerializer;
import com.arangodb.velocypack.VPackModule;
import com.arangodb.velocypack.VPackParser;
import com.arangodb.velocypack.VPackParserModule;
import com.arangodb.velocypack.VPackSerializer;
import com.arangodb.velocypack.ValueType;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.Response;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import javax.annotation.concurrent.ThreadSafe;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public interface ArangoDBAsync
extends ArangoSerializationAccessor {
    public void shutdown() throws ArangoDBException;

    public void updateJwt(String var1);

    public ArangoDatabaseAsync db();

    @Deprecated
    default public ArangoDatabaseAsync db(String name) {
        return this.db(DbName.of(name));
    }

    public ArangoDatabaseAsync db(DbName var1);

    public ArangoMetrics metrics();

    @Deprecated
    default public CompletableFuture<Boolean> createDatabase(String name) {
        return this.createDatabase(DbName.of(name));
    }

    public CompletableFuture<Boolean> createDatabase(DbName var1);

    public CompletableFuture<Boolean> createDatabase(DBCreateOptions var1);

    public CompletableFuture<Collection<String>> getDatabases();

    public CompletableFuture<Collection<String>> getAccessibleDatabases();

    public CompletableFuture<Collection<String>> getAccessibleDatabasesFor(String var1);

    public CompletableFuture<ArangoDBVersion> getVersion();

    public CompletableFuture<ServerRole> getRole();

    public CompletableFuture<UserEntity> createUser(String var1, String var2);

    public CompletableFuture<UserEntity> createUser(String var1, String var2, UserCreateOptions var3);

    public CompletableFuture<Void> deleteUser(String var1);

    public CompletableFuture<UserEntity> getUser(String var1);

    public CompletableFuture<Collection<UserEntity>> getUsers();

    public CompletableFuture<UserEntity> updateUser(String var1, UserUpdateOptions var2);

    public CompletableFuture<UserEntity> replaceUser(String var1, UserUpdateOptions var2);

    public CompletableFuture<Void> grantDefaultDatabaseAccess(String var1, Permissions var2);

    public CompletableFuture<Void> grantDefaultCollectionAccess(String var1, Permissions var2);

    public CompletableFuture<Response> execute(Request var1);

    @Deprecated
    public CompletableFuture<LogEntity> getLogs(LogOptions var1);

    public CompletableFuture<LogEntriesEntity> getLogEntries(LogOptions var1);

    public CompletableFuture<LogLevelEntity> getLogLevel();

    public CompletableFuture<LogLevelEntity> setLogLevel(LogLevelEntity var1);

    public CompletableFuture<Collection<QueryOptimizerRule>> getQueryOptimizerRules();

    public static class Builder
    extends InternalArangoDBBuilder {
        private static final Logger logger = LoggerFactory.getLogger(Builder.class);

        @Override
        public Builder loadProperties(InputStream in) throws ArangoDBException {
            super.loadProperties(in);
            return this;
        }

        public Builder host(String host, int port) {
            this.setHost(host, port);
            return this;
        }

        public Builder timeout(Integer timeout) {
            this.setTimeout(timeout);
            return this;
        }

        public Builder user(String user) {
            this.setUser(user);
            return this;
        }

        public Builder password(String password) {
            this.setPassword(password);
            return this;
        }

        public Builder jwt(String jwt) {
            this.setJwt(jwt);
            return this;
        }

        public Builder useSsl(Boolean useSsl) {
            this.setUseSsl(useSsl);
            return this;
        }

        public Builder sslContext(SSLContext sslContext) {
            this.setSslContext(sslContext);
            return this;
        }

        public Builder chunksize(Integer chunksize) {
            this.setChunksize(chunksize);
            return this;
        }

        public Builder maxConnections(Integer maxConnections) {
            this.setMaxConnections(maxConnections);
            return this;
        }

        public Builder connectionTtl(Long connectionTtl) {
            this.setConnectionTtl(connectionTtl);
            return this;
        }

        public Builder keepAliveInterval(Integer keepAliveInterval) {
            this.setKeepAliveInterval(keepAliveInterval);
            return this;
        }

        public Builder acquireHostList(Boolean acquireHostList) {
            this.setAcquireHostList(acquireHostList);
            return this;
        }

        public Builder responseQueueTimeSamples(Integer responseQueueTimeSamples) {
            this.setResponseQueueTimeSamples(responseQueueTimeSamples);
            return this;
        }

        public Builder loadBalancingStrategy(LoadBalancingStrategy loadBalancingStrategy) {
            this.setLoadBalancingStrategy(loadBalancingStrategy);
            return this;
        }

        @Deprecated
        public <T> Builder registerSerializer(Class<T> clazz, VPackSerializer<T> serializer) {
            this.vpackBuilder.registerSerializer((Type)clazz, (VPackSerializer)serializer);
            return this;
        }

        @Deprecated
        public <T> Builder registerEnclosingSerializer(Class<T> clazz, VPackSerializer<T> serializer) {
            this.vpackBuilder.registerEnclosingSerializer((Type)clazz, (VPackSerializer)serializer);
            return this;
        }

        @Deprecated
        public <T> Builder registerDeserializer(Class<T> clazz, VPackDeserializer<T> deserializer) {
            this.vpackBuilder.registerDeserializer((Type)clazz, (VPackDeserializer)deserializer);
            return this;
        }

        @Deprecated
        public <T> Builder registerInstanceCreator(Class<T> clazz, VPackInstanceCreator<T> creator) {
            this.vpackBuilder.registerInstanceCreator((Type)clazz, (VPackInstanceCreator)creator);
            return this;
        }

        @Deprecated
        public Builder registerJsonDeserializer(ValueType type, VPackJsonDeserializer deserializer) {
            this.vpackParserBuilder.registerDeserializer(type, deserializer);
            return this;
        }

        @Deprecated
        public Builder registerJsonDeserializer(String attribute, ValueType type, VPackJsonDeserializer deserializer) {
            this.vpackParserBuilder.registerDeserializer(attribute, type, deserializer);
            return this;
        }

        @Deprecated
        public <T> Builder registerJsonSerializer(Class<T> clazz, VPackJsonSerializer<T> serializer) {
            this.vpackParserBuilder.registerSerializer((Class)clazz, (VPackJsonSerializer)serializer);
            return this;
        }

        @Deprecated
        public <T> Builder registerJsonSerializer(String attribute, Class<T> clazz, VPackJsonSerializer<T> serializer) {
            this.vpackParserBuilder.registerSerializer(attribute, (Class)clazz, (VPackJsonSerializer)serializer);
            return this;
        }

        @Deprecated
        public <A extends Annotation> Builder annotationFieldFilter(Class<A> type, VPackAnnotationFieldFilter<A> fieldFilter) {
            this.vpackBuilder.annotationFieldFilter((Class)type, (VPackAnnotationFieldFilter)fieldFilter);
            return this;
        }

        @Deprecated
        public <A extends Annotation> Builder annotationFieldNaming(Class<A> type, VPackAnnotationFieldNaming<A> fieldNaming) {
            this.vpackBuilder.annotationFieldNaming((Class)type, (VPackAnnotationFieldNaming)fieldNaming);
            return this;
        }

        @Deprecated
        public Builder registerModule(VPackModule module) {
            this.vpackBuilder.registerModule(module);
            return this;
        }

        @Deprecated
        public Builder registerModules(VPackModule ... modules) {
            this.vpackBuilder.registerModules(modules);
            return this;
        }

        @Deprecated
        public Builder registerJsonModule(VPackParserModule module) {
            this.vpackParserBuilder.registerModule(module);
            return this;
        }

        @Deprecated
        public Builder registerJsonModules(VPackParserModule ... modules) {
            this.vpackParserBuilder.registerModules(modules);
            return this;
        }

        @Deprecated
        public Builder setSerializer(ArangoSerializer serializer) {
            this.serializer(serializer);
            return this;
        }

        @Deprecated
        public Builder setDeserializer(ArangoDeserializer deserializer) {
            this.deserializer(deserializer);
            return this;
        }

        public Builder serializer(ArangoSerialization serialization) {
            this.setSerializer(serialization);
            return this;
        }

        public synchronized ArangoDBAsync build() {
            if (this.customSerializer == null) {
                logger.warn("Usage of VelocyPack Java serialization is now deprecated for removal. Future driver versions will only support Jackson serialization (for both JSON and VPACK formats). Please configure according to: https://www.arangodb.com/docs/stable/drivers/java-reference-serialization.html");
            }
            if (this.hosts.isEmpty()) {
                this.hosts.add(this.host);
            }
            VPack vpacker = this.vpackBuilder.serializeNullValues(false).build();
            VPack vpackerNull = this.vpackBuilder.serializeNullValues(true).build();
            VPackParser vpackParser = this.vpackParserBuilder.build();
            ArangoSerializer serializerTemp = this.serializer != null ? this.serializer : new ArangoSerializerImpl(vpacker, vpackerNull, vpackParser);
            ArangoDeserializer deserializerTemp = this.deserializer != null ? this.deserializer : new ArangoDeserializerImpl(vpackerNull, vpackParser);
            DefaultArangoSerialization internal = new DefaultArangoSerialization(serializerTemp, deserializerTemp);
            ArangoSerialization custom = this.customSerializer != null ? this.customSerializer : internal;
            ArangoSerializationFactory util = new ArangoSerializationFactory(internal, custom);
            int max = this.maxConnections != null ? Math.max(1, this.maxConnections) : 1;
            VstConnectionFactorySync syncConnectionFactory = new VstConnectionFactorySync(this.host, this.timeout, this.connectionTtl, this.keepAliveInterval, this.useSsl, this.sslContext);
            VstConnectionFactoryAsync asyncConnectionFactory = new VstConnectionFactoryAsync(this.host, this.timeout, this.connectionTtl, this.keepAliveInterval, this.useSsl, this.sslContext);
            HostResolver syncHostResolver = this.createHostResolver(this.createHostList(max, syncConnectionFactory), max, syncConnectionFactory);
            HostResolver asyncHostResolver = this.createHostResolver(this.createHostList(max, asyncConnectionFactory), max, asyncConnectionFactory);
            HostHandler syncHostHandler = this.createHostHandler(syncHostResolver);
            HostHandler asyncHostHandler = this.createHostHandler(asyncHostResolver);
            return new ArangoDBAsyncImpl(this.asyncBuilder(asyncHostHandler), util, this.syncBuilder(syncHostHandler), asyncHostResolver, syncHostResolver, asyncHostHandler, syncHostHandler, new ArangoContext(), this.responseQueueTimeSamples, this.timeout);
        }

        private VstCommunicationAsync.Builder asyncBuilder(HostHandler hostHandler) {
            return new VstCommunicationAsync.Builder(hostHandler).timeout(this.timeout).user(this.user).password(this.password).jwt(this.jwt).useSsl(this.useSsl).sslContext(this.sslContext).chunksize(this.chunksize).maxConnections(this.maxConnections).connectionTtl(this.connectionTtl);
        }

        private VstCommunicationSync.Builder syncBuilder(HostHandler hostHandler) {
            return new VstCommunicationSync.Builder(hostHandler).timeout(this.timeout).user(this.user).password(this.password).jwt(this.jwt).useSsl(this.useSsl).sslContext(this.sslContext).chunksize(this.chunksize).maxConnections(this.maxConnections).connectionTtl(this.connectionTtl);
        }
    }
}

