/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.async.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.async.ArangoCollectionAsync;
import com.arangodb.async.internal.ArangoDBAsyncImpl;
import com.arangodb.async.internal.ArangoDatabaseAsyncImpl;
import com.arangodb.async.internal.ArangoExecutorAsync;
import com.arangodb.async.internal.ExceptionUtil;
import com.arangodb.entity.CollectionEntity;
import com.arangodb.entity.CollectionPropertiesEntity;
import com.arangodb.entity.CollectionRevisionEntity;
import com.arangodb.entity.DocumentCreateEntity;
import com.arangodb.entity.DocumentDeleteEntity;
import com.arangodb.entity.DocumentImportEntity;
import com.arangodb.entity.DocumentUpdateEntity;
import com.arangodb.entity.IndexEntity;
import com.arangodb.entity.InvertedIndexEntity;
import com.arangodb.entity.MultiDocumentEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.ShardEntity;
import com.arangodb.internal.InternalArangoCollection;
import com.arangodb.internal.util.DocumentUtil;
import com.arangodb.model.CollectionCountOptions;
import com.arangodb.model.CollectionCreateOptions;
import com.arangodb.model.CollectionPropertiesOptions;
import com.arangodb.model.CollectionTruncateOptions;
import com.arangodb.model.DocumentCreateOptions;
import com.arangodb.model.DocumentDeleteOptions;
import com.arangodb.model.DocumentExistsOptions;
import com.arangodb.model.DocumentImportOptions;
import com.arangodb.model.DocumentReadOptions;
import com.arangodb.model.DocumentReplaceOptions;
import com.arangodb.model.DocumentUpdateOptions;
import com.arangodb.model.FulltextIndexOptions;
import com.arangodb.model.GeoIndexOptions;
import com.arangodb.model.HashIndexOptions;
import com.arangodb.model.InvertedIndexOptions;
import com.arangodb.model.PersistentIndexOptions;
import com.arangodb.model.SkiplistIndexOptions;
import com.arangodb.model.TtlIndexOptions;
import com.arangodb.model.ZKDIndexOptions;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class ArangoCollectionAsyncImpl
extends InternalArangoCollection<ArangoDBAsyncImpl, ArangoDatabaseAsyncImpl, ArangoExecutorAsync>
implements ArangoCollectionAsync {
    ArangoCollectionAsyncImpl(ArangoDatabaseAsyncImpl db, String name) {
        super(db, name);
    }

    @Override
    public <T> CompletableFuture<DocumentCreateEntity<T>> insertDocument(T value) {
        DocumentCreateOptions options = new DocumentCreateOptions();
        return ((ArangoExecutorAsync)this.executor).execute(this.insertDocumentRequest(value, options), this.insertDocumentResponseDeserializer(value, options));
    }

    @Override
    public <T> CompletableFuture<DocumentCreateEntity<T>> insertDocument(T value, DocumentCreateOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.insertDocumentRequest(value, options), this.insertDocumentResponseDeserializer(value, options));
    }

    @Override
    public <T> CompletableFuture<MultiDocumentEntity<DocumentCreateEntity<T>>> insertDocuments(Collection<T> values) {
        DocumentCreateOptions params = new DocumentCreateOptions();
        return ((ArangoExecutorAsync)this.executor).execute(this.insertDocumentsRequest(values, params), this.insertDocumentsResponseDeserializer(values, params));
    }

    @Override
    public <T> CompletableFuture<MultiDocumentEntity<DocumentCreateEntity<T>>> insertDocuments(Collection<T> values, DocumentCreateOptions options) {
        DocumentCreateOptions params = options != null ? options : new DocumentCreateOptions();
        return ((ArangoExecutorAsync)this.executor).execute(this.insertDocumentsRequest(values, params), this.insertDocumentsResponseDeserializer(values, params));
    }

    @Override
    public CompletableFuture<DocumentImportEntity> importDocuments(Collection<?> values) {
        return this.importDocuments(values, new DocumentImportOptions());
    }

    @Override
    public CompletableFuture<DocumentImportEntity> importDocuments(Collection<?> values, DocumentImportOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.importDocumentsRequest(values, options), (Type)((Object)DocumentImportEntity.class));
    }

    @Override
    public CompletableFuture<DocumentImportEntity> importDocuments(String values) {
        return ((ArangoExecutorAsync)this.executor).execute(this.importDocumentsRequest(values, new DocumentImportOptions()), (Type)((Object)DocumentImportEntity.class));
    }

    @Override
    public CompletableFuture<DocumentImportEntity> importDocuments(String values, DocumentImportOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.importDocumentsRequest(values, options), (Type)((Object)DocumentImportEntity.class));
    }

    @Override
    public <T> CompletableFuture<T> getDocument(String key, Class<T> type) throws ArangoDBException {
        return this.getDocument(key, type, new DocumentReadOptions());
    }

    @Override
    public <T> CompletableFuture<T> getDocument(String key, Class<T> type, DocumentReadOptions options) throws ArangoDBException {
        DocumentUtil.validateDocumentKey(key);
        boolean isCatchException = options != null ? options.isCatchException() : new DocumentReadOptions().isCatchException();
        return ((ArangoExecutorAsync)this.executor).execute(this.getDocumentRequest(key, options), type).exceptionally(ExceptionUtil.catchGetDocumentExceptions(isCatchException));
    }

    @Override
    public <T> CompletableFuture<MultiDocumentEntity<T>> getDocuments(Collection<String> keys, Class<T> type) {
        return this.getDocuments(keys, type, new DocumentReadOptions());
    }

    @Override
    public <T> CompletableFuture<MultiDocumentEntity<T>> getDocuments(Collection<String> keys, Class<T> type, DocumentReadOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.getDocumentsRequest(keys, options), this.getDocumentsResponseDeserializer(type, options));
    }

    @Override
    public <T> CompletableFuture<DocumentUpdateEntity<T>> replaceDocument(String key, T value) {
        DocumentReplaceOptions options = new DocumentReplaceOptions();
        return ((ArangoExecutorAsync)this.executor).execute(this.replaceDocumentRequest(key, value, options), this.replaceDocumentResponseDeserializer(value, options));
    }

    @Override
    public <T> CompletableFuture<DocumentUpdateEntity<T>> replaceDocument(String key, T value, DocumentReplaceOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.replaceDocumentRequest(key, value, options), this.replaceDocumentResponseDeserializer(value, options));
    }

    @Override
    public <T> CompletableFuture<MultiDocumentEntity<DocumentUpdateEntity<T>>> replaceDocuments(Collection<T> values) {
        DocumentReplaceOptions params = new DocumentReplaceOptions();
        return ((ArangoExecutorAsync)this.executor).execute(this.replaceDocumentsRequest(values, params), this.replaceDocumentsResponseDeserializer(values, params));
    }

    @Override
    public <T> CompletableFuture<MultiDocumentEntity<DocumentUpdateEntity<T>>> replaceDocuments(Collection<T> values, DocumentReplaceOptions options) {
        DocumentReplaceOptions params = options != null ? options : new DocumentReplaceOptions();
        return ((ArangoExecutorAsync)this.executor).execute(this.replaceDocumentsRequest(values, params), this.replaceDocumentsResponseDeserializer(values, params));
    }

    @Override
    public <T> CompletableFuture<DocumentUpdateEntity<T>> updateDocument(String key, T value) {
        return this.updateDocument(key, value, new DocumentUpdateOptions());
    }

    @Override
    public <T> CompletableFuture<DocumentUpdateEntity<T>> updateDocument(String key, T value, DocumentUpdateOptions options) {
        return this.updateDocument(key, value, options, value.getClass());
    }

    @Override
    public <T, U> CompletableFuture<DocumentUpdateEntity<U>> updateDocument(String key, T value, DocumentUpdateOptions options, Class<U> returnType) {
        return ((ArangoExecutorAsync)this.executor).execute(this.updateDocumentRequest(key, value, options), this.updateDocumentResponseDeserializer(value, options, returnType));
    }

    @Override
    public <T> CompletableFuture<MultiDocumentEntity<DocumentUpdateEntity<T>>> updateDocuments(Collection<T> values) {
        return this.updateDocuments(values, new DocumentUpdateOptions());
    }

    @Override
    public <T> CompletableFuture<MultiDocumentEntity<DocumentUpdateEntity<T>>> updateDocuments(Collection<T> values, DocumentUpdateOptions options) {
        return this.updateDocuments(values, options, values.isEmpty() ? null : values.iterator().next().getClass());
    }

    @Override
    public <T, U> CompletableFuture<MultiDocumentEntity<DocumentUpdateEntity<U>>> updateDocuments(Collection<T> values, DocumentUpdateOptions options, Class<U> returnType) {
        DocumentUpdateOptions params = options != null ? options : new DocumentUpdateOptions();
        return ((ArangoExecutorAsync)this.executor).execute(this.updateDocumentsRequest(values, params), this.updateDocumentsResponseDeserializer(returnType));
    }

    @Override
    public CompletableFuture<DocumentDeleteEntity<Void>> deleteDocument(String key) {
        return ((ArangoExecutorAsync)this.executor).execute(this.deleteDocumentRequest(key, new DocumentDeleteOptions()), this.deleteDocumentResponseDeserializer(Void.class));
    }

    @Override
    public <T> CompletableFuture<DocumentDeleteEntity<T>> deleteDocument(String key, Class<T> type, DocumentDeleteOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.deleteDocumentRequest(key, options), this.deleteDocumentResponseDeserializer(type));
    }

    @Override
    public CompletableFuture<MultiDocumentEntity<DocumentDeleteEntity<Void>>> deleteDocuments(Collection<?> values) {
        return ((ArangoExecutorAsync)this.executor).execute(this.deleteDocumentsRequest(values, new DocumentDeleteOptions()), this.deleteDocumentsResponseDeserializer(Void.class));
    }

    @Override
    public <T> CompletableFuture<MultiDocumentEntity<DocumentDeleteEntity<T>>> deleteDocuments(Collection<?> values, Class<T> type, DocumentDeleteOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.deleteDocumentsRequest(values, options), this.deleteDocumentsResponseDeserializer(type));
    }

    @Override
    public CompletableFuture<Boolean> documentExists(String key) {
        return this.documentExists(key, new DocumentExistsOptions());
    }

    @Override
    public CompletableFuture<Boolean> documentExists(String key, DocumentExistsOptions options) {
        boolean isCatchException = options != null ? options.isCatchException() : new DocumentExistsOptions().isCatchException();
        return ((CompletableFuture)((ArangoExecutorAsync)this.executor).execute(this.documentExistsRequest(key, options), response -> response).exceptionally(ExceptionUtil.catchGetDocumentExceptions(isCatchException))).thenApply(Objects::nonNull);
    }

    @Override
    public CompletableFuture<IndexEntity> getIndex(String id) {
        return ((ArangoExecutorAsync)this.executor).execute(this.getIndexRequest(id), (Type)((Object)IndexEntity.class));
    }

    @Override
    public CompletableFuture<InvertedIndexEntity> getInvertedIndex(String id) {
        return ((ArangoExecutorAsync)this.executor).execute(this.getIndexRequest(id), (Type)((Object)InvertedIndexEntity.class));
    }

    @Override
    public CompletableFuture<String> deleteIndex(String id) {
        return ((ArangoExecutorAsync)this.executor).execute(this.deleteIndexRequest(id), this.deleteIndexResponseDeserializer());
    }

    @Override
    @Deprecated
    public CompletableFuture<IndexEntity> ensureHashIndex(Iterable<String> fields, HashIndexOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.createHashIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    @Deprecated
    public CompletableFuture<IndexEntity> ensureSkiplistIndex(Iterable<String> fields, SkiplistIndexOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.createSkiplistIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public CompletableFuture<IndexEntity> ensurePersistentIndex(Iterable<String> fields, PersistentIndexOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.createPersistentIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public CompletableFuture<IndexEntity> ensureGeoIndex(Iterable<String> fields, GeoIndexOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.createGeoIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    @Deprecated
    public CompletableFuture<IndexEntity> ensureFulltextIndex(Iterable<String> fields, FulltextIndexOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.createFulltextIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public CompletableFuture<IndexEntity> ensureTtlIndex(Iterable<String> fields, TtlIndexOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.createTtlIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public CompletableFuture<IndexEntity> ensureZKDIndex(Iterable<String> fields, ZKDIndexOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.createZKDIndexRequest(fields, options), (Type)((Object)IndexEntity.class));
    }

    @Override
    public CompletableFuture<InvertedIndexEntity> ensureInvertedIndex(InvertedIndexOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.createInvertedIndexRequest(options), (Type)((Object)InvertedIndexEntity.class));
    }

    @Override
    public CompletableFuture<Collection<IndexEntity>> getIndexes() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getIndexesRequest(), this.getIndexesResponseDeserializer());
    }

    @Override
    public CompletableFuture<Collection<InvertedIndexEntity>> getInvertedIndexes() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getIndexesRequest(), this.getInvertedIndexesResponseDeserializer());
    }

    @Override
    public CompletableFuture<Boolean> exists() {
        return ((CompletableFuture)this.getInfo().thenApply(Objects::nonNull)).exceptionally(Objects::isNull);
    }

    @Override
    public CompletableFuture<CollectionEntity> truncate() {
        return this.truncate(null);
    }

    @Override
    public CompletableFuture<CollectionEntity> truncate(CollectionTruncateOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.truncateRequest(options), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public CompletableFuture<CollectionPropertiesEntity> count() {
        return this.count(null);
    }

    @Override
    public CompletableFuture<CollectionPropertiesEntity> count(CollectionCountOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.countRequest(options), (Type)((Object)CollectionPropertiesEntity.class));
    }

    @Override
    public CompletableFuture<CollectionEntity> create() {
        return ((ArangoDatabaseAsyncImpl)this.db()).createCollection(this.name());
    }

    @Override
    public CompletableFuture<CollectionEntity> create(CollectionCreateOptions options) {
        return ((ArangoDatabaseAsyncImpl)this.db()).createCollection(this.name(), options);
    }

    @Override
    public CompletableFuture<Void> drop() {
        return ((ArangoExecutorAsync)this.executor).execute(this.dropRequest(null), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> drop(boolean isSystem) {
        return ((ArangoExecutorAsync)this.executor).execute(this.dropRequest(isSystem), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<CollectionEntity> load() {
        return ((ArangoExecutorAsync)this.executor).execute(this.loadRequest(), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public CompletableFuture<CollectionEntity> unload() {
        return ((ArangoExecutorAsync)this.executor).execute(this.unloadRequest(), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public CompletableFuture<CollectionEntity> getInfo() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getInfoRequest(), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public CompletableFuture<CollectionPropertiesEntity> getProperties() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getPropertiesRequest(), (Type)((Object)CollectionPropertiesEntity.class));
    }

    @Override
    public CompletableFuture<CollectionPropertiesEntity> changeProperties(CollectionPropertiesOptions options) {
        return ((ArangoExecutorAsync)this.executor).execute(this.changePropertiesRequest(options), (Type)((Object)CollectionPropertiesEntity.class));
    }

    @Override
    public CompletableFuture<CollectionEntity> rename(String newName) {
        return ((ArangoExecutorAsync)this.executor).execute(this.renameRequest(newName), (Type)((Object)CollectionEntity.class));
    }

    @Override
    public CompletableFuture<ShardEntity> getResponsibleShard(Object value) {
        return ((ArangoExecutorAsync)this.executor).execute(this.responsibleShardRequest(value), (Type)((Object)ShardEntity.class));
    }

    @Override
    public CompletableFuture<CollectionRevisionEntity> getRevision() {
        return ((ArangoExecutorAsync)this.executor).execute(this.getRevisionRequest(), (Type)((Object)CollectionRevisionEntity.class));
    }

    @Override
    public CompletableFuture<Void> grantAccess(String user, Permissions permissions) {
        return ((ArangoExecutorAsync)this.executor).execute(this.grantAccessRequest(user, permissions), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> revokeAccess(String user) {
        return ((ArangoExecutorAsync)this.executor).execute(this.grantAccessRequest(user, Permissions.NONE), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Void> resetAccess(String user) {
        return ((ArangoExecutorAsync)this.executor).execute(this.resetAccessRequest(user), (Type)((Object)Void.class));
    }

    @Override
    public CompletableFuture<Permissions> getPermissions(String user) {
        return ((ArangoExecutorAsync)this.executor).execute(this.getPermissionsRequest(user), this.getPermissionsResponseDeserialzer());
    }
}

