/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.entity.arangosearch.analyzer;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class StopwordsAnalyzerProperties {
    private final List<String> stopwords = new ArrayList<String>();
    private final boolean hex;

    private static String stringToHex(String str) {
        StringBuilder hex = new StringBuilder();
        for (char temp : str.toCharArray()) {
            hex.append(Integer.toHexString(temp));
        }
        return hex.toString();
    }

    private static String hexToString(String hex) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < hex.length() - 1; i += 2) {
            String tempInHex = hex.substring(i, i + 2);
            int decimal = Integer.parseInt(tempInHex, 16);
            result.append((char)decimal);
        }
        return result.toString();
    }

    public StopwordsAnalyzerProperties() {
        this.hex = true;
    }

    @Deprecated
    public List<String> getStopwords() {
        return this.getStopwordsAsHexList();
    }

    public List<String> getStopwordsAsStringList() {
        if (this.hex) {
            return this.stopwords.stream().map(StopwordsAnalyzerProperties::hexToString).collect(Collectors.toList());
        }
        return this.stopwords;
    }

    public List<String> getStopwordsAsHexList() {
        if (this.hex) {
            return this.stopwords;
        }
        return this.stopwords.stream().map(StopwordsAnalyzerProperties::stringToHex).collect(Collectors.toList());
    }

    public boolean getHex() {
        return this.hex;
    }

    public StopwordsAnalyzerProperties addStopwordAsString(String value) {
        if (this.hex) {
            this.stopwords.add(StopwordsAnalyzerProperties.stringToHex(value));
        } else {
            this.stopwords.add(value);
        }
        return this;
    }

    public StopwordsAnalyzerProperties addStopwordAsHex(String value) {
        if (this.hex) {
            this.stopwords.add(value);
        } else {
            this.stopwords.add(StopwordsAnalyzerProperties.hexToString(value));
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StopwordsAnalyzerProperties that = (StopwordsAnalyzerProperties)o;
        return this.hex == that.hex && Objects.equals(this.stopwords, that.stopwords);
    }

    public int hashCode() {
        return Objects.hash(this.stopwords, this.hex);
    }
}

