/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDB;
import com.arangodb.ArangoDBException;
import com.arangodb.ArangoDatabase;
import com.arangodb.ArangoMetrics;
import com.arangodb.DbName;
import com.arangodb.Protocol;
import com.arangodb.entity.ArangoDBEngine;
import com.arangodb.entity.ArangoDBVersion;
import com.arangodb.entity.LogEntity;
import com.arangodb.entity.LogEntriesEntity;
import com.arangodb.entity.LogLevelEntity;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.QueryOptimizerRule;
import com.arangodb.entity.ServerRole;
import com.arangodb.entity.UserEntity;
import com.arangodb.internal.ArangoContext;
import com.arangodb.internal.ArangoDatabaseImpl;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.ArangoMetricsImpl;
import com.arangodb.internal.DocumentCache;
import com.arangodb.internal.InternalArangoDB;
import com.arangodb.internal.QueueTimeMetricsImpl;
import com.arangodb.internal.http.HttpCommunication;
import com.arangodb.internal.http.HttpProtocol;
import com.arangodb.internal.net.CommunicationProtocol;
import com.arangodb.internal.net.HostHandle;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.net.HostResolver;
import com.arangodb.internal.util.ArangoSerializationFactory;
import com.arangodb.internal.velocystream.VstCommunicationSync;
import com.arangodb.internal.velocystream.VstProtocol;
import com.arangodb.model.DBCreateOptions;
import com.arangodb.model.LogOptions;
import com.arangodb.model.UserCreateOptions;
import com.arangodb.model.UserUpdateOptions;
import com.arangodb.util.ArangoCursorInitializer;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.velocypack.Type;
import com.arangodb.velocystream.Request;
import com.arangodb.velocystream.Response;
import java.io.IOException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArangoDBImpl
extends InternalArangoDB<ArangoExecutorSync>
implements ArangoDB {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArangoDBImpl.class);
    private ArangoCursorInitializer cursorInitializer;
    private final CommunicationProtocol cp;
    private final HostHandler hostHandler;

    public ArangoDBImpl(VstCommunicationSync.Builder vstBuilder, HttpCommunication.Builder httpBuilder, ArangoSerializationFactory util, Protocol protocol, HostResolver hostResolver, HostHandler hostHandler, ArangoContext context, int responseQueueTimeSamples, int timeoutMs) {
        super(new ArangoExecutorSync(ArangoDBImpl.createProtocol(vstBuilder, httpBuilder, util.get(ArangoSerializationFactory.Serializer.INTERNAL), protocol), util, new DocumentCache(), new QueueTimeMetricsImpl(responseQueueTimeSamples), timeoutMs), util, context);
        this.cp = ArangoDBImpl.createProtocol(new VstCommunicationSync.Builder(vstBuilder).maxConnections(1), new HttpCommunication.Builder(httpBuilder), util.get(ArangoSerializationFactory.Serializer.INTERNAL), protocol);
        this.hostHandler = hostHandler;
        hostResolver.init(this.executor(), this.util());
        LOGGER.debug("ArangoDB Client is ready to use");
    }

    private static CommunicationProtocol createProtocol(VstCommunicationSync.Builder vstBuilder, HttpCommunication.Builder httpBuilder, ArangoSerialization util, Protocol protocol) {
        return protocol == null || Protocol.VST == protocol ? ArangoDBImpl.createVST(vstBuilder, util) : ArangoDBImpl.createHTTP(httpBuilder, util);
    }

    private static CommunicationProtocol createVST(VstCommunicationSync.Builder builder, ArangoSerialization util) {
        return new VstProtocol(builder.build(util));
    }

    private static CommunicationProtocol createHTTP(HttpCommunication.Builder builder, ArangoSerialization util) {
        return new HttpProtocol(builder.build(util));
    }

    @Override
    protected ArangoExecutorSync executor() {
        return (ArangoExecutorSync)this.executor;
    }

    @Override
    public void shutdown() throws ArangoDBException {
        try {
            ((ArangoExecutorSync)this.executor).disconnect();
        }
        finally {
            try {
                this.cp.close();
            }
            catch (IOException e) {
                LOGGER.error("Got exception during shutdown:", (Throwable)e);
            }
        }
    }

    @Override
    public void updateJwt(String jwt) {
        this.hostHandler.setJwt(jwt);
        this.cp.setJwt(jwt);
        ((ArangoExecutorSync)this.executor).setJwt(jwt);
    }

    @Override
    public ArangoDatabase db() {
        return this.db(DbName.SYSTEM);
    }

    @Override
    public ArangoDatabase db(DbName dbName) {
        return new ArangoDatabaseImpl(this, dbName).setCursorInitializer(this.cursorInitializer);
    }

    @Override
    public ArangoMetrics metrics() {
        return new ArangoMetricsImpl(((ArangoExecutorSync)this.executor).getQueueTimeMetrics());
    }

    @Override
    public Boolean createDatabase(DbName dbName) throws ArangoDBException {
        return this.createDatabase(new DBCreateOptions().name(dbName));
    }

    @Override
    public Boolean createDatabase(DBCreateOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.createDatabaseRequest(options), this.createDatabaseResponseDeserializer());
    }

    @Override
    public Collection<String> getDatabases() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getDatabasesRequest(this.db().dbName()), this.getDatabaseResponseDeserializer());
    }

    @Override
    public Collection<String> getAccessibleDatabases() throws ArangoDBException {
        return this.db().getAccessibleDatabases();
    }

    @Override
    public Collection<String> getAccessibleDatabasesFor(String user) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getAccessibleDatabasesForRequest(this.db().dbName(), user), this.getAccessibleDatabasesForResponseDeserializer());
    }

    @Override
    public ArangoDBVersion getVersion() throws ArangoDBException {
        return this.db().getVersion();
    }

    @Override
    public ArangoDBEngine getEngine() throws ArangoDBException {
        return this.db().getEngine();
    }

    @Override
    public ServerRole getRole() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getRoleRequest(), this.getRoleResponseDeserializer());
    }

    @Override
    public String getServerId() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getServerIdRequest(), this.getServerIdResponseDeserializer());
    }

    @Override
    public UserEntity createUser(String user, String passwd) throws ArangoDBException {
        return (UserEntity)((ArangoExecutorSync)this.executor).execute(this.createUserRequest(this.db().dbName(), user, passwd, new UserCreateOptions()), (java.lang.reflect.Type)((Object)UserEntity.class));
    }

    @Override
    public UserEntity createUser(String user, String passwd, UserCreateOptions options) throws ArangoDBException {
        return (UserEntity)((ArangoExecutorSync)this.executor).execute(this.createUserRequest(this.db().dbName(), user, passwd, options), (java.lang.reflect.Type)((Object)UserEntity.class));
    }

    @Override
    public void deleteUser(String user) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.deleteUserRequest(this.db().dbName(), user), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public UserEntity getUser(String user) throws ArangoDBException {
        return (UserEntity)((ArangoExecutorSync)this.executor).execute(this.getUserRequest(this.db().dbName(), user), (java.lang.reflect.Type)((Object)UserEntity.class));
    }

    @Override
    public Collection<UserEntity> getUsers() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getUsersRequest(this.db().dbName()), this.getUsersResponseDeserializer());
    }

    @Override
    public UserEntity updateUser(String user, UserUpdateOptions options) throws ArangoDBException {
        return (UserEntity)((ArangoExecutorSync)this.executor).execute(this.updateUserRequest(this.db().dbName(), user, options), (java.lang.reflect.Type)((Object)UserEntity.class));
    }

    @Override
    public UserEntity replaceUser(String user, UserUpdateOptions options) throws ArangoDBException {
        return (UserEntity)((ArangoExecutorSync)this.executor).execute(this.replaceUserRequest(this.db().dbName(), user, options), (java.lang.reflect.Type)((Object)UserEntity.class));
    }

    @Override
    public void grantDefaultDatabaseAccess(String user, Permissions permissions) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.updateUserDefaultDatabaseAccessRequest(user, permissions), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public void grantDefaultCollectionAccess(String user, Permissions permissions) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.updateUserDefaultCollectionAccessRequest(user, permissions), (java.lang.reflect.Type)((Object)Void.class));
    }

    @Override
    public Response execute(Request request) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(request, (Response response) -> response);
    }

    @Override
    public Response execute(Request request, HostHandle hostHandle) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(request, response -> response, hostHandle);
    }

    @Override
    public LogEntity getLogs(LogOptions options) throws ArangoDBException {
        return (LogEntity)((ArangoExecutorSync)this.executor).execute(this.getLogsRequest(options), (java.lang.reflect.Type)((Object)LogEntity.class));
    }

    @Override
    public LogEntriesEntity getLogEntries(LogOptions options) throws ArangoDBException {
        return (LogEntriesEntity)((ArangoExecutorSync)this.executor).execute(this.getLogEntriesRequest(options), (java.lang.reflect.Type)((Object)LogEntriesEntity.class));
    }

    @Override
    public LogLevelEntity getLogLevel() throws ArangoDBException {
        return (LogLevelEntity)((ArangoExecutorSync)this.executor).execute(this.getLogLevelRequest(), (java.lang.reflect.Type)((Object)LogLevelEntity.class));
    }

    @Override
    public LogLevelEntity setLogLevel(LogLevelEntity entity) throws ArangoDBException {
        return (LogLevelEntity)((ArangoExecutorSync)this.executor).execute(this.setLogLevelRequest(entity), (java.lang.reflect.Type)((Object)LogLevelEntity.class));
    }

    @Override
    public Collection<QueryOptimizerRule> getQueryOptimizerRules() throws ArangoDBException {
        return (Collection)((ArangoExecutorSync)this.executor).execute(this.getQueryOptimizerRulesRequest(), new Type<Collection<QueryOptimizerRule>>(){}.getType());
    }

    @Override
    public ArangoDBImpl _setCursorInitializer(ArangoCursorInitializer cursorInitializer) {
        this.cursorInitializer = cursorInitializer;
        return this;
    }
}

