/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.ArangoEdgeCollection;
import com.arangodb.ArangoGraph;
import com.arangodb.ArangoVertexCollection;
import com.arangodb.entity.EdgeDefinition;
import com.arangodb.entity.GraphEntity;
import com.arangodb.internal.ArangoDBImpl;
import com.arangodb.internal.ArangoDatabaseImpl;
import com.arangodb.internal.ArangoEdgeCollectionImpl;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.ArangoVertexCollectionImpl;
import com.arangodb.internal.InternalArangoGraph;
import com.arangodb.model.GraphCreateOptions;
import com.arangodb.model.VertexCollectionCreateOptions;
import java.lang.reflect.Type;
import java.util.Collection;

public class ArangoGraphImpl
extends InternalArangoGraph<ArangoDBImpl, ArangoDatabaseImpl, ArangoExecutorSync>
implements ArangoGraph {
    protected ArangoGraphImpl(ArangoDatabaseImpl db, String name) {
        super(db, name);
    }

    @Override
    public boolean exists() throws ArangoDBException {
        try {
            this.getInfo();
            return true;
        }
        catch (ArangoDBException e) {
            if (ArangoErrors.ERROR_GRAPH_NOT_FOUND.equals(e.getErrorNum())) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public GraphEntity create(Collection<EdgeDefinition> edgeDefinitions) throws ArangoDBException {
        return ((ArangoDatabaseImpl)this.db()).createGraph(this.name(), edgeDefinitions);
    }

    @Override
    public GraphEntity create(Collection<EdgeDefinition> edgeDefinitions, GraphCreateOptions options) throws ArangoDBException {
        return ((ArangoDatabaseImpl)this.db()).createGraph(this.name(), edgeDefinitions, options);
    }

    @Override
    public void drop() throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.dropRequest(), (Type)((Object)Void.class));
    }

    @Override
    public void drop(boolean dropCollections) throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.dropRequest(dropCollections), (Type)((Object)Void.class));
    }

    @Override
    public GraphEntity getInfo() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getInfoRequest(), this.getInfoResponseDeserializer());
    }

    @Override
    public Collection<String> getVertexCollections() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getVertexCollectionsRequest(), this.getVertexCollectionsResponseDeserializer());
    }

    @Override
    public GraphEntity addVertexCollection(String name) throws ArangoDBException {
        return this.addVertexCollection(name, new VertexCollectionCreateOptions());
    }

    @Override
    public GraphEntity addVertexCollection(String name, VertexCollectionCreateOptions options) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.addVertexCollectionRequest(name, options), this.addVertexCollectionResponseDeserializer());
    }

    @Override
    public ArangoVertexCollection vertexCollection(String name) {
        return new ArangoVertexCollectionImpl(this, name);
    }

    @Override
    public ArangoEdgeCollection edgeCollection(String name) {
        return new ArangoEdgeCollectionImpl(this, name);
    }

    @Override
    public Collection<String> getEdgeDefinitions() throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.getEdgeDefinitionsRequest(), this.getEdgeDefinitionsDeserializer());
    }

    @Override
    public GraphEntity addEdgeDefinition(EdgeDefinition definition) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.addEdgeDefinitionRequest(definition), this.addEdgeDefinitionResponseDeserializer());
    }

    @Override
    public GraphEntity replaceEdgeDefinition(EdgeDefinition definition) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.replaceEdgeDefinitionRequest(definition), this.replaceEdgeDefinitionResponseDeserializer());
    }

    @Override
    public GraphEntity removeEdgeDefinition(String definitionName) throws ArangoDBException {
        return ((ArangoExecutorSync)this.executor).execute(this.removeEdgeDefinitionRequest(definitionName), this.removeEdgeDefinitionResponseDeserializer());
    }
}

