/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDB;
import com.arangodb.ArangoDBException;
import com.arangodb.entity.LoadBalancingStrategy;
import com.arangodb.internal.ArangoDefaults;
import com.arangodb.internal.net.Connection;
import com.arangodb.internal.net.ConnectionFactory;
import com.arangodb.internal.net.DirtyReadHostHandler;
import com.arangodb.internal.net.ExtendedHostResolver;
import com.arangodb.internal.net.FallbackHostHandler;
import com.arangodb.internal.net.Host;
import com.arangodb.internal.net.HostDescription;
import com.arangodb.internal.net.HostHandler;
import com.arangodb.internal.net.HostResolver;
import com.arangodb.internal.net.RandomHostHandler;
import com.arangodb.internal.net.RoundRobinHostHandler;
import com.arangodb.internal.net.SimpleHostResolver;
import com.arangodb.internal.util.HostUtils;
import com.arangodb.internal.velocypack.VPackDriverModule;
import com.arangodb.util.ArangoDeserializer;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.util.ArangoSerializer;
import com.arangodb.velocypack.VPack;
import com.arangodb.velocypack.VPackParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.HttpRequestRetryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InternalArangoDBBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(InternalArangoDBBuilder.class);
    private static final String PROPERTY_KEY_HOSTS = "arangodb.hosts";
    private static final String PROPERTY_KEY_HOST = "arangodb.host";
    private static final String PROPERTY_KEY_PORT = "arangodb.port";
    private static final String PROPERTY_KEY_TIMEOUT = "arangodb.timeout";
    private static final String PROPERTY_KEY_USER = "arangodb.user";
    private static final String PROPERTY_KEY_PASSWORD = "arangodb.password";
    private static final String PROPERTY_KEY_JWT = "arangodb.jwt";
    private static final String PROPERTY_KEY_USE_SSL = "arangodb.usessl";
    private static final String PROPERTY_KEY_COOKIE_SPEC = "arangodb.httpCookieSpec";
    private static final String PROPERTY_KEY_V_STREAM_CHUNK_CONTENT_SIZE = "arangodb.chunksize";
    private static final String PROPERTY_KEY_MAX_CONNECTIONS = "arangodb.connections.max";
    private static final String PROPERTY_KEY_CONNECTION_TTL = "arangodb.connections.ttl";
    private static final String PROPERTY_KEEP_ALIVE_INTERVAL = "arangodb.connections.keepAlive.interval";
    private static final String PROPERTY_KEY_ACQUIRE_HOST_LIST = "arangodb.acquireHostList";
    private static final String PROPERTY_KEY_ACQUIRE_HOST_LIST_INTERVAL = "arangodb.acquireHostList.interval";
    private static final String PROPERTY_KEY_LOAD_BALANCING_STRATEGY = "arangodb.loadBalancingStrategy";
    private static final String PROPERTY_KEY_RESPONSE_QUEUE_TIME_SAMPLES = "arangodb.metrics.responseQueueTimeSamples";
    private static final String DEFAULT_PROPERTY_FILE = "/arangodb.properties";
    protected final List<HostDescription> hosts;
    protected HostDescription host;
    protected Integer timeout;
    protected String user;
    protected String password;
    protected String jwt;
    protected Boolean useSsl;
    protected String httpCookieSpec;
    protected HttpRequestRetryHandler httpRequestRetryHandler;
    protected SSLContext sslContext;
    protected HostnameVerifier hostnameVerifier;
    protected Integer chunksize;
    protected Integer maxConnections;
    protected Long connectionTtl;
    protected Integer keepAliveInterval;
    protected final VPack.Builder vpackBuilder = new VPack.Builder();
    protected final VPackParser.Builder vpackParserBuilder = new VPackParser.Builder();
    protected ArangoSerializer serializer;
    protected ArangoDeserializer deserializer;
    protected Boolean acquireHostList;
    protected Integer acquireHostListInterval;
    protected LoadBalancingStrategy loadBalancingStrategy;
    protected ArangoSerialization customSerializer;
    protected Integer responseQueueTimeSamples;

    public InternalArangoDBBuilder() {
        this.vpackBuilder.registerModule(new VPackDriverModule());
        this.vpackParserBuilder.registerModule(new VPackDriverModule());
        this.host = new HostDescription("127.0.0.1", ArangoDefaults.DEFAULT_PORT);
        this.hosts = new ArrayList<HostDescription>();
        this.user = "root";
        this.loadProperties(ArangoDB.class.getResourceAsStream(DEFAULT_PROPERTY_FILE));
    }

    public InternalArangoDBBuilder loadProperties(InputStream in) throws ArangoDBException {
        Properties properties = new Properties();
        if (in != null) {
            try {
                properties.load(in);
            }
            catch (IOException e) {
                throw new ArangoDBException(e);
            }
        }
        this.loadProperties(properties);
        return this;
    }

    protected void loadProperties(Properties properties) {
        InternalArangoDBBuilder.loadHosts(properties, this.hosts);
        String host = InternalArangoDBBuilder.loadHost(properties, this.host.getHost());
        int port = InternalArangoDBBuilder.loadPort(properties, this.host.getPort());
        this.host = new HostDescription(host, port);
        this.timeout = InternalArangoDBBuilder.loadTimeout(properties, this.timeout);
        this.user = InternalArangoDBBuilder.loadUser(properties, this.user);
        this.password = InternalArangoDBBuilder.loadPassword(properties, this.password);
        this.jwt = InternalArangoDBBuilder.loadJwt(properties, this.jwt);
        this.useSsl = InternalArangoDBBuilder.loadUseSsl(properties, this.useSsl);
        this.httpCookieSpec = InternalArangoDBBuilder.loadhttpCookieSpec(properties, this.httpCookieSpec);
        this.chunksize = InternalArangoDBBuilder.loadChunkSize(properties, this.chunksize);
        this.maxConnections = InternalArangoDBBuilder.loadMaxConnections(properties, this.maxConnections);
        this.connectionTtl = InternalArangoDBBuilder.loadConnectionTtl(properties, this.connectionTtl);
        this.keepAliveInterval = InternalArangoDBBuilder.loadKeepAliveInterval(properties, this.keepAliveInterval);
        this.acquireHostList = InternalArangoDBBuilder.loadAcquireHostList(properties, this.acquireHostList);
        this.acquireHostListInterval = InternalArangoDBBuilder.loadAcquireHostListInterval(properties, this.acquireHostListInterval);
        this.loadBalancingStrategy = InternalArangoDBBuilder.loadLoadBalancingStrategy(properties, this.loadBalancingStrategy);
        this.responseQueueTimeSamples = InternalArangoDBBuilder.loadResponseQueueTimeSamples(properties, this.responseQueueTimeSamples);
    }

    protected void setHost(String host, int port) {
        this.hosts.add(new HostDescription(host, port));
    }

    protected void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    protected void setUser(String user) {
        this.user = user;
    }

    protected void setPassword(String password) {
        this.password = password;
    }

    protected void setJwt(String jwt) {
        this.jwt = jwt;
    }

    protected void setUseSsl(Boolean useSsl) {
        this.useSsl = useSsl;
    }

    protected void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    protected void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    protected void setHttpRequestRetryHandler(HttpRequestRetryHandler httpRequestRetryHandler) {
        this.httpRequestRetryHandler = httpRequestRetryHandler;
    }

    protected void setChunksize(Integer chunksize) {
        this.chunksize = chunksize;
    }

    protected void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    protected void setConnectionTtl(Long connectionTtl) {
        this.connectionTtl = connectionTtl;
    }

    protected void setKeepAliveInterval(Integer keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    protected void setAcquireHostList(Boolean acquireHostList) {
        this.acquireHostList = acquireHostList;
    }

    protected void setAcquireHostListInterval(Integer acquireHostListInterval) {
        this.acquireHostListInterval = acquireHostListInterval;
    }

    protected void setLoadBalancingStrategy(LoadBalancingStrategy loadBalancingStrategy) {
        this.loadBalancingStrategy = loadBalancingStrategy;
    }

    protected void setResponseQueueTimeSamples(Integer responseQueueTimeSamples) {
        this.responseQueueTimeSamples = responseQueueTimeSamples;
    }

    protected void serializer(ArangoSerializer serializer) {
        this.serializer = serializer;
    }

    protected void deserializer(ArangoDeserializer deserializer) {
        this.deserializer = deserializer;
    }

    protected void setSerializer(ArangoSerialization serializer) {
        this.customSerializer = serializer;
    }

    private static void loadHosts(Properties properties, Collection<HostDescription> hosts) {
        String hostsProp = properties.getProperty(PROPERTY_KEY_HOSTS);
        if (hostsProp != null) {
            String[] hostsSplit;
            for (String host : hostsSplit = hostsProp.split(",")) {
                String[] split = host.split(":");
                if (split.length != 2 || !split[1].matches("[0-9]+")) {
                    throw new ArangoDBException(String.format("Could not load property-value arangodb.hosts=%s. Expected format ip:port,ip:port,...", hostsProp));
                }
                hosts.add(new HostDescription(split[0], Integer.parseInt(split[1])));
            }
        }
    }

    protected HostHandler createHostHandler(HostResolver hostResolver) {
        HostHandler hostHandler;
        if (this.loadBalancingStrategy != null) {
            switch (this.loadBalancingStrategy) {
                case ONE_RANDOM: {
                    hostHandler = new RandomHostHandler(hostResolver, new FallbackHostHandler(hostResolver));
                    break;
                }
                case ROUND_ROBIN: {
                    hostHandler = new RoundRobinHostHandler(hostResolver);
                    break;
                }
                default: {
                    hostHandler = new FallbackHostHandler(hostResolver);
                    break;
                }
            }
        } else {
            hostHandler = new FallbackHostHandler(hostResolver);
        }
        LOG.debug("HostHandler is " + hostHandler.getClass().getSimpleName());
        return new DirtyReadHostHandler(hostHandler, new RoundRobinHostHandler(hostResolver));
    }

    protected HostResolver createHostResolver(Collection<Host> hosts, int maxConnections, ConnectionFactory connectionFactory) {
        if (this.acquireHostList != null && this.acquireHostList.booleanValue()) {
            LOG.debug("acquireHostList -> Use ExtendedHostResolver");
            return new ExtendedHostResolver(new ArrayList<Host>(hosts), maxConnections, connectionFactory, this.acquireHostListInterval);
        }
        LOG.debug("Use SimpleHostResolver");
        return new SimpleHostResolver(new ArrayList<Host>(hosts));
    }

    private static String loadHost(Properties properties, String currentValue) {
        String host = InternalArangoDBBuilder.getProperty(properties, PROPERTY_KEY_HOST, currentValue, "127.0.0.1");
        if (host.contains(":")) {
            throw new ArangoDBException(String.format("Could not load property-value arangodb.host=%s. Expect only ip. Do you mean arangodb.hosts=ip:port ?", host));
        }
        return host;
    }

    private static Integer loadPort(Properties properties, int currentValue) {
        return Integer.parseInt(InternalArangoDBBuilder.getProperty(properties, PROPERTY_KEY_PORT, currentValue, ArangoDefaults.DEFAULT_PORT));
    }

    private static Integer loadTimeout(Properties properties, Integer currentValue) {
        return Integer.parseInt(InternalArangoDBBuilder.getProperty(properties, PROPERTY_KEY_TIMEOUT, currentValue, ArangoDefaults.DEFAULT_TIMEOUT));
    }

    private static String loadUser(Properties properties, String currentValue) {
        return InternalArangoDBBuilder.getProperty(properties, PROPERTY_KEY_USER, currentValue, "root");
    }

    private static String loadPassword(Properties properties, String currentValue) {
        return InternalArangoDBBuilder.getProperty(properties, PROPERTY_KEY_PASSWORD, currentValue, null);
    }

    private static String loadJwt(Properties properties, String currentValue) {
        return InternalArangoDBBuilder.getProperty(properties, PROPERTY_KEY_JWT, currentValue, null);
    }

    private static Boolean loadUseSsl(Properties properties, Boolean currentValue) {
        return Boolean.parseBoolean(InternalArangoDBBuilder.getProperty(properties, PROPERTY_KEY_USE_SSL, currentValue, ArangoDefaults.DEFAULT_USE_SSL));
    }

    private static String loadhttpCookieSpec(Properties properties, String currentValue) {
        return InternalArangoDBBuilder.getProperty(properties, PROPERTY_KEY_COOKIE_SPEC, currentValue, "");
    }

    private static Integer loadChunkSize(Properties properties, Integer currentValue) {
        return Integer.parseInt(InternalArangoDBBuilder.getProperty(properties, PROPERTY_KEY_V_STREAM_CHUNK_CONTENT_SIZE, currentValue, 30000));
    }

    private static Integer loadMaxConnections(Properties properties, Integer currentValue) {
        return Integer.parseInt(InternalArangoDBBuilder.getProperty(properties, PROPERTY_KEY_MAX_CONNECTIONS, currentValue, 1));
    }

    private static Long loadConnectionTtl(Properties properties, Long currentValue) {
        String ttl = InternalArangoDBBuilder.getProperty(properties, PROPERTY_KEY_CONNECTION_TTL, currentValue, ArangoDefaults.CONNECTION_TTL_VST_DEFAULT);
        return ttl != null ? Long.valueOf(Long.parseLong(ttl)) : null;
    }

    private static Integer loadKeepAliveInterval(Properties properties, Integer currentValue) {
        String keepAliveInterval = InternalArangoDBBuilder.getProperty(properties, PROPERTY_KEEP_ALIVE_INTERVAL, currentValue, null);
        return keepAliveInterval != null ? Integer.valueOf(Integer.parseInt(keepAliveInterval)) : null;
    }

    private static Boolean loadAcquireHostList(Properties properties, Boolean currentValue) {
        return Boolean.parseBoolean(InternalArangoDBBuilder.getProperty(properties, PROPERTY_KEY_ACQUIRE_HOST_LIST, currentValue, false));
    }

    private static int loadAcquireHostListInterval(Properties properties, Integer currentValue) {
        return Integer.parseInt(InternalArangoDBBuilder.getProperty(properties, PROPERTY_KEY_ACQUIRE_HOST_LIST_INTERVAL, currentValue, 3600000));
    }

    private static int loadResponseQueueTimeSamples(Properties properties, Integer currentValue) {
        return Integer.parseInt(InternalArangoDBBuilder.getProperty(properties, PROPERTY_KEY_RESPONSE_QUEUE_TIME_SAMPLES, currentValue, 10));
    }

    private static LoadBalancingStrategy loadLoadBalancingStrategy(Properties properties, LoadBalancingStrategy currentValue) {
        return LoadBalancingStrategy.valueOf(InternalArangoDBBuilder.getProperty(properties, PROPERTY_KEY_LOAD_BALANCING_STRATEGY, currentValue, ArangoDefaults.DEFAULT_LOAD_BALANCING_STRATEGY).toUpperCase(Locale.ENGLISH));
    }

    protected static <T> String getProperty(Properties properties, String key, T currentValue, T defaultValue) {
        String overrideDefaultValue = null;
        if (currentValue != null) {
            overrideDefaultValue = currentValue.toString();
        } else if (defaultValue != null) {
            overrideDefaultValue = defaultValue.toString();
        }
        return properties.getProperty(key, overrideDefaultValue);
    }

    protected <C extends Connection> Collection<Host> createHostList(int maxConnections, ConnectionFactory connectionFactory) {
        ArrayList<Host> hostList = new ArrayList<Host>();
        for (HostDescription host : this.hosts) {
            hostList.add(HostUtils.createHost(host, maxConnections, connectionFactory));
        }
        return hostList;
    }
}

