/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal;

import com.arangodb.ArangoDBException;
import com.arangodb.SearchAlias;
import com.arangodb.entity.ViewEntity;
import com.arangodb.entity.arangosearch.SearchAliasPropertiesEntity;
import com.arangodb.internal.ArangoDBImpl;
import com.arangodb.internal.ArangoDatabaseImpl;
import com.arangodb.internal.ArangoErrors;
import com.arangodb.internal.ArangoExecutorSync;
import com.arangodb.internal.InternalSearchAlias;
import com.arangodb.model.arangosearch.SearchAliasCreateOptions;
import com.arangodb.model.arangosearch.SearchAliasPropertiesOptions;
import java.lang.reflect.Type;

public class SearchAliasImpl
extends InternalSearchAlias<ArangoDBImpl, ArangoDatabaseImpl, ArangoExecutorSync>
implements SearchAlias {
    protected SearchAliasImpl(ArangoDatabaseImpl db, String name) {
        super(db, name);
    }

    @Override
    public boolean exists() throws ArangoDBException {
        try {
            this.getInfo();
            return true;
        }
        catch (ArangoDBException e) {
            if (ArangoErrors.ERROR_ARANGO_DATA_SOURCE_NOT_FOUND.equals(e.getErrorNum())) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public void drop() throws ArangoDBException {
        ((ArangoExecutorSync)this.executor).execute(this.dropRequest(), (Type)((Object)Void.class));
    }

    @Override
    public synchronized ViewEntity rename(String newName) throws ArangoDBException {
        ViewEntity result = (ViewEntity)((ArangoExecutorSync)this.executor).execute(this.renameRequest(newName), (Type)((Object)ViewEntity.class));
        this.name = result.getName();
        return result;
    }

    @Override
    public ViewEntity getInfo() throws ArangoDBException {
        return (ViewEntity)((ArangoExecutorSync)this.executor).execute(this.getInfoRequest(), (Type)((Object)ViewEntity.class));
    }

    @Override
    public ViewEntity create() throws ArangoDBException {
        return this.create(new SearchAliasCreateOptions());
    }

    @Override
    public ViewEntity create(SearchAliasCreateOptions options) throws ArangoDBException {
        return ((ArangoDatabaseImpl)this.db()).createSearchAlias(this.name(), options);
    }

    @Override
    public SearchAliasPropertiesEntity getProperties() throws ArangoDBException {
        return (SearchAliasPropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.getPropertiesRequest(), (Type)((Object)SearchAliasPropertiesEntity.class));
    }

    @Override
    public SearchAliasPropertiesEntity updateProperties(SearchAliasPropertiesOptions options) throws ArangoDBException {
        return (SearchAliasPropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.updatePropertiesRequest(options), (Type)((Object)SearchAliasPropertiesEntity.class));
    }

    @Override
    public SearchAliasPropertiesEntity replaceProperties(SearchAliasPropertiesOptions options) throws ArangoDBException {
        return (SearchAliasPropertiesEntity)((ArangoExecutorSync)this.executor).execute(this.replacePropertiesRequest(options), (Type)((Object)SearchAliasPropertiesEntity.class));
    }
}

