/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.mapping;

import com.arangodb.entity.BaseDocument;
import com.arangodb.entity.BaseEdgeDocument;
import com.arangodb.jackson.dataformat.velocypack.internal.VPackGenerator;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.internal.util.DateUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;

public class VPackSerializers {
    public static final JsonSerializer<VPackSlice> VPACK = new JsonSerializer<VPackSlice>(){

        public void serialize(VPackSlice value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (gen instanceof VPackGenerator) {
                ((VPackGenerator)gen).writeVPack(value);
            } else {
                gen.writeBinary(value.toByteArray());
            }
        }
    };
    public static final JsonSerializer<Date> UTIL_DATE = new JsonSerializer<Date>(){

        public void serialize(Date value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeString(DateUtil.format(value));
        }
    };
    public static final JsonSerializer<java.sql.Date> SQL_DATE = new JsonSerializer<java.sql.Date>(){

        public void serialize(java.sql.Date value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeString(DateUtil.format(value));
        }
    };
    public static final JsonSerializer<Timestamp> SQL_TIMESTAMP = new JsonSerializer<Timestamp>(){

        public void serialize(Timestamp value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
            gen.writeString(DateUtil.format(value));
        }
    };
    public static final JsonSerializer<BaseDocument> BASE_DOCUMENT = new JsonSerializer<BaseDocument>(){

        public void serialize(BaseDocument value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            HashMap<String, Object> doc = new HashMap<String, Object>();
            doc.putAll(value.getProperties());
            doc.put("_id", value.getId());
            doc.put("_key", value.getKey());
            doc.put("_rev", value.getRevision());
            gen.writeObject(doc);
        }
    };
    public static final JsonSerializer<BaseEdgeDocument> BASE_EDGE_DOCUMENT = new JsonSerializer<BaseEdgeDocument>(){

        public void serialize(BaseEdgeDocument value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            HashMap<String, Object> doc = new HashMap<String, Object>();
            doc.putAll(value.getProperties());
            doc.put("_id", value.getId());
            doc.put("_key", value.getKey());
            doc.put("_rev", value.getRevision());
            doc.put("_from", value.getFrom());
            doc.put("_to", value.getTo());
            gen.writeObject(doc);
        }
    };
}

