/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.util;

import com.arangodb.ArangoDBException;
import com.arangodb.util.ArangoSerializer;
import com.arangodb.velocypack.VPack;
import com.arangodb.velocypack.VPackParser;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocypack.exception.VPackException;
import java.util.Iterator;

public class ArangoSerializerImpl
implements ArangoSerializer {
    private final VPack vpacker;
    private final VPack vpackerNull;
    private final VPackParser vpackParser;

    public ArangoSerializerImpl(VPack vpacker, VPack vpackerNull, VPackParser vpackParser) {
        this.vpacker = vpacker;
        this.vpackerNull = vpackerNull;
        this.vpackParser = vpackParser;
    }

    @Override
    public VPackSlice serialize(Object entity) throws ArangoDBException {
        return this.serialize(entity, new ArangoSerializer.Options());
    }

    @Override
    public VPackSlice serialize(Object entity, ArangoSerializer.Options options) throws ArangoDBException {
        if (options.getType() == null) {
            options.type(entity.getClass());
        }
        try {
            VPackSlice vpack;
            Class<?> type = entity.getClass();
            boolean serializeNullValues = options.isSerializeNullValues();
            if (String.class.isAssignableFrom(type)) {
                vpack = this.vpackParser.fromJson((String)entity, serializeNullValues);
            } else if (options.isStringAsJson() && Iterable.class.isAssignableFrom(type)) {
                Iterator iterator = ((Iterable)entity).iterator();
                if (iterator.hasNext() && String.class.isAssignableFrom(iterator.next().getClass())) {
                    vpack = this.vpackParser.fromJson((Iterable<String>)((Iterable)entity), serializeNullValues);
                } else {
                    VPack vp = serializeNullValues ? this.vpackerNull : this.vpacker;
                    vpack = vp.serialize(entity, new VPack.SerializeOptions().type(options.getType()).additionalFields(options.getAdditionalFields()));
                }
            } else {
                VPack vp = serializeNullValues ? this.vpackerNull : this.vpacker;
                vpack = vp.serialize(entity, new VPack.SerializeOptions().type(options.getType()).additionalFields(options.getAdditionalFields()));
            }
            return vpack;
        }
        catch (VPackException e) {
            throw new ArangoDBException(e);
        }
    }
}

