/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.internal.velocypack;

import com.arangodb.entity.BaseDocument;
import com.arangodb.entity.BaseEdgeDocument;
import com.arangodb.entity.CollectionStatus;
import com.arangodb.entity.CollectionType;
import com.arangodb.entity.InvertedIndexPrimarySort;
import com.arangodb.entity.License;
import com.arangodb.entity.LogLevel;
import com.arangodb.entity.MinReplicationFactor;
import com.arangodb.entity.Permissions;
import com.arangodb.entity.QueryExecutionState;
import com.arangodb.entity.ReplicationFactor;
import com.arangodb.entity.ViewEntity;
import com.arangodb.entity.ViewType;
import com.arangodb.entity.arangosearch.AnalyzerType;
import com.arangodb.entity.arangosearch.ArangoSearchCompression;
import com.arangodb.entity.arangosearch.ArangoSearchProperties;
import com.arangodb.entity.arangosearch.ArangoSearchPropertiesEntity;
import com.arangodb.entity.arangosearch.CollectionLink;
import com.arangodb.entity.arangosearch.ConsolidationPolicy;
import com.arangodb.entity.arangosearch.ConsolidationType;
import com.arangodb.entity.arangosearch.FieldLink;
import com.arangodb.entity.arangosearch.PrimarySort;
import com.arangodb.entity.arangosearch.SearchAliasIndex;
import com.arangodb.entity.arangosearch.SearchAliasProperties;
import com.arangodb.entity.arangosearch.SearchAliasPropertiesEntity;
import com.arangodb.entity.arangosearch.StoreValuesType;
import com.arangodb.entity.arangosearch.StoredValue;
import com.arangodb.entity.arangosearch.analyzer.AQLAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.ClassificationAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.CollationAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.DelimiterAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.GeoJSONAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.GeoPointAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.IdentityAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.MinHashAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.NGramAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.NearestNeighborsAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.NormAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.PipelineAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.SearchAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.SegmentationAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.StemAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.StopwordsAnalyzer;
import com.arangodb.entity.arangosearch.analyzer.TextAnalyzer;
import com.arangodb.model.CollectionSchema;
import com.arangodb.model.ZKDIndexOptions;
import com.arangodb.velocypack.VPackDeserializer;
import com.arangodb.velocypack.VPackParser;
import com.arangodb.velocypack.VPackSlice;
import com.arangodb.velocystream.Response;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VPackDeserializers {
    private static final Logger LOGGER = LoggerFactory.getLogger(VPackDeserializers.class);
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final VPackDeserializer<Response> RESPONSE = (parent, vpack, context) -> {
        Response response = new Response();
        response.setVersion(vpack.get(0).getAsInt());
        response.setType(vpack.get(1).getAsInt());
        response.setResponseCode(vpack.get(2).getAsInt());
        if (vpack.size() > 3) {
            response.setMeta((Map)context.deserialize(vpack.get(3), (Type)((Object)Map.class)));
        }
        return response;
    };
    public static final VPackDeserializer<CollectionType> COLLECTION_TYPE = (parent, vpack, context) -> CollectionType.fromType(vpack.getAsInt());
    public static final VPackDeserializer<CollectionStatus> COLLECTION_STATUS = (parent, vpack, context) -> CollectionStatus.fromStatus(vpack.getAsInt());
    public static final VPackDeserializer<BaseDocument> BASE_DOCUMENT = (parent, vpack, context) -> new BaseDocument((Map)context.deserialize(vpack, (Type)((Object)Map.class)));
    public static final VPackDeserializer<SearchAnalyzer> SEARCH_ANALYZER = (parent, vpack, context) -> {
        AnalyzerType type = (AnalyzerType)((Object)((Object)context.deserialize(vpack.get("type"), (Type)((Object)AnalyzerType.class))));
        switch (type) {
            case identity: {
                return (SearchAnalyzer)context.deserialize(vpack, (Type)((Object)IdentityAnalyzer.class));
            }
            case text: {
                return (SearchAnalyzer)context.deserialize(vpack, (Type)((Object)TextAnalyzer.class));
            }
            case ngram: {
                return (SearchAnalyzer)context.deserialize(vpack, (Type)((Object)NGramAnalyzer.class));
            }
            case delimiter: {
                return (SearchAnalyzer)context.deserialize(vpack, (Type)((Object)DelimiterAnalyzer.class));
            }
            case stem: {
                return (SearchAnalyzer)context.deserialize(vpack, (Type)((Object)StemAnalyzer.class));
            }
            case norm: {
                return (SearchAnalyzer)context.deserialize(vpack, (Type)((Object)NormAnalyzer.class));
            }
            case pipeline: {
                return (SearchAnalyzer)context.deserialize(vpack, (Type)((Object)PipelineAnalyzer.class));
            }
            case stopwords: {
                return (SearchAnalyzer)context.deserialize(vpack, (Type)((Object)StopwordsAnalyzer.class));
            }
            case aql: {
                return (SearchAnalyzer)context.deserialize(vpack, (Type)((Object)AQLAnalyzer.class));
            }
            case geojson: {
                return (SearchAnalyzer)context.deserialize(vpack, (Type)((Object)GeoJSONAnalyzer.class));
            }
            case geopoint: {
                return (SearchAnalyzer)context.deserialize(vpack, (Type)((Object)GeoPointAnalyzer.class));
            }
            case segmentation: {
                return (SearchAnalyzer)context.deserialize(vpack, (Type)((Object)SegmentationAnalyzer.class));
            }
            case collation: {
                return (SearchAnalyzer)context.deserialize(vpack, (Type)((Object)CollationAnalyzer.class));
            }
            case classification: {
                return (SearchAnalyzer)context.deserialize(vpack, (Type)((Object)ClassificationAnalyzer.class));
            }
            case nearest_neighbors: {
                return (SearchAnalyzer)context.deserialize(vpack, (Type)((Object)NearestNeighborsAnalyzer.class));
            }
            case minhash: {
                return (SearchAnalyzer)context.deserialize(vpack, (Type)((Object)MinHashAnalyzer.class));
            }
        }
        throw new IllegalArgumentException("Unknown analyzer type: " + (Object)((Object)type));
    };
    public static final VPackDeserializer<BaseEdgeDocument> BASE_EDGE_DOCUMENT = (parent, vpack, context) -> new BaseEdgeDocument((Map)context.deserialize(vpack, (Type)((Object)Map.class)));
    public static final VPackDeserializer<Date> DATE_STRING = (parent, vpack, context) -> {
        try {
            return new SimpleDateFormat(DATE_TIME_FORMAT).parse(vpack.getAsString());
        }
        catch (ParseException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("got ParseException for date string: " + vpack.getAsString());
            }
            return null;
        }
    };
    public static final VPackDeserializer<LogLevel> LOG_LEVEL = (parent, vpack, context) -> LogLevel.fromLevel(vpack.getAsInt());
    public static final VPackDeserializer<License> LICENSE = (parent, vpack, context) -> License.valueOf(vpack.getAsString().toUpperCase(Locale.ENGLISH));
    public static final VPackDeserializer<Permissions> PERMISSIONS = (parent, vpack, context) -> Permissions.valueOf(vpack.getAsString().toUpperCase(Locale.ENGLISH));
    public static final VPackDeserializer<QueryExecutionState> QUERY_EXECUTION_STATE = (parent, vpack, context) -> QueryExecutionState.valueOf(vpack.getAsString().toUpperCase(Locale.ENGLISH).replaceAll(" ", "_"));
    public static final VPackDeserializer<ReplicationFactor> REPLICATION_FACTOR = (parent, vpack, context) -> {
        ReplicationFactor replicationFactor = new ReplicationFactor();
        if (vpack.isString() && vpack.getAsString().equals("satellite")) {
            replicationFactor.setSatellite(true);
        } else {
            replicationFactor.setReplicationFactor(vpack.getAsInt());
        }
        return replicationFactor;
    };
    public static final VPackDeserializer<MinReplicationFactor> MIN_REPLICATION_FACTOR = (parent, vpack, context) -> {
        MinReplicationFactor minReplicationFactor = new MinReplicationFactor();
        minReplicationFactor.setMinReplicationFactor(vpack.getAsInt());
        return minReplicationFactor;
    };
    public static final VPackDeserializer<ViewType> VIEW_TYPE = (parent, vpack, context) -> {
        String value;
        switch (value = vpack.getAsString()) {
            case "arangosearch": {
                return ViewType.ARANGO_SEARCH;
            }
            case "search-alias": {
                return ViewType.SEARCH_ALIAS;
            }
        }
        throw new IllegalArgumentException("Unknown view type: " + value);
    };
    public static final VPackDeserializer<StoredValue> STORED_VALUE = (parent, vpack, context) -> {
        VPackSlice fields = vpack.get("fields");
        VPackSlice compression = vpack.get("compression");
        VPackSlice cache = vpack.get("cache");
        Boolean cacheValue = cache.isBoolean() ? Boolean.valueOf(cache.getAsBoolean()) : null;
        Iterator<VPackSlice> fieldsIterator = fields.arrayIterator();
        ArrayList<String> fieldsList = new ArrayList<String>();
        while (fieldsIterator.hasNext()) {
            fieldsList.add(fieldsIterator.next().getAsString());
        }
        return new StoredValue(fieldsList, ArangoSearchCompression.valueOf(compression.getAsString()), cacheValue);
    };
    public static final VPackDeserializer<ArangoSearchProperties> ARANGO_SEARCH_PROPERTIES = (parent, vpack, context) -> {
        VPackSlice primarySortCompression;
        VPackSlice primarySorts;
        VPackSlice links;
        VPackSlice consolidationPolicy;
        VPackSlice cleanupIntervalStep;
        VPackSlice commitIntervalMsec;
        ArangoSearchProperties properties = new ArangoSearchProperties();
        VPackSlice consolidationIntervalMsec = vpack.get("consolidationIntervalMsec");
        if (consolidationIntervalMsec.isInteger()) {
            properties.setConsolidationIntervalMsec(consolidationIntervalMsec.getAsLong());
        }
        if ((commitIntervalMsec = vpack.get("commitIntervalMsec")).isInteger()) {
            properties.setCommitIntervalMsec(commitIntervalMsec.getAsLong());
        }
        if ((cleanupIntervalStep = vpack.get("cleanupIntervalStep")).isInteger()) {
            properties.setCleanupIntervalStep(cleanupIntervalStep.getAsLong());
        }
        if ((consolidationPolicy = vpack.get("consolidationPolicy")).isObject()) {
            properties.setConsolidationPolicy((ConsolidationPolicy)context.deserialize(consolidationPolicy, (Type)((Object)ConsolidationPolicy.class)));
        }
        if ((links = vpack.get("links")).isObject()) {
            Iterator<Map.Entry<String, VPackSlice>> collectionIterator = links.objectIterator();
            while (collectionIterator.hasNext()) {
                VPackSlice nested;
                VPackSlice fields;
                VPackSlice storeValues;
                VPackSlice trackListPositions;
                VPackSlice cache;
                VPackSlice includeAllFields;
                Map.Entry<String, VPackSlice> entry = collectionIterator.next();
                VPackSlice value = entry.getValue();
                CollectionLink link = CollectionLink.on(entry.getKey());
                VPackSlice analyzers = value.get("analyzers");
                if (analyzers.isArray()) {
                    Iterator<VPackSlice> analyzerIterator = analyzers.arrayIterator();
                    while (analyzerIterator.hasNext()) {
                        link.analyzers(analyzerIterator.next().getAsString());
                    }
                }
                if ((includeAllFields = value.get("includeAllFields")).isBoolean()) {
                    link.includeAllFields(includeAllFields.getAsBoolean());
                }
                if ((cache = value.get("cache")).isBoolean()) {
                    link.cache(cache.getAsBoolean());
                }
                if ((trackListPositions = value.get("trackListPositions")).isBoolean()) {
                    link.trackListPositions(trackListPositions.getAsBoolean());
                }
                if ((storeValues = value.get("storeValues")).isString()) {
                    link.storeValues(StoreValuesType.valueOf(storeValues.getAsString().toUpperCase(Locale.ENGLISH)));
                }
                if ((fields = value.get("fields")).isObject()) {
                    Iterator<Map.Entry<String, VPackSlice>> fieldsIterator = fields.objectIterator();
                    while (fieldsIterator.hasNext()) {
                        link.fields(VPackDeserializers.deserializeField(fieldsIterator.next()));
                    }
                }
                if ((nested = value.get("nested")).isObject()) {
                    Iterator<Map.Entry<String, VPackSlice>> fieldsIterator = nested.objectIterator();
                    while (fieldsIterator.hasNext()) {
                        link.nested(VPackDeserializers.deserializeField(fieldsIterator.next()));
                    }
                }
                properties.addLink(link);
            }
        }
        if ((primarySorts = vpack.get("primarySort")).isArray()) {
            Iterator<VPackSlice> primarySortsIterator = primarySorts.arrayIterator();
            while (primarySortsIterator.hasNext()) {
                VPackSlice entry = primarySortsIterator.next();
                if (!entry.isObject() || !entry.get("field").isString() || !entry.get("asc").isBoolean()) continue;
                PrimarySort primarySort = PrimarySort.on(entry.get("field").getAsString());
                primarySort.ascending(entry.get("asc").getAsBoolean());
                properties.addPrimarySort(primarySort);
            }
        }
        if ((primarySortCompression = vpack.get("primarySortCompression")).isString()) {
            properties.setPrimarySortCompression(ArangoSearchCompression.valueOf(primarySortCompression.getAsString()));
        }
        VPackSlice storedValues = vpack.get("storedValues");
        Iterator<VPackSlice> storedValueIterator = storedValues.arrayIterator();
        while (storedValueIterator.hasNext()) {
            StoredValue sv = (StoredValue)context.deserialize(storedValueIterator.next(), (Type)((Object)StoredValue.class));
            properties.addStoredValues(sv);
        }
        return properties;
    };
    public static final VPackDeserializer<ArangoSearchPropertiesEntity> ARANGO_SEARCH_PROPERTIES_ENTITY = (parent, vpack, context) -> {
        ViewEntity entity = (ViewEntity)context.deserialize(vpack, (Type)((Object)ViewEntity.class));
        ArangoSearchProperties properties = (ArangoSearchProperties)context.deserialize(vpack, (Type)((Object)ArangoSearchProperties.class));
        return new ArangoSearchPropertiesEntity(entity.getId(), entity.getName(), entity.getType(), properties);
    };
    public static final VPackDeserializer<ConsolidationPolicy> CONSOLIDATE = (parent, vpack, context) -> {
        ConsolidationType type = ConsolidationType.valueOf(vpack.get("type").getAsString().toUpperCase(Locale.ENGLISH));
        ConsolidationPolicy consolidate = ConsolidationPolicy.of(type);
        if (ConsolidationType.BYTES_ACCUM.equals((Object)type)) {
            consolidate.threshold(vpack.get("threshold").getAsDouble());
        } else {
            consolidate.segmentsMin(vpack.get("segmentsMin").getAsLong());
            consolidate.segmentsMax(vpack.get("segmentsMax").getAsLong());
            consolidate.segmentsBytesMax(vpack.get("segmentsBytesMax").getAsLong());
            consolidate.segmentsBytesFloor(vpack.get("segmentsBytesFloor").getAsLong());
            consolidate.minScore(vpack.get("minScore").getAsLong());
        }
        return consolidate;
    };
    public static final VPackDeserializer<CollectionSchema> COLLECTION_VALIDATION = (parent, vpack, context) -> {
        VPackParser parser = new VPackParser.Builder().build();
        CollectionSchema collectionValidation = new CollectionSchema();
        collectionValidation.setLevel(CollectionSchema.Level.of(vpack.get("level").getAsString()));
        collectionValidation.setRule(parser.toJson(vpack.get("rule"), true));
        collectionValidation.setMessage(vpack.get("message").getAsString());
        return collectionValidation;
    };
    public static final VPackDeserializer<ZKDIndexOptions.FieldValueTypes> ZKD_FIELD_VALUE_TYPES = (parent, vpack, context) -> ZKDIndexOptions.FieldValueTypes.valueOf(vpack.getAsString().toUpperCase(Locale.ENGLISH));
    public static final VPackDeserializer<InvertedIndexPrimarySort.Field> INVERTED_INDEX_PRIMARY_SORT_FIELD = (parent, vpack, context) -> {
        InvertedIndexPrimarySort.Field.Direction dir = vpack.get("asc").getAsBoolean() ? InvertedIndexPrimarySort.Field.Direction.asc : InvertedIndexPrimarySort.Field.Direction.desc;
        return new InvertedIndexPrimarySort.Field(vpack.get("field").getAsString(), dir);
    };
    public static final VPackDeserializer<SearchAliasPropertiesEntity> SEARCH_ALIAS_PROPERTIES_ENTITY = (parent, vpack, context) -> {
        String id = vpack.get("id").getAsString();
        String name = vpack.get("name").getAsString();
        ViewType type = (ViewType)((Object)((Object)context.deserialize(vpack.get("type"), (Type)((Object)ViewType.class))));
        SearchAliasProperties properties = (SearchAliasProperties)context.deserialize(vpack, (Type)((Object)SearchAliasProperties.class));
        return new SearchAliasPropertiesEntity(id, name, type, properties);
    };
    public static final VPackDeserializer<SearchAliasIndex> SEARCH_ALIAS_INDEX = (parent, vpack, context) -> {
        String collection = vpack.get("collection").getAsString();
        String index = vpack.get("index").getAsString();
        return new SearchAliasIndex(collection, index);
    };

    protected static FieldLink deserializeField(Map.Entry<String, VPackSlice> field) {
        VPackSlice nested;
        VPackSlice fields;
        VPackSlice storeValues;
        VPackSlice trackListPositions;
        VPackSlice includeAllFields;
        VPackSlice value = field.getValue();
        FieldLink link = FieldLink.on(field.getKey());
        VPackSlice analyzers = value.get("analyzers");
        if (analyzers.isArray()) {
            Iterator<VPackSlice> analyzerIterator = analyzers.arrayIterator();
            while (analyzerIterator.hasNext()) {
                link.analyzers(analyzerIterator.next().getAsString());
            }
        }
        if ((includeAllFields = value.get("includeAllFields")).isBoolean()) {
            link.includeAllFields(includeAllFields.getAsBoolean());
        }
        if ((trackListPositions = value.get("trackListPositions")).isBoolean()) {
            link.trackListPositions(trackListPositions.getAsBoolean());
        }
        if ((storeValues = value.get("storeValues")).isString()) {
            link.storeValues(StoreValuesType.valueOf(storeValues.getAsString().toUpperCase(Locale.ENGLISH)));
        }
        if ((fields = value.get("fields")).isObject()) {
            Iterator<Map.Entry<String, VPackSlice>> fieldsIterator = fields.objectIterator();
            while (fieldsIterator.hasNext()) {
                link.fields(VPackDeserializers.deserializeField(fieldsIterator.next()));
            }
        }
        if ((nested = value.get("nested")).isObject()) {
            Iterator<Map.Entry<String, VPackSlice>> fieldsIterator = nested.objectIterator();
            while (fieldsIterator.hasNext()) {
                link.nested(VPackDeserializers.deserializeField(fieldsIterator.next()));
            }
        }
        return link;
    }
}

