/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.mapping;

import com.arangodb.ArangoDBException;
import com.arangodb.entity.BaseDocument;
import com.arangodb.entity.BaseEdgeDocument;
import com.arangodb.internal.mapping.ArangoAnnotationIntrospector;
import com.arangodb.internal.mapping.VPackDeserializers;
import com.arangodb.internal.mapping.VPackSerializers;
import com.arangodb.jackson.dataformat.velocypack.VPackMapper;
import com.arangodb.util.ArangoSerialization;
import com.arangodb.util.ArangoSerializer;
import com.arangodb.velocypack.VPackParser;
import com.arangodb.velocypack.VPackSlice;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Iterator;

public class ArangoJack
implements ArangoSerialization {
    private final ObjectMapper vpackMapper;
    private final ObjectMapper vpackMapperNull;
    private final ObjectMapper jsonMapper;
    private final VPackParser vpackParser;

    static VPackMapper createDefaultMapper() {
        VPackMapper mapper = new VPackMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        ArangoModule module = new ArangoModule();
        module.addSerializer(VPackSlice.class, VPackSerializers.VPACK);
        module.addSerializer(java.util.Date.class, VPackSerializers.UTIL_DATE);
        module.addSerializer(Date.class, VPackSerializers.SQL_DATE);
        module.addSerializer(Timestamp.class, VPackSerializers.SQL_TIMESTAMP);
        module.addSerializer(BaseDocument.class, VPackSerializers.BASE_DOCUMENT);
        module.addSerializer(BaseEdgeDocument.class, VPackSerializers.BASE_EDGE_DOCUMENT);
        module.addDeserializer(VPackSlice.class, VPackDeserializers.VPACK);
        module.addDeserializer(java.util.Date.class, VPackDeserializers.UTIL_DATE);
        module.addDeserializer(Date.class, VPackDeserializers.SQL_DATE);
        module.addDeserializer(Timestamp.class, VPackDeserializers.SQL_TIMESTAMP);
        module.addDeserializer(BaseDocument.class, VPackDeserializers.BASE_DOCUMENT);
        module.addDeserializer(BaseEdgeDocument.class, VPackDeserializers.BASE_EDGE_DOCUMENT);
        mapper.registerModule((Module)module);
        return mapper;
    }

    public ArangoJack() {
        this(ArangoJack.createDefaultMapper());
    }

    public ArangoJack(VPackMapper mapper) {
        this.vpackMapper = mapper.copy().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.vpackMapperNull = mapper.copy().setSerializationInclusion(JsonInclude.Include.ALWAYS);
        this.jsonMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.vpackParser = new VPackParser.Builder().build();
    }

    public void configure(ConfigureFunction f) {
        f.configure(this.vpackMapper);
        f.configure(this.vpackMapperNull);
        f.configure(this.jsonMapper);
    }

    @Override
    public VPackSlice serialize(Object entity) throws ArangoDBException {
        return this.serialize(entity, new ArangoSerializer.Options());
    }

    @Override
    public VPackSlice serialize(Object entity, ArangoSerializer.Options options) throws ArangoDBException {
        if (options.getType() == null) {
            options.type(entity.getClass());
        }
        try {
            VPackSlice vpack;
            Class<?> type = entity.getClass();
            boolean serializeNullValues = options.isSerializeNullValues();
            if (String.class.isAssignableFrom(type)) {
                vpack = this.vpackParser.fromJson((String)entity, serializeNullValues);
            } else if (options.isStringAsJson() && Iterable.class.isAssignableFrom(type)) {
                Iterator iterator = ((Iterable)Iterable.class.cast(entity)).iterator();
                if (iterator.hasNext() && String.class.isAssignableFrom(iterator.next().getClass())) {
                    vpack = this.vpackParser.fromJson((Iterable<String>)((Iterable)entity), serializeNullValues);
                } else {
                    ObjectMapper vp = serializeNullValues ? this.vpackMapperNull : this.vpackMapper;
                    vpack = new VPackSlice(vp.writeValueAsBytes(entity));
                }
            } else {
                ObjectMapper vp = serializeNullValues ? this.vpackMapperNull : this.vpackMapper;
                vpack = new VPackSlice(vp.writeValueAsBytes(entity));
            }
            return vpack;
        }
        catch (JsonProcessingException e) {
            throw new ArangoDBException(e);
        }
    }

    @Override
    public <T> T deserialize(VPackSlice vpack, Type type) throws ArangoDBException {
        try {
            Object doc;
            if (type == String.class && !vpack.isString() && !vpack.isNull()) {
                JsonNode node = this.vpackMapper.readTree(Arrays.copyOfRange(vpack.getBuffer(), vpack.getStart(), vpack.getStart() + vpack.getByteSize()));
                doc = this.jsonMapper.writeValueAsString((Object)node);
            } else {
                doc = this.vpackMapper.readValue(vpack.getBuffer(), vpack.getStart(), vpack.getStart() + vpack.getByteSize(), (Class)type);
            }
            return (T)doc;
        }
        catch (IOException e) {
            throw new ArangoDBException(e);
        }
    }

    private static final class ArangoModule
    extends SimpleModule {
        private ArangoModule() {
        }

        public void setupModule(Module.SetupContext context) {
            super.setupModule(context);
            context.insertAnnotationIntrospector((AnnotationIntrospector)new ArangoAnnotationIntrospector());
        }
    }

    public static interface ConfigureFunction {
        public void configure(ObjectMapper var1);
    }
}

