/*
 * Decompiled with CFR 0.152.
 */
package com.arangodb.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class ComputedValue {
    private String name;
    private String expression;
    private Boolean overwrite;
    private Set<ComputeOn> computeOn;
    private Boolean keepNull;
    private Boolean failOnWarning;

    public ComputedValue name(String name) {
        this.name = name;
        return this;
    }

    public ComputedValue expression(String expression) {
        this.expression = expression;
        return this;
    }

    public ComputedValue overwrite(Boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    public ComputedValue computeOn(ComputeOn ... computeOn) {
        if (this.computeOn == null) {
            this.computeOn = new HashSet<ComputeOn>();
        }
        Collections.addAll(this.computeOn, computeOn);
        return this;
    }

    public ComputedValue keepNull(Boolean keepNull) {
        this.keepNull = keepNull;
        return this;
    }

    public ComputedValue failOnWarning(Boolean failOnWarning) {
        this.failOnWarning = failOnWarning;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComputedValue that = (ComputedValue)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.expression, that.expression) && Objects.equals(this.overwrite, that.overwrite) && Objects.equals(this.computeOn, that.computeOn) && Objects.equals(this.keepNull, that.keepNull) && Objects.equals(this.failOnWarning, that.failOnWarning);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.expression, this.overwrite, this.computeOn, this.keepNull, this.failOnWarning);
    }

    public static enum ComputeOn {
        insert,
        update,
        replace;

    }
}

