/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.arangodb;

import org.apache.camel.CamelContext;
import org.apache.camel.component.arangodb.ArangoDbComponent;
import org.apache.camel.component.arangodb.ArangoDbConfiguration;
import org.apache.camel.component.arangodb.ArangoDbOperation;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class ArangoDbComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private ArangoDbConfiguration getOrCreateConfiguration(ArangoDbComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new ArangoDbConfiguration());
        }
        return target.getConfiguration();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        ArangoDbComponent target = (ArangoDbComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(ArangoDbComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(ArangoDbComponentConfigurer.property(camelContext, ArangoDbConfiguration.class, value));
                return true;
            }
            case "documentcollection": 
            case "documentCollection": {
                this.getOrCreateConfiguration(target).setDocumentCollection(ArangoDbComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "edgecollection": 
            case "edgeCollection": {
                this.getOrCreateConfiguration(target).setEdgeCollection(ArangoDbComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "graph": {
                this.getOrCreateConfiguration(target).setGraph(ArangoDbComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "host": {
                this.getOrCreateConfiguration(target).setHost(ArangoDbComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(ArangoDbComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation(ArangoDbComponentConfigurer.property(camelContext, ArangoDbOperation.class, value));
                return true;
            }
            case "password": {
                this.getOrCreateConfiguration(target).setPassword(ArangoDbComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "port": {
                this.getOrCreateConfiguration(target).setPort(ArangoDbComponentConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "user": {
                this.getOrCreateConfiguration(target).setUser(ArangoDbComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "vertexcollection": 
            case "vertexCollection": {
                this.getOrCreateConfiguration(target).setVertexCollection(ArangoDbComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return ArangoDbConfiguration.class;
            }
            case "documentcollection": 
            case "documentCollection": {
                return String.class;
            }
            case "edgecollection": 
            case "edgeCollection": {
                return String.class;
            }
            case "graph": {
                return String.class;
            }
            case "host": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "operation": {
                return ArangoDbOperation.class;
            }
            case "password": {
                return String.class;
            }
            case "port": {
                return Integer.TYPE;
            }
            case "user": {
                return String.class;
            }
            case "vertexcollection": 
            case "vertexCollection": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        ArangoDbComponent target = (ArangoDbComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "documentcollection": 
            case "documentCollection": {
                return this.getOrCreateConfiguration(target).getDocumentCollection();
            }
            case "edgecollection": 
            case "edgeCollection": {
                return this.getOrCreateConfiguration(target).getEdgeCollection();
            }
            case "graph": {
                return this.getOrCreateConfiguration(target).getGraph();
            }
            case "host": {
                return this.getOrCreateConfiguration(target).getHost();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "password": {
                return this.getOrCreateConfiguration(target).getPassword();
            }
            case "port": {
                return this.getOrCreateConfiguration(target).getPort();
            }
            case "user": {
                return this.getOrCreateConfiguration(target).getUser();
            }
            case "vertexcollection": 
            case "vertexCollection": {
                return this.getOrCreateConfiguration(target).getVertexCollection();
            }
        }
        return null;
    }
}

