/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.arangodb;

import com.arangodb.ArangoDB;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.arangodb.ArangoDbComponent;
import org.apache.camel.component.arangodb.ArangoDbConfiguration;
import org.apache.camel.component.arangodb.ArangoDbConstants;
import org.apache.camel.component.arangodb.ArangoDbProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.5.0", scheme="arangodb", title="ArangoDb", syntax="arangodb:database", category={Category.DATABASE, Category.NOSQL}, producerOnly=true, headersClass=ArangoDbConstants.class)
public class ArangoDbEndpoint
extends DefaultEndpoint {
    private ArangoDB arango;
    @UriPath(description="database name")
    @Metadata(required=true)
    private String database;
    @UriParam
    private ArangoDbConfiguration configuration;

    public ArangoDbEndpoint() {
    }

    public ArangoDbEndpoint(String uri, ArangoDbComponent component, ArangoDbConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    @Override
    public Producer createProducer() {
        return new ArangoDbProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) {
        throw new UnsupportedOperationException("You cannot receive messages at this endpoint: " + this.getEndpointUri());
    }

    public ArangoDB getArango() {
        return this.arango;
    }

    public void setArango(ArangoDB arango) {
        this.arango = arango;
    }

    public ArangoDbConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ArangoDbConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this.arango == null) {
            ArangoDB.Builder builder = new ArangoDB.Builder();
            if (ObjectHelper.isNotEmpty(this.configuration.getHost()) && ObjectHelper.isNotEmpty(this.configuration.getPort())) {
                builder.host(this.configuration.getHost(), this.configuration.getPort());
            }
            if (ObjectHelper.isNotEmpty(this.configuration.getUser()) && ObjectHelper.isNotEmpty(this.configuration.getPassword())) {
                builder.user(this.configuration.getUser()).password(this.configuration.getPassword());
            }
            this.arango = builder.build();
        }
    }

    @Override
    protected void doShutdown() throws Exception {
        super.doShutdown();
        if (this.arango != null) {
            this.arango.shutdown();
        }
    }
}

