/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api;

import java.io.IOException;
import java.net.Socket;
import org.apache.camel.component.as2.api.io.AS2BHttpClientConnection;
import org.apache.camel.component.as2.api.protocol.RequestAS2;
import org.apache.camel.component.as2.api.protocol.RequestMDN;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.impl.DefaultBHttpClientConnection;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestDate;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.util.Args;

public class AS2ClientConnection {
    private HttpHost targetHost;
    private HttpProcessor httpProcessor;
    private DefaultBHttpClientConnection httpConnection;
    private String as2Version;
    private String userAgent;
    private String clientFqdn;

    public AS2ClientConnection(String as2Version, String userAgent, String clientFqdn, String targetHostName, Integer targetPortNumber) throws IOException {
        this.as2Version = Args.notNull(as2Version, "as2Version");
        this.userAgent = Args.notNull(userAgent, "userAgent");
        this.clientFqdn = Args.notNull(clientFqdn, "clientFqdn");
        this.targetHost = new HttpHost(Args.notNull(targetHostName, "targetHostName"), (int)Args.notNull(targetPortNumber, "targetPortNumber"));
        this.httpProcessor = HttpProcessorBuilder.create().add(new RequestAS2(as2Version, clientFqdn)).add(new RequestMDN()).add(new RequestTargetHost()).add(new RequestUserAgent(this.userAgent)).add(new RequestDate()).add(new RequestContent(true)).add(new RequestConnControl()).add(new RequestExpectContinue(true)).build();
        Socket socket = new Socket(this.targetHost.getHostName(), this.targetHost.getPort());
        this.httpConnection = new AS2BHttpClientConnection(8192);
        this.httpConnection.bind(socket);
    }

    public String getAs2Version() {
        return this.as2Version;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getClientFqdn() {
        return this.clientFqdn;
    }

    public HttpResponse send(HttpRequest request, HttpCoreContext httpContext) throws HttpException, IOException {
        httpContext.setTargetHost(this.targetHost);
        HttpRequestExecutor httpexecutor = new HttpRequestExecutor();
        httpexecutor.preProcess(request, this.httpProcessor, httpContext);
        HttpResponse response = httpexecutor.execute(request, this.httpConnection, httpContext);
        httpexecutor.postProcess(response, this.httpProcessor, httpContext);
        return response;
    }
}

