/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.apache.camel.component.as2.api.AS2ClientConnection;
import org.apache.camel.component.as2.api.AS2CompressionAlgorithm;
import org.apache.camel.component.as2.api.AS2EncryptionAlgorithm;
import org.apache.camel.component.as2.api.AS2MessageStructure;
import org.apache.camel.component.as2.api.AS2SignatureAlgorithm;
import org.apache.camel.component.as2.api.AS2SignedDataGenerator;
import org.apache.camel.component.as2.api.entity.ApplicationEDIEntity;
import org.apache.camel.component.as2.api.entity.ApplicationPkcs7MimeCompressedDataEntity;
import org.apache.camel.component.as2.api.entity.ApplicationPkcs7MimeEnvelopedDataEntity;
import org.apache.camel.component.as2.api.entity.EntityParser;
import org.apache.camel.component.as2.api.entity.MultipartSignedEntity;
import org.apache.camel.component.as2.api.util.CompressionUtils;
import org.apache.camel.component.as2.api.util.EncryptingUtils;
import org.apache.camel.component.as2.api.util.EntityUtils;
import org.apache.camel.component.as2.api.util.SigningUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.util.Args;
import org.bouncycastle.cms.CMSCompressedDataGenerator;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.operator.OutputCompressor;
import org.bouncycastle.operator.OutputEncryptor;

public class AS2ClientManager {
    public static final String CAMEL_AS2_CLIENT_PREFIX = "camel-as2.client.";
    public static final String AS2_MESSAGE_STRUCTURE = "camel-as2.client.as2-message-structure";
    public static final String EDI_MESSAGE_CONTENT_TYPE = "camel-as2.client.edi-message-content-type";
    public static final String EDI_MESSAGE_TRANSFER_ENCODING = "camel-as2.client.edi-message-transfer-encoding";
    public static final String HTTP_REQUEST = "http.request";
    public static final String HTTP_RESPONSE = "http.response";
    public static final String AS2_CONNECTION = "camel-as2.client.as2-connection";
    public static final String REQUEST_URI = "camel-as2.client.request-uri";
    public static final String SUBJECT = "camel-as2.client.subject";
    public static final String FROM = "camel-as2.client.from";
    public static final String AS2_FROM = "camel-as2.client.as2-from";
    public static final String AS2_TO = "camel-as2.client.as2-to";
    public static final String SIGNING_ALGORITHM = "camel-as2.client.signing-algorithm";
    public static final String SIGNING_CERTIFICATE_CHAIN = "camel-as2.client.signing-certificate-chain";
    public static final String SIGNING_PRIVATE_KEY = "camel-as2.client.signing-private-key";
    public static final String ENCRYPTING_ALGORITHM = "camel-as2.client.encrypting-algorithm-name";
    public static final String ENCRYPTING_CERTIFICATE_CHAIN = "camel-as2.client.encrypting-certificate-chain";
    public static final String COMPRESSION_ALGORITHM = "camel-as2.client.compression-algorithm-name";
    public static final String DISPOSITION_NOTIFICATION_TO = "camel-as2.client.disposition-notification-to";
    public static final String SIGNED_RECEIPT_MIC_ALGORITHMS = "camel-as2.client.signed-receipt-mic-algorithms";
    private AS2ClientConnection as2ClientConnection;

    public AS2ClientManager(AS2ClientConnection as2ClientConnection) {
        this.as2ClientConnection = as2ClientConnection;
    }

    public HttpCoreContext send(String ediMessage, String requestUri, String subject, String from, String as2From, String as2To, AS2MessageStructure as2MessageStructure, ContentType ediMessageContentType, String ediMessageTransferEncoding, AS2SignatureAlgorithm signingAlgorithm, Certificate[] signingCertificateChain, PrivateKey signingPrivateKey, AS2CompressionAlgorithm compressionAlgorithm, String dispositionNotificationTo, String[] signedReceiptMicAlgorithms, AS2EncryptionAlgorithm encryptingAlgorithm, Certificate[] encryptingCertificateChain) throws HttpException {
        HttpResponse response;
        ApplicationEDIEntity applicationEDIEntity;
        Args.notNull(ediMessage, "EDI Message");
        Args.notNull(requestUri, "Request URI");
        Args.notNull(subject, "Subject");
        Args.notNull(from, "Subject");
        Args.notNull(as2From, "Subject");
        Args.notNull(as2To, "Subject");
        Args.notNull(as2MessageStructure, "AS2 Message Structure");
        Args.notNull(ediMessageContentType, "EDI Message Content Type");
        HttpCoreContext httpContext = HttpCoreContext.create();
        httpContext.setAttribute(REQUEST_URI, requestUri);
        httpContext.setAttribute(SUBJECT, subject);
        httpContext.setAttribute(FROM, from);
        httpContext.setAttribute(AS2_FROM, as2From);
        httpContext.setAttribute(AS2_TO, as2To);
        httpContext.setAttribute(AS2_MESSAGE_STRUCTURE, (Object)as2MessageStructure);
        httpContext.setAttribute(EDI_MESSAGE_CONTENT_TYPE, ediMessageContentType);
        httpContext.setAttribute(EDI_MESSAGE_TRANSFER_ENCODING, ediMessageTransferEncoding);
        httpContext.setAttribute(SIGNING_ALGORITHM, (Object)signingAlgorithm);
        httpContext.setAttribute(SIGNING_CERTIFICATE_CHAIN, signingCertificateChain);
        httpContext.setAttribute(SIGNING_PRIVATE_KEY, signingPrivateKey);
        httpContext.setAttribute(COMPRESSION_ALGORITHM, (Object)compressionAlgorithm);
        httpContext.setAttribute(DISPOSITION_NOTIFICATION_TO, dispositionNotificationTo);
        httpContext.setAttribute(SIGNED_RECEIPT_MIC_ALGORITHMS, signedReceiptMicAlgorithms);
        httpContext.setAttribute(ENCRYPTING_ALGORITHM, (Object)encryptingAlgorithm);
        httpContext.setAttribute(ENCRYPTING_CERTIFICATE_CHAIN, encryptingCertificateChain);
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", requestUri);
        httpContext.setAttribute(HTTP_REQUEST, request);
        try {
            applicationEDIEntity = EntityUtils.createEDIEntity(ediMessage, ediMessageContentType, ediMessageTransferEncoding, false);
        }
        catch (Exception e) {
            throw new HttpException("Failed to create EDI message entity", e);
        }
        switch (as2MessageStructure) {
            case PLAIN: {
                applicationEDIEntity.setMainBody(true);
                EntityUtils.setMessageEntity(request, applicationEDIEntity);
                break;
            }
            case SIGNED: {
                AS2SignedDataGenerator signingGenrator = this.createSigningGenerator(httpContext);
                MultipartSignedEntity multipartSignedEntity = new MultipartSignedEntity(applicationEDIEntity, signingGenrator, "US-ASCII", "base64", true, null);
                EntityUtils.setMessageEntity(request, multipartSignedEntity);
                break;
            }
            case ENCRYPTED: {
                CMSEnvelopedDataGenerator envelopedDataGenerator = this.createEncryptingGenerator(httpContext);
                OutputEncryptor encryptor = this.createEncryptor(httpContext);
                ApplicationPkcs7MimeEnvelopedDataEntity pkcs7MimeEnvelopedDataEntity = new ApplicationPkcs7MimeEnvelopedDataEntity(applicationEDIEntity, envelopedDataGenerator, encryptor, "base64", true);
                EntityUtils.setMessageEntity(request, pkcs7MimeEnvelopedDataEntity);
                break;
            }
            case SIGNED_ENCRYPTED: {
                AS2SignedDataGenerator signingGenrator = this.createSigningGenerator(httpContext);
                MultipartSignedEntity multipartSignedEntity = new MultipartSignedEntity(applicationEDIEntity, signingGenrator, "US-ASCII", "base64", false, null);
                CMSEnvelopedDataGenerator envelopedDataGenerator = this.createEncryptingGenerator(httpContext);
                OutputEncryptor encryptor = this.createEncryptor(httpContext);
                ApplicationPkcs7MimeEnvelopedDataEntity pkcs7MimeEnvelopedDataEntity = new ApplicationPkcs7MimeEnvelopedDataEntity(multipartSignedEntity, envelopedDataGenerator, encryptor, "base64", true);
                EntityUtils.setMessageEntity(request, pkcs7MimeEnvelopedDataEntity);
                break;
            }
            case PLAIN_COMPRESSED: {
                CMSCompressedDataGenerator compressedDataGenerator = this.createCompressorGenerator(httpContext);
                OutputCompressor compressor = this.createCompressor(httpContext);
                ApplicationPkcs7MimeCompressedDataEntity pkcs7MimeCompressedDataEntity = new ApplicationPkcs7MimeCompressedDataEntity(applicationEDIEntity, compressedDataGenerator, compressor, "base64", true);
                EntityUtils.setMessageEntity(request, pkcs7MimeCompressedDataEntity);
                break;
            }
            case SIGNED_COMPRESSED: {
                AS2SignedDataGenerator signingGenrator = this.createSigningGenerator(httpContext);
                MultipartSignedEntity multipartSignedEntity = new MultipartSignedEntity(applicationEDIEntity, signingGenrator, "US-ASCII", "base64", false, null);
                CMSCompressedDataGenerator compressedDataGenerator = this.createCompressorGenerator(httpContext);
                OutputCompressor compressor = this.createCompressor(httpContext);
                ApplicationPkcs7MimeCompressedDataEntity pkcs7MimeCompressedDataEntity = new ApplicationPkcs7MimeCompressedDataEntity(multipartSignedEntity, compressedDataGenerator, compressor, "base64", true);
                EntityUtils.setMessageEntity(request, pkcs7MimeCompressedDataEntity);
                break;
            }
            case ENCRYPTED_COMPRESSED: {
                CMSCompressedDataGenerator compressedDataGenerator = this.createCompressorGenerator(httpContext);
                OutputCompressor compressor = this.createCompressor(httpContext);
                ApplicationPkcs7MimeCompressedDataEntity pkcs7MimeCompressedDataEntity = new ApplicationPkcs7MimeCompressedDataEntity(applicationEDIEntity, compressedDataGenerator, compressor, "base64", false);
                CMSEnvelopedDataGenerator envelopedDataGenerator = this.createEncryptingGenerator(httpContext);
                OutputEncryptor encryptor = this.createEncryptor(httpContext);
                ApplicationPkcs7MimeEnvelopedDataEntity pkcs7MimeEnvelopedDataEntity = new ApplicationPkcs7MimeEnvelopedDataEntity(pkcs7MimeCompressedDataEntity, envelopedDataGenerator, encryptor, "base64", true);
                EntityUtils.setMessageEntity(request, pkcs7MimeEnvelopedDataEntity);
                break;
            }
            case ENCRYPTED_COMPRESSED_SIGNED: {
                AS2SignedDataGenerator signingGenrator = this.createSigningGenerator(httpContext);
                MultipartSignedEntity multipartSignedEntity = new MultipartSignedEntity(applicationEDIEntity, signingGenrator, "US-ASCII", "base64", false, null);
                CMSCompressedDataGenerator compressedDataGenerator = this.createCompressorGenerator(httpContext);
                OutputCompressor compressor = this.createCompressor(httpContext);
                ApplicationPkcs7MimeCompressedDataEntity pkcs7MimeCompressedDataEntity = new ApplicationPkcs7MimeCompressedDataEntity(multipartSignedEntity, compressedDataGenerator, compressor, "base64", false);
                CMSEnvelopedDataGenerator envelopedDataGenerator = this.createEncryptingGenerator(httpContext);
                OutputEncryptor encryptor = this.createEncryptor(httpContext);
                ApplicationPkcs7MimeEnvelopedDataEntity pkcs7MimeEnvelopedDataEntity = new ApplicationPkcs7MimeEnvelopedDataEntity(pkcs7MimeCompressedDataEntity, envelopedDataGenerator, encryptor, "base64", true);
                EntityUtils.setMessageEntity(request, pkcs7MimeEnvelopedDataEntity);
                break;
            }
            default: {
                throw new HttpException("Unknown AS2 Message Structure");
            }
        }
        try {
            httpContext.setAttribute(AS2_CONNECTION, this.as2ClientConnection);
            response = this.as2ClientConnection.send(request, httpContext);
            EntityParser.parseAS2MessageEntity(response);
        }
        catch (IOException e) {
            throw new HttpException("Failed to send http request message", e);
        }
        httpContext.setAttribute(HTTP_RESPONSE, response);
        return httpContext;
    }

    public AS2SignedDataGenerator createSigningGenerator(HttpCoreContext httpContext) throws HttpException {
        AS2SignatureAlgorithm signatureAlgorithm = httpContext.getAttribute(SIGNING_ALGORITHM, AS2SignatureAlgorithm.class);
        if (signatureAlgorithm == null) {
            throw new HttpException("Signing algorithm missing");
        }
        Certificate[] certificateChain = httpContext.getAttribute(SIGNING_CERTIFICATE_CHAIN, Certificate[].class);
        if (certificateChain == null) {
            throw new HttpException("Signing certificate chain missing");
        }
        PrivateKey privateKey = httpContext.getAttribute(SIGNING_PRIVATE_KEY, PrivateKey.class);
        if (privateKey == null) {
            throw new HttpException("Signing private key missing");
        }
        return SigningUtils.createSigningGenerator(signatureAlgorithm, certificateChain, privateKey);
    }

    public CMSEnvelopedDataGenerator createEncryptingGenerator(HttpCoreContext httpContext) throws HttpException {
        Certificate[] certificateChain = httpContext.getAttribute(ENCRYPTING_CERTIFICATE_CHAIN, Certificate[].class);
        if (certificateChain == null) {
            throw new HttpException("Encrypting certificate chain missing");
        }
        return EncryptingUtils.createEnvelopDataGenerator(certificateChain);
    }

    public CMSCompressedDataGenerator createCompressorGenerator(HttpCoreContext httpContext) {
        return CompressionUtils.createCompressedDataGenerator();
    }

    public OutputEncryptor createEncryptor(HttpCoreContext httpContext) throws HttpException {
        AS2EncryptionAlgorithm encryptionAlgorithm = httpContext.getAttribute(ENCRYPTING_ALGORITHM, AS2EncryptionAlgorithm.class);
        if (encryptionAlgorithm == null) {
            throw new HttpException("Encrypting algorithm missing");
        }
        return EncryptingUtils.createEncryptor(encryptionAlgorithm);
    }

    public OutputCompressor createCompressor(HttpCoreContext httpContext) throws HttpException {
        AS2CompressionAlgorithm compressionAlgorithm = httpContext.getAttribute(COMPRESSION_ALGORITHM, AS2CompressionAlgorithm.class);
        if (compressionAlgorithm == null) {
            throw new HttpException("Compression algorithm missing");
        }
        return CompressionUtils.createCompressor(compressionAlgorithm);
    }
}

