/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api;

import java.security.Key;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;

public class AS2SignedDataGenerator
extends CMSSignedDataGenerator {
    public static final Map<ASN1ObjectIdentifier, String> STANDARD_MICALGS;
    public static final String[] DSA_SIGNING_ALGORITHMS;
    public static final String[] RSA_SIGNING_ALGORITHMS;
    public static final String[] EC_SIGNING_ALGORITHMS;

    public ContentType createMultipartSignedContentType(String boundary) {
        String micAlg;
        ASN1ObjectIdentifier digestOID;
        StringBuffer header = new StringBuffer("multipart/signed; protocol=\"application/pkcs7-signature\"");
        header.append("; boundary=" + boundary);
        HashSet<String> micAlgSet = new HashSet<String>();
        for (SignerInformation signer : this._signers) {
            digestOID = signer.getDigestAlgorithmID().getAlgorithm();
            micAlg = STANDARD_MICALGS.get(digestOID);
            if (micAlg == null) {
                micAlgSet.add("unknown");
                continue;
            }
            micAlgSet.add(micAlg);
        }
        for (SignerInfoGenerator signerInfoGen : this.signerGens) {
            digestOID = signerInfoGen.getDigestAlgorithm().getAlgorithm();
            micAlg = STANDARD_MICALGS.get(digestOID);
            if (micAlg == null) {
                micAlgSet.add("unknown");
                continue;
            }
            micAlgSet.add(micAlg);
        }
        int count = 0;
        for (String micAlg2 : micAlgSet) {
            if (count == 0) {
                if (micAlgSet.size() != 1) {
                    header.append("; micalg=\"");
                } else {
                    header.append("; micalg=");
                }
            } else {
                header.append(',');
            }
            header.append(micAlg2);
            ++count;
        }
        if (count != 0 && micAlgSet.size() != 1) {
            header.append('\"');
        }
        return ContentType.parse(header.toString());
    }

    public static String[] getSupportedSignatureAlgorithmNamesForKey(Key key) {
        switch (key.getAlgorithm()) {
            case "DSA": {
                return DSA_SIGNING_ALGORITHMS;
            }
            case "RSA": {
                return RSA_SIGNING_ALGORITHMS;
            }
            case "EC": {
                return EC_SIGNING_ALGORITHMS;
            }
        }
        return new String[0];
    }

    static {
        HashMap<ASN1ObjectIdentifier, String> stdMicAlgs = new HashMap<ASN1ObjectIdentifier, String>();
        stdMicAlgs.put(CMSAlgorithm.MD5, "md5");
        stdMicAlgs.put(CMSAlgorithm.SHA1, "sha-1");
        stdMicAlgs.put(CMSAlgorithm.SHA224, "sha-224");
        stdMicAlgs.put(CMSAlgorithm.SHA256, "sha-256");
        stdMicAlgs.put(CMSAlgorithm.SHA384, "sha-384");
        stdMicAlgs.put(CMSAlgorithm.SHA512, "sha-512");
        stdMicAlgs.put(CMSAlgorithm.GOST3411, "gostr3411-94");
        stdMicAlgs.put(CMSAlgorithm.GOST3411_2012_256, "gostr3411-2012-256");
        stdMicAlgs.put(CMSAlgorithm.GOST3411_2012_512, "gostr3411-2012-512");
        STANDARD_MICALGS = Collections.unmodifiableMap(stdMicAlgs);
        DSA_SIGNING_ALGORITHMS = new String[]{"SHA512WITHDSA", "SHA384WITHDSA", "SHA256WITHDSA", "SHA224WITHDSA", "SHA1WITHDSA"};
        RSA_SIGNING_ALGORITHMS = new String[]{"SHA512WITHRSA", "SHA384WITHRSA", "SHA256WITHRSA", "SHA224WITHRSA", "SHA1WITHRSA", "MD5WITHRSA", "MD2WITHRSA"};
        EC_SIGNING_ALGORITHMS = new String[]{"SHA512WITHECDSA", "SHA384WITHECDSA", "SHA256WITHECDSA", "SHA224WITHECDSA", "SHA1WITHECDSA"};
    }
}

