/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.entity;

import java.security.PrivateKey;
import java.util.Map;
import org.apache.camel.component.as2.api.entity.AS2DispositionModifier;
import org.apache.camel.component.as2.api.entity.AS2DispositionType;
import org.apache.camel.component.as2.api.entity.AS2MessageDispositionNotificationEntity;
import org.apache.camel.component.as2.api.entity.DispositionMode;
import org.apache.camel.component.as2.api.entity.MultipartReportEntity;
import org.apache.camel.component.as2.api.entity.TextPlainEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.util.Args;

public class DispositionNotificationMultipartReportEntity
extends MultipartReportEntity {
    protected DispositionNotificationMultipartReportEntity(String boundary, boolean isMainBody) {
        this.boundary = boundary;
        this.isMainBody = isMainBody;
        this.removeHeaders("Content-Type");
        this.setContentType(this.getContentTypeValue(boundary));
    }

    public DispositionNotificationMultipartReportEntity(HttpEntityEnclosingRequest request, HttpResponse response, DispositionMode dispositionMode, AS2DispositionType dispositionType, AS2DispositionModifier dispositionModifier, String[] failureFields, String[] errorFields, String[] warningFields, Map<String, String> extensionFields, String charset, String boundary, boolean isMainBody, PrivateKey decryptingPrivateKey, String mdnMessage) throws HttpException {
        super(charset, isMainBody, boundary);
        this.removeHeaders("Content-Type");
        this.setContentType(this.getContentTypeValue(boundary));
        Args.notNull(dispositionMode, "dispositionMode");
        Args.notNull(dispositionType, "dispositionType");
        Args.notNull(mdnMessage, "mdnMessageTemplate");
        this.addPart(this.buildPlainTextReport(mdnMessage));
        this.addPart(new AS2MessageDispositionNotificationEntity(request, response, dispositionMode, dispositionType, dispositionModifier, failureFields, errorFields, warningFields, extensionFields, charset, false, decryptingPrivateKey));
    }

    public String getMainMessageContentType() {
        return "multipart/report; report-type=disposition-notification; boundary=\"" + this.boundary + "\"";
    }

    protected TextPlainEntity buildPlainTextReport(String mdnMessage) {
        return new TextPlainEntity(mdnMessage, "US-ASCII", "7bit", false);
    }

    protected String getContentTypeValue(String boundary) {
        ContentType contentType = ContentType.parse("multipart/report;report-type=disposition-notification; boundary=\"" + boundary + "\"");
        return contentType.toString();
    }
}

