/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api.util;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.component.as2.api.entity.AS2DispositionModifier;
import org.apache.camel.component.as2.api.entity.AS2DispositionType;
import org.apache.camel.component.as2.api.entity.AS2MessageDispositionNotificationEntity;
import org.apache.camel.component.as2.api.entity.DispositionMode;
import org.apache.camel.component.as2.api.util.MicUtils;
import org.apache.http.ParseException;
import org.apache.http.message.ParserCursor;
import org.apache.http.message.TokenParser;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

public final class DispositionNotificationContentUtils {
    private static final String REPORTING_UA = "reporting-ua";
    private static final String MDN_GATEWAY = "mdn-gateway";
    private static final String FINAL_RECIPIENT = "final-recipient";
    private static final String ORIGINAL_MESSAGE_ID = "original-message-id";
    private static final String DISPOSITION = "disposition";
    private static final String FAILURE = "failure";
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private static final String RECEIVED_CONTENT_MIC = "received-content-mic";
    private static final TokenParser TOKEN_PARSER = TokenParser.INSTANCE;
    private static final char PARAM_DELIMITER = ',';
    private static final char ELEM_DELIMITER = ';';
    private static final BitSet TOKEN_DELIMS = TokenParser.INIT_BITSET(44, 59);

    private DispositionNotificationContentUtils() {
    }

    public static AS2MessageDispositionNotificationEntity parseDispositionNotification(List<CharArrayBuffer> dispositionNotificationFields) throws ParseException {
        String reportingUA = null;
        String mtaName = null;
        String finalRecipient = null;
        String originalMessageId = null;
        DispositionMode dispositionMode = null;
        AS2DispositionType dispositionType = null;
        AS2DispositionModifier dispositionModifier = null;
        ArrayList<String> failures = new ArrayList<String>();
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> warnings = new ArrayList<String>();
        HashMap<String, String> extensionFields = new HashMap<String, String>();
        MicUtils.ReceivedContentMic receivedContentMic = null;
        block22: for (int i = 0; i < dispositionNotificationFields.size(); ++i) {
            CharArrayBuffer fieldLine = dispositionNotificationFields.get(i);
            Field field = DispositionNotificationContentUtils.parseDispositionField(fieldLine);
            switch (field.getName().toLowerCase()) {
                case "reporting-ua": {
                    if (field.getElements().length < 1) {
                        throw new ParseException("Invalid 'Reporting-UA' field: UA name is missing");
                    }
                    reportingUA = field.getValue();
                    continue block22;
                }
                case "mdn-gateway": {
                    Field.Element[] elements = field.getElements();
                    if (elements.length < 2) {
                        throw new ParseException("Invalid 'MDN-Gateway' field: MTA name is missing");
                    }
                    mtaName = elements[1].getValue();
                    continue block22;
                }
                case "final-recipient": {
                    Field.Element[] elements = field.getElements();
                    if (elements.length < 2) {
                        throw new ParseException("Invalid 'Final-Recipient' field: recipient address is missing");
                    }
                    finalRecipient = elements[1].getValue();
                    continue block22;
                }
                case "original-message-id": {
                    originalMessageId = field.getValue();
                    continue block22;
                }
                case "disposition": {
                    Field.Element[] elements = field.getElements();
                    if (elements.length < 2) {
                        throw new ParseException("Invalid 'Disposition' field: " + field.getValue());
                    }
                    dispositionMode = DispositionMode.parseDispositionMode(elements[0].getValue());
                    if (dispositionMode == null) {
                        throw new ParseException("Invalid 'Disposition' field: invalid disposition mode '" + elements[0].getValue() + "'");
                    }
                    String dispositionTypeString = elements[1].getValue();
                    int slash = dispositionTypeString.indexOf(47);
                    if (slash == -1) {
                        dispositionType = AS2DispositionType.parseDispositionType(dispositionTypeString);
                        continue block22;
                    }
                    dispositionType = AS2DispositionType.parseDispositionType(dispositionTypeString.substring(0, slash));
                    dispositionModifier = AS2DispositionModifier.parseDispositionType(dispositionTypeString.substring(slash + 1));
                    continue block22;
                }
                case "failure": {
                    failures.add(field.getValue());
                    continue block22;
                }
                case "error": {
                    errors.add(field.getValue());
                    continue block22;
                }
                case "warning": {
                    warnings.add(field.getValue());
                    continue block22;
                }
                case "received-content-mic": {
                    Field.Element[] elements = field.getElements();
                    if (elements.length < 1) {
                        throw new ParseException("Invalid 'Received-content-MIC' field: MIC is missing");
                    }
                    Field.Element element = elements[0];
                    String[] parameters = element.getParameters();
                    if (parameters.length < 1) {
                        throw new ParseException("Invalid 'Received-content-MIC' field: digest algorithm ID is missing");
                    }
                    String digestAlgorithmId = parameters[0];
                    String encodedMessageDigest = element.getValue();
                    receivedContentMic = new MicUtils.ReceivedContentMic(digestAlgorithmId, encodedMessageDigest);
                    continue block22;
                }
                default: {
                    extensionFields.put(field.getName(), field.getValue());
                }
            }
        }
        return new AS2MessageDispositionNotificationEntity(reportingUA, mtaName, finalRecipient, originalMessageId, dispositionMode, dispositionType, dispositionModifier, failures.toArray(new String[failures.size()]), errors.toArray(new String[errors.size()]), warnings.toArray(new String[warnings.size()]), extensionFields, receivedContentMic);
    }

    public static Field parseDispositionField(CharArrayBuffer fieldLine) {
        int colon = fieldLine.indexOf(58);
        if (colon == -1) {
            throw new ParseException("Invalid field: " + fieldLine.toString());
        }
        String fieldName = fieldLine.substringTrimmed(0, colon);
        ParserCursor cursor = new ParserCursor(colon + 1, fieldLine.length());
        ArrayList<Field.Element> elements = new ArrayList<Field.Element>();
        while (!cursor.atEnd()) {
            Field.Element element = DispositionNotificationContentUtils.parseDispositionFieldElement(fieldLine, cursor);
            if (element.getValue() == null) continue;
            elements.add(element);
        }
        return new Field(fieldName, elements.toArray(new Field.Element[elements.size()]));
    }

    public static Field.Element parseDispositionFieldElement(CharArrayBuffer fieldLine, ParserCursor cursor) {
        String value = TOKEN_PARSER.parseToken(fieldLine, cursor, TOKEN_DELIMS);
        if (cursor.atEnd()) {
            return new Field.Element(value, null);
        }
        char delim = fieldLine.charAt(cursor.getPos());
        cursor.updatePos(cursor.getPos() + 1);
        if (delim == ';') {
            return new Field.Element(value, null);
        }
        ArrayList<String> parameters = new ArrayList<String>();
        while (!cursor.atEnd()) {
            String parameter = TOKEN_PARSER.parseToken(fieldLine, cursor, TOKEN_DELIMS);
            parameters.add(parameter);
            if (cursor.atEnd()) break;
            char ch = fieldLine.charAt(cursor.getPos());
            if (!cursor.atEnd()) {
                cursor.updatePos(cursor.getPos() + 1);
            }
            if (ch != ';') continue;
            break;
        }
        return new Field.Element(value, parameters.toArray(new String[parameters.size()]));
    }

    public static class Field {
        private String name;
        private Element[] elements;

        public Field(String name, Element[] elements) {
            this.name = Args.notNull(name, "name");
            this.elements = elements == null ? new Element[]{} : elements;
        }

        public Field(String name, String value) {
            this.name = Args.notNull(name, "name");
            this.elements = new Element[]{new Element(value, null)};
        }

        public String getName() {
            return this.name;
        }

        public Element[] getElements() {
            return this.elements;
        }

        public String getValue() {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.elements.length; ++i) {
                Element element = this.elements[i];
                if (i > 0) {
                    builder.append("; " + element);
                    continue;
                }
                builder.append(element);
            }
            return builder.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name + ": ");
            for (int i = 0; i < this.elements.length; ++i) {
                Element element = this.elements[i];
                if (i > 0) {
                    sb.append("; " + element);
                    continue;
                }
                sb.append(element);
            }
            return sb.toString();
        }

        public static class Element {
            private final String value;
            private final String[] parameters;

            public Element(String value, String[] parameters) {
                this.value = value;
                this.parameters = parameters == null ? new String[]{} : parameters;
            }

            public String getValue() {
                return this.value;
            }

            public String[] getParameters() {
                return this.parameters;
            }

            public String toString() {
                return this.value + (this.parameters.length > 0 ? ", " + String.join((CharSequence)",", this.parameters) : "");
            }
        }
    }
}

