/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource.loader;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.JarHolder;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.shaded.commons.io.FilenameUtils;
import org.apache.velocity.util.ExtProperties;

public class JarResourceLoader
extends ResourceLoader {
    private Map<String, String> entryDirectory = new HashMap<String, String>(559);
    private Map<String, JarHolder> jarfiles = new HashMap<String, JarHolder>(89);

    @Override
    public void init(ExtProperties configuration) {
        this.log.trace("JarResourceLoader: initialization starting.");
        List paths = configuration.getList("path");
        if (paths != null) {
            this.log.debug("JarResourceLoader # of paths: {}", (Object)paths.size());
            ListIterator<String> it = paths.listIterator();
            while (it.hasNext()) {
                String jar = StringUtils.trim((String)it.next());
                it.set(jar);
                this.loadJar(jar);
            }
        }
        this.log.trace("JarResourceLoader: initialization complete.");
    }

    private void loadJar(String path) {
        this.log.debug("JarResourceLoader: trying to load \"{}\"", (Object)path);
        if (path == null) {
            String msg = "JarResourceLoader: can not load JAR - JAR path is null";
            this.log.error(msg);
            throw new RuntimeException(msg);
        }
        if (!path.startsWith("jar:")) {
            String msg = "JarResourceLoader: JAR path must start with jar: -> see java.net.JarURLConnection for information";
            this.log.error(msg);
            throw new RuntimeException(msg);
        }
        if (!path.contains("!/")) {
            path = path + "!/";
        }
        this.closeJar(path);
        JarHolder temp = new JarHolder(this.rsvc, path, this.log);
        this.addEntries(temp.getEntries());
        this.jarfiles.put(temp.getUrlPath(), temp);
    }

    private void closeJar(String path) {
        if (this.jarfiles.containsKey(path)) {
            JarHolder theJar = this.jarfiles.get(path);
            theJar.close();
        }
    }

    private void addEntries(Map<String, String> entries) {
        this.entryDirectory.putAll(entries);
    }

    @Override
    public Reader getResourceReader(String source, String encoding) throws ResourceNotFoundException {
        String jarurl;
        Object result = null;
        if (StringUtils.isEmpty(source)) {
            throw new ResourceNotFoundException("Need to have a resource!");
        }
        String normalizedPath = FilenameUtils.normalize(source, true);
        if (normalizedPath == null || normalizedPath.length() == 0) {
            String msg = "JAR resource error: argument " + normalizedPath + " contains .. and may be trying to access content outside of template root.  Rejected.";
            this.log.error("JarResourceLoader: {}", (Object)msg);
            throw new ResourceNotFoundException(msg);
        }
        if (normalizedPath.startsWith("/")) {
            normalizedPath = normalizedPath.substring(1);
        }
        if (this.entryDirectory.containsKey(normalizedPath) && this.jarfiles.containsKey(jarurl = this.entryDirectory.get(normalizedPath))) {
            JarHolder holder = this.jarfiles.get(jarurl);
            InputStream rawStream = holder.getResource(normalizedPath);
            try {
                return this.buildReader(rawStream, encoding);
            }
            catch (Exception e) {
                if (rawStream != null) {
                    try {
                        rawStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                String msg = "JAR resource error: Exception while loading " + source;
                this.log.error(msg, (Throwable)e);
                throw new VelocityException(msg, e, this.rsvc.getLogContext().getStackTrace());
            }
        }
        throw new ResourceNotFoundException("JarResourceLoader Error: cannot find resource " + source);
    }

    @Override
    public boolean isSourceModified(Resource resource) {
        return true;
    }

    @Override
    public long getLastModified(Resource resource) {
        return 0L;
    }
}

