/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.actions;

import io.atlasmap.actions.ObjectFieldActions;
import io.atlasmap.v2.Contains;
import io.atlasmap.v2.Count;
import io.atlasmap.v2.Equals;
import io.atlasmap.v2.ItemAt;
import io.atlasmap.v2.Length;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ObjectFieldActionsTest {
    @Test
    public void testCount() {
        Assertions.assertEquals((Integer)0, (Integer)ObjectFieldActions.count(new Count(), new ArrayList<Object>()));
        Object[] array = new Object[]{false, "foo", 2};
        Assertions.assertEquals((Integer)3, (Integer)ObjectFieldActions.count(new Count(), Arrays.asList(array)));
    }

    @Test
    public void testContains() {
        Contains action = new Contains();
        Assertions.assertTrue((boolean)ObjectFieldActions.contains(action, null));
        Assertions.assertFalse((boolean)ObjectFieldActions.contains(action, Arrays.asList("")));
        Object[] array = new Object[]{false, "foo", 2};
        Object[] arrayWithNull = new Object[]{false, null, "foo", 2};
        Assertions.assertFalse((boolean)ObjectFieldActions.contains(action, Arrays.asList(array)));
        Assertions.assertTrue((boolean)ObjectFieldActions.contains(action, Arrays.asList(arrayWithNull)));
        action.setValue("foo");
        Assertions.assertFalse((boolean)ObjectFieldActions.contains(action, null));
        Assertions.assertFalse((boolean)ObjectFieldActions.contains(action, Arrays.asList("")));
        Assertions.assertFalse((boolean)ObjectFieldActions.contains(action, Arrays.asList("foobar")));
        Assertions.assertTrue((boolean)ObjectFieldActions.contains(action, Arrays.asList(array)));
    }

    @Test
    public void testContainsWithNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ObjectFieldActions.contains(null, Arrays.asList("")));
    }

    @Test
    public void testEquals() {
        Equals action = new Equals();
        Assertions.assertTrue((boolean)ObjectFieldActions.equals(action, null));
        action.setValue("6");
        Assertions.assertFalse((boolean)ObjectFieldActions.equals(action, 169));
        action.setValue("169");
        Assertions.assertTrue((boolean)ObjectFieldActions.equals(action, 169));
        action.setValue("ru");
        Assertions.assertFalse((boolean)ObjectFieldActions.equals(action, true));
        action.setValue("true");
        Assertions.assertTrue((boolean)ObjectFieldActions.equals(action, true));
        action.setValue("b");
        Assertions.assertFalse((boolean)ObjectFieldActions.equals(action, Character.valueOf('a')));
        action.setValue("a");
        Assertions.assertTrue((boolean)ObjectFieldActions.equals(action, Character.valueOf('a')));
    }

    @Test
    public void testEqualsWithNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ObjectFieldActions.equals(null, ""));
    }

    @Test
    public void testIsNull() {
        Assertions.assertTrue((boolean)ObjectFieldActions.isNull(null, null));
        Assertions.assertFalse((boolean)ObjectFieldActions.isNull(null, ""));
        Assertions.assertFalse((boolean)ObjectFieldActions.isNull(null, new Object[0]));
    }

    @Test
    public void testItemAt() {
        ItemAt action = new ItemAt();
        action.setIndex(0);
        Assertions.assertEquals((Object)"one", (Object)ObjectFieldActions.itemAt(action, Arrays.asList("one", "two")));
        action.setIndex(1);
        Assertions.assertEquals((Object)"two", (Object)ObjectFieldActions.itemAt(action, Arrays.asList("one", "two")));
    }

    @Test
    public void testItemAtOutOfBounds() {
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> {
            ItemAt action = new ItemAt();
            action.setIndex(2);
            ObjectFieldActions.itemAt(action, Arrays.asList("one", "two"));
        });
    }

    @Test
    public void testLength() {
        Assertions.assertEquals((Integer)-1, (Integer)ObjectFieldActions.length(new Length(), null));
        Assertions.assertEquals((Integer)0, (Integer)ObjectFieldActions.length(new Length(), ""));
        Assertions.assertEquals((Integer)5, (Integer)ObjectFieldActions.length(new Length(), " foo "));
        Assertions.assertEquals((Integer)4, (Integer)ObjectFieldActions.length(new Length(), true));
        Assertions.assertEquals((Integer)3, (Integer)ObjectFieldActions.length(new Length(), 169));
    }
}

