/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.actions;

import io.atlasmap.actions.StringComplexFieldActions;
import io.atlasmap.v2.Append;
import io.atlasmap.v2.Concatenate;
import io.atlasmap.v2.EndsWith;
import io.atlasmap.v2.Format;
import io.atlasmap.v2.GenerateUUID;
import io.atlasmap.v2.IndexOf;
import io.atlasmap.v2.LastIndexOf;
import io.atlasmap.v2.PadStringLeft;
import io.atlasmap.v2.PadStringRight;
import io.atlasmap.v2.Prepend;
import io.atlasmap.v2.ReplaceAll;
import io.atlasmap.v2.ReplaceFirst;
import io.atlasmap.v2.Split;
import io.atlasmap.v2.StartsWith;
import io.atlasmap.v2.SubString;
import io.atlasmap.v2.SubStringAfter;
import io.atlasmap.v2.SubStringBefore;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringComplexFieldActionsTest {
    @Test
    public void testAppend() {
        Append action = new Append();
        Assertions.assertEquals(null, (Object)StringComplexFieldActions.append(action, null));
        Assertions.assertEquals((Object)"foo", (Object)StringComplexFieldActions.append(action, "foo"));
        Assertions.assertEquals((Object)"1", (Object)StringComplexFieldActions.append(action, "1"));
        action.setString("");
        Assertions.assertEquals((Object)"", (Object)StringComplexFieldActions.append(action, null));
        Assertions.assertEquals((Object)"foo", (Object)StringComplexFieldActions.append(action, "foo"));
        action.setString("bar");
        Assertions.assertEquals((Object)"bar", (Object)StringComplexFieldActions.append(action, null));
        Assertions.assertEquals((Object)"foobar", (Object)StringComplexFieldActions.append(action, "foo"));
        Assertions.assertEquals((Object)"1bar", (Object)StringComplexFieldActions.append(action, "1"));
    }

    @Test
    public void testAppendNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.append(null, null));
    }

    @Test
    public void testConcatenate() {
        Concatenate action = new Concatenate();
        Assertions.assertEquals(null, (Object)StringComplexFieldActions.concatenate(action, null));
        Assertions.assertEquals((Object)"1true2.0", (Object)StringComplexFieldActions.concatenate(action, Arrays.asList("1", "true", "2.0")));
        Assertions.assertEquals((Object)"1true2.0", (Object)StringComplexFieldActions.concatenate(action, Arrays.asList("1", "true", "2.0")));
        action.setDelimiter("-");
        Assertions.assertEquals(null, (Object)StringComplexFieldActions.concatenate(action, null));
        Assertions.assertEquals((Object)"1-true-2.0", (Object)StringComplexFieldActions.concatenate(action, Arrays.asList("1", "true", "2.0")));
        Assertions.assertEquals((Object)"1-true-2.0", (Object)StringComplexFieldActions.concatenate(action, Arrays.asList("1", "true", "2.0")));
    }

    @Test
    public void testConcatenateNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.concatenate(null, null));
    }

    @Test
    public void testEndsWith() {
        EndsWith action = new EndsWith();
        action.setString("");
        Assertions.assertFalse((boolean)StringComplexFieldActions.endsWith(action, null));
        Assertions.assertTrue((boolean)StringComplexFieldActions.endsWith(action, ""));
        Assertions.assertTrue((boolean)StringComplexFieldActions.endsWith(action, "foo"));
        action.setString("bar");
        Assertions.assertFalse((boolean)StringComplexFieldActions.endsWith(action, null));
        Assertions.assertFalse((boolean)StringComplexFieldActions.endsWith(action, ""));
        Assertions.assertFalse((boolean)StringComplexFieldActions.endsWith(action, "foo"));
        Assertions.assertTrue((boolean)StringComplexFieldActions.endsWith(action, "foobar"));
        Assertions.assertFalse((boolean)StringComplexFieldActions.endsWith(action, "barfoo"));
    }

    @Test
    public void testEndsWithNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.endsWith(null, null));
    }

    @Test
    public void testEndsWithNullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.endsWith(new EndsWith(), null));
    }

    @Test
    public void testFormat() {
        Format action = new Format();
        action.setTemplate("foofoo");
        Assertions.assertEquals((Object)"foofoo", (Object)StringComplexFieldActions.format(action, null));
        Assertions.assertEquals((Object)"foofoo", (Object)StringComplexFieldActions.format(action, Arrays.asList("")));
        Assertions.assertEquals((Object)"foofoo", (Object)StringComplexFieldActions.format(action, Arrays.asList("bar")));
        action.setTemplate("foo%sfoo");
        Assertions.assertEquals((Object)"foonullfoo", (Object)StringComplexFieldActions.format(action, null));
        Assertions.assertEquals((Object)"foofoo", (Object)StringComplexFieldActions.format(action, Arrays.asList("")));
        Assertions.assertEquals((Object)"foobarfoo", (Object)StringComplexFieldActions.format(action, Arrays.asList("bar")));
        action.setTemplate("foo%1$sfoo%1$s");
        Assertions.assertEquals((Object)"foobarfoobar", (Object)StringComplexFieldActions.format(action, Arrays.asList("bar")));
    }

    @Test
    public void testFormatNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.format(null, null));
    }

    @Test
    public void testFormatNullTemplate() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.format(new Format(), null));
    }

    @Test
    public void testGenareteUUID() {
        this.validateGeneratedUUID(StringComplexFieldActions.genareteUUID(new GenerateUUID()));
    }

    @Test
    public void testIndexOf() {
        IndexOf action = new IndexOf();
        action.setString("");
        Assertions.assertEquals((Object)-1, (Object)StringComplexFieldActions.indexOf(action, null));
        Assertions.assertEquals((Object)0, (Object)StringComplexFieldActions.indexOf(action, ""));
        Assertions.assertEquals((Object)0, (Object)StringComplexFieldActions.indexOf(action, "foo"));
        action.setString("bar");
        Assertions.assertEquals((Object)-1, (Object)StringComplexFieldActions.indexOf(action, null));
        Assertions.assertEquals((Object)-1, (Object)StringComplexFieldActions.indexOf(action, ""));
        Assertions.assertEquals((Object)-1, (Object)StringComplexFieldActions.indexOf(action, "foo"));
        Assertions.assertEquals((Object)3, (Object)StringComplexFieldActions.indexOf(action, "foobar"));
        Assertions.assertEquals((Object)3, (Object)StringComplexFieldActions.indexOf(action, "foobarbar"));
    }

    @Test
    public void testIndexOfNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.indexOf(null, null));
    }

    @Test
    public void testIndexOfNullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.indexOf(new IndexOf(), null));
    }

    @Test
    public void testLastIndexOf() {
        LastIndexOf action = new LastIndexOf();
        action.setString("");
        Assertions.assertEquals((Object)-1, (Object)StringComplexFieldActions.lastIndexOf(action, null));
        Assertions.assertEquals((Object)0, (Object)StringComplexFieldActions.lastIndexOf(action, ""));
        Assertions.assertEquals((Object)3, (Object)StringComplexFieldActions.lastIndexOf(action, "foo"));
        action.setString("bar");
        Assertions.assertEquals((Object)-1, (Object)StringComplexFieldActions.lastIndexOf(action, null));
        Assertions.assertEquals((Object)-1, (Object)StringComplexFieldActions.lastIndexOf(action, ""));
        Assertions.assertEquals((Object)-1, (Object)StringComplexFieldActions.lastIndexOf(action, "foo"));
        Assertions.assertEquals((Object)3, (Object)StringComplexFieldActions.lastIndexOf(action, "foobar"));
        Assertions.assertEquals((Object)6, (Object)StringComplexFieldActions.lastIndexOf(action, "foobarbar"));
    }

    @Test
    public void testLastIndexOfNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.lastIndexOf(null, null));
    }

    @Test
    public void testLastIndexOfNullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.lastIndexOf(new LastIndexOf(), null));
    }

    @Test
    public void testPadStringLeft() {
        PadStringLeft incomplete;
        PadStringLeft padStringLeft = new PadStringLeft();
        padStringLeft.setPadCharacter("a");
        padStringLeft.setPadCount(3);
        Assertions.assertEquals((Object)"aaa", (Object)StringComplexFieldActions.padStringLeft(padStringLeft, null));
        Assertions.assertEquals((Object)"aaa", (Object)StringComplexFieldActions.padStringLeft(padStringLeft, ""));
        Assertions.assertEquals((Object)"aaaa", (Object)StringComplexFieldActions.padStringLeft(padStringLeft, "a"));
        Assertions.assertEquals((Object)"aaab", (Object)StringComplexFieldActions.padStringLeft(padStringLeft, "b"));
        try {
            StringComplexFieldActions.padStringLeft(null, "aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
        try {
            StringComplexFieldActions.padStringLeft(new PadStringLeft(), "aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
        try {
            incomplete = new PadStringLeft();
            incomplete.setPadCharacter("f");
            StringComplexFieldActions.padStringLeft(incomplete, "aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
        try {
            incomplete = new PadStringLeft();
            incomplete.setPadCount(3);
            StringComplexFieldActions.padStringLeft(incomplete, "aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
    }

    @Test
    public void testPadStringRight() {
        PadStringRight incomplete2;
        PadStringRight padStringRight = new PadStringRight();
        padStringRight.setPadCharacter("a");
        padStringRight.setPadCount(3);
        Assertions.assertEquals((Object)"aaa", (Object)StringComplexFieldActions.padStringRight(padStringRight, null));
        Assertions.assertEquals((Object)"aaa", (Object)StringComplexFieldActions.padStringRight(padStringRight, ""));
        Assertions.assertEquals((Object)"aaaa", (Object)StringComplexFieldActions.padStringRight(padStringRight, "a"));
        Assertions.assertEquals((Object)"baaa", (Object)StringComplexFieldActions.padStringRight(padStringRight, "b"));
        try {
            StringComplexFieldActions.padStringRight(null, "aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            StringComplexFieldActions.padStringRight(new PadStringRight(), "aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            incomplete2 = new PadStringRight();
            incomplete2.setPadCharacter("f");
            StringComplexFieldActions.padStringRight(incomplete2, "aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException incomplete2) {
            // empty catch block
        }
        try {
            incomplete2 = new PadStringRight();
            incomplete2.setPadCount(3);
            StringComplexFieldActions.padStringRight(incomplete2, "aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPrepend() {
        Prepend action = new Prepend();
        Assertions.assertEquals(null, (Object)StringComplexFieldActions.prepend(action, null));
        Assertions.assertEquals((Object)"foo", (Object)StringComplexFieldActions.prepend(action, "foo"));
        Assertions.assertEquals((Object)"1", (Object)StringComplexFieldActions.prepend(action, "1"));
        action.setString("");
        Assertions.assertEquals((Object)"", (Object)StringComplexFieldActions.prepend(action, null));
        Assertions.assertEquals((Object)"foo", (Object)StringComplexFieldActions.prepend(action, "foo"));
        action.setString("bar");
        Assertions.assertEquals((Object)"bar", (Object)StringComplexFieldActions.prepend(action, null));
        Assertions.assertEquals((Object)"barfoo", (Object)StringComplexFieldActions.prepend(action, "foo"));
        Assertions.assertEquals((Object)"bar1", (Object)StringComplexFieldActions.prepend(action, "1"));
    }

    @Test
    public void testPrependNullAction() {
        Assertions.assertThrows(NullPointerException.class, () -> StringComplexFieldActions.prepend(null, null));
    }

    @Test
    public void testReplaceFirst() {
        ReplaceFirst replaceFirst = new ReplaceFirst();
        replaceFirst.setMatch(" ");
        Assertions.assertNull((Object)StringComplexFieldActions.replaceFirst(replaceFirst, null));
        Assertions.assertEquals((Object)"", (Object)StringComplexFieldActions.replaceFirst(replaceFirst, ""));
        Assertions.assertEquals((Object)"test", (Object)StringComplexFieldActions.replaceFirst(replaceFirst, "test"));
        replaceFirst.setMatch("e");
        Assertions.assertEquals((Object)"tst", (Object)StringComplexFieldActions.replaceFirst(replaceFirst, "test"));
        replaceFirst.setMatch("t");
        replaceFirst.setNewString("h");
        Assertions.assertEquals((Object)"hest", (Object)StringComplexFieldActions.replaceFirst(replaceFirst, "test"));
        replaceFirst.setMatch("is");
        replaceFirst.setNewString("at");
        Assertions.assertEquals((Object)"That is a test", (Object)StringComplexFieldActions.replaceFirst(replaceFirst, "This is a test"));
    }

    @Test
    public void testReplaceFirstEmptyMatch() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ReplaceFirst replaceFirst = new ReplaceFirst();
            replaceFirst.setMatch("");
            StringComplexFieldActions.replaceFirst(replaceFirst, " ");
        });
    }

    @Test
    public void testReplaceFirstNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.replaceFirst(null, null));
    }

    @Test
    public void testReplaceFirstNullMatch() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ReplaceFirst replaceFirst = new ReplaceFirst();
            StringComplexFieldActions.replaceFirst(replaceFirst, " ");
        });
    }

    @Test
    public void testReplaceAll() {
        ReplaceAll replaceAll = new ReplaceAll();
        replaceAll.setMatch(" ");
        Assertions.assertNull((Object)StringComplexFieldActions.replaceAll(replaceAll, null));
        Assertions.assertEquals((Object)"", (Object)StringComplexFieldActions.replaceAll(replaceAll, ""));
        Assertions.assertEquals((Object)"test", (Object)StringComplexFieldActions.replaceAll(replaceAll, "test"));
        replaceAll.setMatch("e");
        Assertions.assertEquals((Object)"tst", (Object)StringComplexFieldActions.replaceAll(replaceAll, "test"));
        replaceAll.setMatch("t");
        replaceAll.setNewString("h");
        Assertions.assertEquals((Object)"hesh", (Object)StringComplexFieldActions.replaceAll(replaceAll, "test"));
        replaceAll.setMatch("is");
        replaceAll.setNewString("at");
        Assertions.assertEquals((Object)"That at a test", (Object)StringComplexFieldActions.replaceAll(replaceAll, "This is a test"));
    }

    @Test
    public void testReplaceAllEmptyMatch() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ReplaceAll replaceAll = new ReplaceAll();
            replaceAll.setMatch("");
            StringComplexFieldActions.replaceAll(replaceAll, " ");
        });
    }

    @Test
    public void testReplaceAllNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.replaceAll(null, null));
    }

    @Test
    public void testReplaceAllNullOldString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ReplaceAll replaceAll = new ReplaceAll();
            StringComplexFieldActions.replaceAll(replaceAll, " ");
        });
    }

    @Test
    public void testSplitNoDelimiter() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            Split action = new Split();
            StringComplexFieldActions.split(action, "foobar");
        });
    }

    @Test
    public void testSplit() {
        Split action = new Split();
        action.setDelimiter(",");
        Assertions.assertArrayEquals(null, (Object[])StringComplexFieldActions.split(action, null));
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])StringComplexFieldActions.split(action, "1,2,3"));
    }

    @Test
    public void testSplitEscape() {
        Split action = new Split();
        action.setDelimiter("\\");
        Assertions.assertArrayEquals(null, (Object[])StringComplexFieldActions.split(action, null));
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])StringComplexFieldActions.split(action, "1\\2\\3"));
        action.setDelimiter("|");
        Assertions.assertArrayEquals(null, (Object[])StringComplexFieldActions.split(action, null));
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])StringComplexFieldActions.split(action, "1|2|3"));
        action.setDelimiter(".");
        Assertions.assertArrayEquals(null, (Object[])StringComplexFieldActions.split(action, null));
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])StringComplexFieldActions.split(action, "1.2.3"));
        action.setDelimiter("$");
        Assertions.assertArrayEquals(null, (Object[])StringComplexFieldActions.split(action, null));
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])StringComplexFieldActions.split(action, "1$2$3"));
    }

    @Test
    public void testSplitCollapse() {
        Split action = new Split();
        action.setCollapseRepeatingDelimiters(true);
        action.setDelimiter("\\");
        Assertions.assertArrayEquals(null, (Object[])StringComplexFieldActions.split(action, null));
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])StringComplexFieldActions.split(action, "1\\2\\\\3"));
        action.setDelimiter("|");
        Assertions.assertArrayEquals(null, (Object[])StringComplexFieldActions.split(action, null));
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])StringComplexFieldActions.split(action, "1|2|||3"));
        action.setDelimiter(".");
        Assertions.assertArrayEquals(null, (Object[])StringComplexFieldActions.split(action, null));
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])StringComplexFieldActions.split(action, "1..2...3"));
        action.setDelimiter("$");
        Assertions.assertArrayEquals(null, (Object[])StringComplexFieldActions.split(action, null));
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])StringComplexFieldActions.split(action, "1$$$$2$$$$3"));
        action.setDelimiter(" ");
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "3"}, (Object[])StringComplexFieldActions.split(action, "1  2     3"));
    }

    @Test
    public void testStartsWith() {
        StartsWith action = new StartsWith();
        action.setString("");
        Assertions.assertFalse((boolean)StringComplexFieldActions.startsWith(action, null));
        Assertions.assertTrue((boolean)StringComplexFieldActions.startsWith(action, ""));
        Assertions.assertTrue((boolean)StringComplexFieldActions.startsWith(action, "foo"));
        action.setString("foo");
        Assertions.assertFalse((boolean)StringComplexFieldActions.startsWith(action, null));
        Assertions.assertFalse((boolean)StringComplexFieldActions.startsWith(action, ""));
        Assertions.assertTrue((boolean)StringComplexFieldActions.startsWith(action, "foo"));
        Assertions.assertTrue((boolean)StringComplexFieldActions.startsWith(action, "foobar"));
        Assertions.assertFalse((boolean)StringComplexFieldActions.startsWith(action, "barfoo"));
    }

    @Test
    public void testStartsWithNullAction() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.startsWith(null, null));
    }

    @Test
    public void testStartsWithNullString() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringComplexFieldActions.startsWith(new StartsWith(), null));
    }

    @Test
    public void testSubString() {
        SubString action = new SubString();
        action.setStartIndex(2);
        action.setEndIndex(4);
        Assertions.assertNull((Object)StringComplexFieldActions.subString(action, null));
        Assertions.assertEquals((Object)"", (Object)StringComplexFieldActions.subString(action, ""));
        try {
            StringComplexFieldActions.subString(null, "aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
    }

    @Test
    public void testSubStringAfter() {
        SubStringAfter err;
        SubStringAfter action = new SubStringAfter();
        action.setStartIndex(3);
        action.setEndIndex(null);
        action.setMatch("foo");
        Assertions.assertNull((Object)StringComplexFieldActions.subStringAfter(action, null));
        Assertions.assertEquals((Object)"", (Object)StringComplexFieldActions.subStringAfter(action, ""));
        Assertions.assertEquals((Object)"blah", (Object)StringComplexFieldActions.subStringAfter(action, "foobarblah"));
        Assertions.assertEquals((Object)"blahfoo", (Object)StringComplexFieldActions.subStringAfter(action, "foobarblahfoo"));
        Assertions.assertEquals((Object)"barblah", (Object)StringComplexFieldActions.subStringAfter(action, "barblah"));
        action.setEndIndex(7);
        Assertions.assertEquals((Object)"blah", (Object)StringComplexFieldActions.subStringAfter(action, "foobarblahfoo"));
        action.setEndIndex(3);
        Assertions.assertEquals((Object)"", (Object)StringComplexFieldActions.subStringAfter(action, "foobarblahfoo"));
        try {
            StringComplexFieldActions.subStringAfter(null, "aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
        try {
            err = new SubStringAfter();
            StringComplexFieldActions.subStringAfter(err, "aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
        try {
            err = new SubStringAfter();
            err.setEndIndex(5);
            err.setStartIndex(0);
            StringComplexFieldActions.subStringAfter(err, "aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
        try {
            err = new SubStringAfter();
            err.setEndIndex(0);
            err.setStartIndex(5);
            StringComplexFieldActions.subStringAfter(err, "aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
    }

    @Test
    public void testSubStringBefore() {
        SubStringBefore err;
        SubStringBefore action = new SubStringBefore();
        action.setStartIndex(3);
        action.setEndIndex(null);
        action.setMatch("blah");
        Assertions.assertNull((Object)StringComplexFieldActions.subStringBefore(action, null));
        Assertions.assertEquals((Object)"", (Object)StringComplexFieldActions.subStringBefore(action, ""));
        Assertions.assertEquals((Object)"bar", (Object)StringComplexFieldActions.subStringBefore(action, "foobarblah"));
        Assertions.assertEquals((Object)"foobar", (Object)StringComplexFieldActions.subStringBefore(action, "foofoobarblahfoo"));
        Assertions.assertEquals((Object)"", (Object)StringComplexFieldActions.subStringBefore(action, "barblah"));
        action.setEndIndex(5);
        Assertions.assertEquals((Object)"ba", (Object)StringComplexFieldActions.subStringBefore(action, "foobarblah"));
        action.setEndIndex(3);
        Assertions.assertEquals((Object)"", (Object)StringComplexFieldActions.subStringBefore(action, "foobarblah"));
        try {
            StringComplexFieldActions.subStringBefore(null, "aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
        try {
            err = new SubStringBefore();
            StringComplexFieldActions.subStringBefore(err, "aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
        try {
            err = new SubStringBefore();
            err.setEndIndex(5);
            err.setStartIndex(0);
            StringComplexFieldActions.subStringBefore(err, "aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
        try {
            err = new SubStringBefore();
            err.setEndIndex(0);
            err.setStartIndex(5);
            StringComplexFieldActions.subStringBefore(err, "aa");
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)true);
        }
    }

    protected void validateCurrentDate(String dateValue) {
        Assertions.assertNotNull((Object)dateValue);
        Assertions.assertTrue((dateValue.length() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Pattern.compile("20([1-9][0-9])-(0[0-9]|1[0-2])-(0[0-9]|1[0-9]|2[0-9]|3[0-1])").matcher(dateValue).matches());
    }

    protected void validateCurrentDateTime(String dateTimeValue) {
        Assertions.assertNotNull((Object)dateTimeValue);
        Assertions.assertTrue((dateTimeValue.length() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Pattern.compile("20([1-9][0-9])-(0[0-9]|1[0-2])-(0[0-9]|1[0-9]|2[0-9]|3[0-1])T([01]?[0-9]|2[0-3]):[0-5][0-9]Z").matcher(dateTimeValue).matches());
    }

    protected void validateCurrentTime(String timeValue) {
        Assertions.assertNotNull((Object)timeValue);
        Assertions.assertTrue((timeValue.length() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Pattern.compile("([01]?[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]").matcher(timeValue).matches());
    }

    protected void validateGeneratedUUID(String uuid) {
        Assertions.assertNotNull((Object)uuid);
        Assertions.assertTrue((uuid.length() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}").matcher(uuid).matches());
    }
}

