/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.actions;

import io.atlasmap.actions.StringSimpleFieldActions;
import io.atlasmap.v2.Capitalize;
import io.atlasmap.v2.Lowercase;
import io.atlasmap.v2.LowercaseChar;
import io.atlasmap.v2.SeparateByDash;
import io.atlasmap.v2.SeparateByUnderscore;
import io.atlasmap.v2.Trim;
import io.atlasmap.v2.TrimLeft;
import io.atlasmap.v2.TrimRight;
import io.atlasmap.v2.Uppercase;
import io.atlasmap.v2.UppercaseChar;
import java.util.regex.Pattern;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringSimpleFieldActionsTest {
    @Test
    public void testCapitalize() {
        Assertions.assertNull((Object)StringSimpleFieldActions.capitalize(new Capitalize(), null));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.capitalize(new Capitalize(), ""));
        Assertions.assertEquals((Object)" foo ", (Object)StringSimpleFieldActions.capitalize(new Capitalize(), " foo "));
        Assertions.assertEquals((Object)"   Foo", (Object)StringSimpleFieldActions.capitalize(new Capitalize(), "   Foo"));
        Assertions.assertEquals((Object)"FOo   ", (Object)StringSimpleFieldActions.capitalize(new Capitalize(), "fOo   "));
        Assertions.assertEquals((Object)"    foO   ", (Object)StringSimpleFieldActions.capitalize(new Capitalize(), "    foO   "));
        Assertions.assertEquals((Object)"\t\n   FOO", (Object)StringSimpleFieldActions.capitalize(new Capitalize(), "\t\n   FOO"));
        Assertions.assertEquals((Object)"\t\n   FOO\f\r", (Object)StringSimpleFieldActions.capitalize(new Capitalize(), "\t\n   FOO\f\r"));
    }

    @Test
    public void testFileExtension() {
        Assertions.assertNull((Object)StringSimpleFieldActions.fileExtension(null, null));
        Assertions.assertNull((Object)StringSimpleFieldActions.fileExtension(null, ""));
        Assertions.assertNull((Object)StringSimpleFieldActions.fileExtension(null, "foo"));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.fileExtension(null, "."));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.fileExtension(null, "foo."));
        Assertions.assertEquals((Object)"bar", (Object)StringSimpleFieldActions.fileExtension(null, "foo.bar"));
        Assertions.assertEquals((Object)"bar", (Object)StringSimpleFieldActions.fileExtension(null, "foo.foo.bar"));
    }

    @Test
    public void testLowerCase() {
        Assertions.assertNull((Object)StringSimpleFieldActions.lowercase(new Lowercase(), null));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.lowercase(new Lowercase(), ""));
        Assertions.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.lowercase(new Lowercase(), "foo"));
        Assertions.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.lowercase(new Lowercase(), "Foo"));
        Assertions.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.lowercase(new Lowercase(), "fOo"));
        Assertions.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.lowercase(new Lowercase(), "foO"));
        Assertions.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.lowercase(new Lowercase(), "FOO"));
        Assertions.assertEquals((Object)"foo bar", (Object)StringSimpleFieldActions.lowercase(new Lowercase(), "FOO BAR"));
    }

    @Test
    public void testLowerCaseChar() {
        Assertions.assertNull((Object)StringSimpleFieldActions.lowercaseChar(new LowercaseChar(), null));
        Assertions.assertEquals((char)'\u0000', (char)StringSimpleFieldActions.lowercaseChar(new LowercaseChar(), Character.valueOf('\u0000')).charValue());
        Assertions.assertEquals((char)'f', (char)StringSimpleFieldActions.lowercaseChar(new LowercaseChar(), Character.valueOf('f')).charValue());
        Assertions.assertEquals((char)'f', (char)StringSimpleFieldActions.lowercaseChar(new LowercaseChar(), Character.valueOf('F')).charValue());
    }

    @Test
    public void testNormalize() {
        Assertions.assertNull((Object)StringSimpleFieldActions.normalize(null, null));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.normalize(null, ""));
        Assertions.assertEquals((Object)"foo bar", (Object)StringSimpleFieldActions.normalize(null, " foo bar "));
        Assertions.assertEquals((Object)"Foo Bar", (Object)StringSimpleFieldActions.normalize(null, "   Foo Bar   "));
        Assertions.assertEquals((Object)"fOo bar", (Object)StringSimpleFieldActions.normalize(null, "fOo   bar"));
        Assertions.assertEquals((Object)"foO bar", (Object)StringSimpleFieldActions.normalize(null, "    foO   bar   "));
        Assertions.assertEquals((Object)"FOO BAR", (Object)StringSimpleFieldActions.normalize(null, "\t\n   FOO \f\t BAR "));
        Assertions.assertEquals((Object)"FOO BAR", (Object)StringSimpleFieldActions.normalize(null, "\t\n   FOO \f\r BAR\f\r"));
    }

    @Test
    public void testRemoveFileExtension() {
        Assertions.assertNull((Object)StringSimpleFieldActions.removeFileExtension(null, null));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.removeFileExtension(null, ""));
        Assertions.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.removeFileExtension(null, "foo"));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.removeFileExtension(null, "."));
        Assertions.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.removeFileExtension(null, "foo."));
        Assertions.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.removeFileExtension(null, "foo.bar"));
        Assertions.assertEquals((Object)"foo.foo", (Object)StringSimpleFieldActions.removeFileExtension(null, "foo.foo.bar"));
    }

    @Test
    public void testSeparateByDash() {
        Assertions.assertNull((Object)StringSimpleFieldActions.separateByDash(new SeparateByDash(), null));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.separateByDash(new SeparateByDash(), ""));
        Assertions.assertEquals((Object)"-", (Object)StringSimpleFieldActions.separateByDash(new SeparateByDash(), "-"));
        Assertions.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.separateByDash(new SeparateByDash(), "foo"));
        Assertions.assertEquals((Object)"foo-bar", (Object)StringSimpleFieldActions.separateByDash(new SeparateByDash(), "foo bar"));
        Assertions.assertEquals((Object)"foo-bar", (Object)StringSimpleFieldActions.separateByDash(new SeparateByDash(), "foo+bar"));
        Assertions.assertEquals((Object)"foo-bar", (Object)StringSimpleFieldActions.separateByDash(new SeparateByDash(), "foo=bar"));
        Assertions.assertEquals((Object)"foo-bar", (Object)StringSimpleFieldActions.separateByDash(new SeparateByDash(), "foo:bar"));
        Assertions.assertEquals((Object)"f-o-o-b-a-r", (Object)StringSimpleFieldActions.separateByDash(new SeparateByDash(), "f:o:o:b:a:r"));
    }

    @Test
    public void testSeparateByUnderscore() {
        Assertions.assertNull((Object)StringSimpleFieldActions.separateByUnderscore(new SeparateByUnderscore(), null));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.separateByUnderscore(new SeparateByUnderscore(), ""));
        Assertions.assertEquals((Object)"_", (Object)StringSimpleFieldActions.separateByUnderscore(new SeparateByUnderscore(), "-"));
        Assertions.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.separateByUnderscore(new SeparateByUnderscore(), "foo"));
        Assertions.assertEquals((Object)"foo_bar", (Object)StringSimpleFieldActions.separateByUnderscore(new SeparateByUnderscore(), "foo bar"));
        Assertions.assertEquals((Object)"foo_bar", (Object)StringSimpleFieldActions.separateByUnderscore(new SeparateByUnderscore(), "foo+bar"));
        Assertions.assertEquals((Object)"foo_bar", (Object)StringSimpleFieldActions.separateByUnderscore(new SeparateByUnderscore(), "foo=bar"));
        Assertions.assertEquals((Object)"foo_bar", (Object)StringSimpleFieldActions.separateByUnderscore(new SeparateByUnderscore(), "foo:bar"));
        Assertions.assertEquals((Object)"f_o_o_b_a_r", (Object)StringSimpleFieldActions.separateByUnderscore(new SeparateByUnderscore(), "f:o:o:b:a:r"));
    }

    @Test
    public void testSeparatorRegex() {
        Pattern pattern = Pattern.compile("[\\s+\\:\\_\\+\\=\\-]+");
        Assertions.assertFalse((boolean)pattern.matcher("foo").find());
        Assertions.assertFalse((boolean)pattern.matcher("").find());
        Assertions.assertTrue((boolean)pattern.matcher("f o").find());
        Assertions.assertTrue((boolean)pattern.matcher("f+o").find());
        Assertions.assertTrue((boolean)pattern.matcher("f=o").find());
        Assertions.assertTrue((boolean)pattern.matcher("f_o").find());
        Assertions.assertTrue((boolean)pattern.matcher("f:o").find());
        Assertions.assertTrue((boolean)pattern.matcher("f:o:o").find());
        Assertions.assertTrue((boolean)pattern.matcher("f  o").find());
    }

    @Test
    public void testTrim() {
        Assertions.assertNull((Object)StringSimpleFieldActions.trim(new Trim(), null));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.trim(new Trim(), ""));
        Assertions.assertEquals((Object)"foo", (Object)StringSimpleFieldActions.trim(new Trim(), " foo "));
        Assertions.assertEquals((Object)"Foo", (Object)StringSimpleFieldActions.trim(new Trim(), "   Foo"));
        Assertions.assertEquals((Object)"fOo", (Object)StringSimpleFieldActions.trim(new Trim(), "fOo   "));
        Assertions.assertEquals((Object)"foO", (Object)StringSimpleFieldActions.trim(new Trim(), "    foO   "));
        Assertions.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.trim(new Trim(), "\t\n   FOO"));
        Assertions.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.trim(new Trim(), "\t\n   FOO\f\r"));
    }

    @Test
    public void testTrimLeft() {
        Assertions.assertNull((Object)StringSimpleFieldActions.trimLeft(new TrimLeft(), null));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.trimLeft(new TrimLeft(), ""));
        Assertions.assertEquals((Object)"foo ", (Object)StringSimpleFieldActions.trimLeft(new TrimLeft(), " foo "));
        Assertions.assertEquals((Object)"Foo", (Object)StringSimpleFieldActions.trimLeft(new TrimLeft(), "   Foo"));
        Assertions.assertEquals((Object)"fOo   ", (Object)StringSimpleFieldActions.trimLeft(new TrimLeft(), "fOo   "));
        Assertions.assertEquals((Object)"foO   ", (Object)StringSimpleFieldActions.trimLeft(new TrimLeft(), "    foO   "));
        Assertions.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.trimLeft(new TrimLeft(), "\t\n   FOO"));
        Assertions.assertEquals((Object)"FOO\f\r", (Object)StringSimpleFieldActions.trimLeft(new TrimLeft(), "\t\n   FOO\f\r"));
    }

    @Test
    public void testTrimRight() {
        Assertions.assertNull((Object)StringSimpleFieldActions.trimRight(new TrimRight(), null));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.trimRight(new TrimRight(), ""));
        Assertions.assertEquals((Object)" foo", (Object)StringSimpleFieldActions.trimRight(new TrimRight(), " foo "));
        Assertions.assertEquals((Object)"   Foo", (Object)StringSimpleFieldActions.trimRight(new TrimRight(), "   Foo"));
        Assertions.assertEquals((Object)"fOo", (Object)StringSimpleFieldActions.trimRight(new TrimRight(), "fOo   "));
        Assertions.assertEquals((Object)"    foO", (Object)StringSimpleFieldActions.trimRight(new TrimRight(), "    foO   "));
        Assertions.assertEquals((Object)"\t\n   FOO", (Object)StringSimpleFieldActions.trimRight(new TrimRight(), "\t\n   FOO"));
        Assertions.assertEquals((Object)"\t\n   FOO", (Object)StringSimpleFieldActions.trimRight(new TrimRight(), "\t\n   FOO\f\r"));
    }

    @Test
    public void testUpperCase() {
        Assertions.assertNull((Object)StringSimpleFieldActions.uppercase(new Uppercase(), null));
        Assertions.assertEquals((Object)"", (Object)StringSimpleFieldActions.uppercase(new Uppercase(), ""));
        Assertions.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.uppercase(new Uppercase(), "foo"));
        Assertions.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.uppercase(new Uppercase(), "Foo"));
        Assertions.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.uppercase(new Uppercase(), "fOo"));
        Assertions.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.uppercase(new Uppercase(), "foO"));
        Assertions.assertEquals((Object)"FOO", (Object)StringSimpleFieldActions.uppercase(new Uppercase(), "FOO"));
        Assertions.assertEquals((Object)"FOO BAR", (Object)StringSimpleFieldActions.uppercase(new Uppercase(), "foo bar"));
    }

    @Test
    public void testUpperCaseChar() {
        Assertions.assertNull((Object)StringSimpleFieldActions.uppercaseChar(new UppercaseChar(), null));
        Assertions.assertEquals((char)'\u0000', (char)StringSimpleFieldActions.uppercaseChar(new UppercaseChar(), Character.valueOf('\u0000')).charValue());
        Assertions.assertEquals((char)'F', (char)StringSimpleFieldActions.uppercaseChar(new UppercaseChar(), Character.valueOf('f')).charValue());
        Assertions.assertEquals((char)'F', (char)StringSimpleFieldActions.uppercaseChar(new UppercaseChar(), Character.valueOf('F')).charValue());
    }
}

