/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.converters.BooleanConverter;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.v2.FieldType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BooleanConverterTest {
    private BooleanConverter converter = new BooleanConverter();

    @Test
    public void convertToBoolean() {
        Boolean t = Boolean.TRUE;
        Boolean f = Boolean.FALSE;
        Boolean t2 = this.converter.toBoolean(t, null, null);
        Boolean f2 = this.converter.toBoolean(f, null, null);
        Assertions.assertNotNull((Object)t2);
        Assertions.assertEquals((Object)t2, (Object)t);
        Assertions.assertTrue((boolean)t2);
        Assertions.assertNotNull((Object)f2);
        Assertions.assertEquals((Object)f2, (Object)f);
        Assertions.assertFalse((boolean)f2);
    }

    @Test
    public void convertToBooleanNull() {
        Boolean t = null;
        Boolean t2 = this.converter.toBoolean(t, null, null);
        Assertions.assertNull((Object)t2);
    }

    @Test
    public void convertToByte() {
        Byte trueValue = 1;
        Assertions.assertEquals((Byte)trueValue, (Byte)this.converter.toByte(Boolean.TRUE));
        Byte falseValue = 0;
        Assertions.assertEquals((Byte)falseValue, (Byte)this.converter.toByte(Boolean.FALSE));
    }

    @Test
    public void convertToByteNull() {
        Assertions.assertNull((Object)this.converter.toByte(null));
    }

    @Test
    public void convertToCharacter() {
        Boolean t = Boolean.TRUE;
        Boolean f = Boolean.FALSE;
        Character c = this.converter.toCharacter(t);
        Assertions.assertNotNull((Object)c);
        Assertions.assertEquals((int)1, (int)c.charValue());
        c = this.converter.toCharacter(f);
        Assertions.assertNotNull((Object)c);
        Assertions.assertEquals((int)0, (int)c.charValue());
    }

    @Test
    public void convertToCharacterNull() {
        Boolean t = null;
        Character c = this.converter.toCharacter(t);
        Assertions.assertNull((Object)c);
    }

    @Test
    public void convertToDouble() {
        Boolean t = Boolean.TRUE;
        Boolean f = Boolean.FALSE;
        Double d = this.converter.toDouble(t);
        Assertions.assertNotNull((Object)d);
        Assertions.assertEquals((double)1.0, (double)d, (double)0.0);
        d = this.converter.toDouble(f);
        Assertions.assertNotNull((Object)d);
        Assertions.assertEquals((double)0.0, (double)d, (double)0.0);
    }

    @Test
    public void convertToDoubleNull() {
        Boolean t = null;
        Double d = this.converter.toDouble(t);
        Assertions.assertNull((Object)d);
    }

    @Test
    public void convertToFloat() {
        Boolean t = Boolean.TRUE;
        Boolean f = Boolean.FALSE;
        Float aFloat = this.converter.toFloat(t);
        Assertions.assertNotNull((Object)aFloat);
        Assertions.assertEquals((float)1.0f, (float)aFloat.floatValue(), (float)0.0f);
        aFloat = this.converter.toFloat(f);
        Assertions.assertNotNull((Object)aFloat);
        Assertions.assertEquals((float)0.0f, (float)aFloat.floatValue(), (float)0.0f);
    }

    @Test
    public void convertToFloatNull() {
        Boolean t = null;
        Float f = this.converter.toFloat(t);
        Assertions.assertNull((Object)f);
    }

    @Test
    public void convertToInteger() {
        Boolean t = Boolean.TRUE;
        Boolean f = Boolean.FALSE;
        Integer i = this.converter.toInteger(t);
        Assertions.assertNotNull((Object)i);
        Assertions.assertEquals((int)1, (int)i);
        i = this.converter.toInteger(f);
        Assertions.assertNotNull((Object)i);
        Assertions.assertEquals((int)0, (int)i);
    }

    @Test
    public void convertToIntegerNull() {
        Boolean t = null;
        Integer i = this.converter.toInteger(t);
        Assertions.assertNull((Object)i);
    }

    @Test
    public void convertToLong() {
        Boolean t = Boolean.TRUE;
        Boolean f = Boolean.FALSE;
        Long l = this.converter.toLong(t);
        Assertions.assertNotNull((Object)l);
        Assertions.assertEquals((long)1L, (long)l);
        l = this.converter.toLong(f);
        Assertions.assertNotNull((Object)l);
        Assertions.assertEquals((long)0L, (long)l);
    }

    @Test
    public void convertToLongNull() {
        Boolean t = null;
        Long l = this.converter.toLong(t);
        Assertions.assertNull((Object)l);
    }

    @Test
    public void convertToShort() {
        Boolean t = Boolean.TRUE;
        Boolean f = Boolean.FALSE;
        Short s = this.converter.toShort(t);
        Assertions.assertNotNull((Object)s);
        Assertions.assertEquals((int)1, (int)s.shortValue());
        s = this.converter.toShort(f);
        Assertions.assertNotNull((Object)s);
        Assertions.assertEquals((int)0, (int)s.shortValue());
    }

    @Test
    public void convertToShortNull() {
        Boolean t = null;
        Short s = this.converter.toShort(t);
        Assertions.assertNull((Object)s);
    }

    @Test
    public void convertToString() {
        Boolean t = Boolean.TRUE;
        Boolean f = Boolean.FALSE;
        String s = this.converter.toString(t, null, null);
        Assertions.assertNotNull((Object)s);
        Assertions.assertTrue((boolean)"true".equals(s));
        s = this.converter.toString(f, null, null);
        Assertions.assertNotNull((Object)s);
        Assertions.assertTrue((boolean)"false".equals(s));
    }

    @Test
    public void convertToStringNull() {
        Boolean t = null;
        String s = this.converter.toString(t, null, null);
        Assertions.assertNull((Object)s);
    }

    @Test
    public void checkAnnotations() throws Exception {
        Method[] methods;
        Class<BooleanConverter> aClass = BooleanConverter.class;
        for (Method method : methods = aClass.getMethods()) {
            if (method.isSynthetic() || !method.getName().startsWith("convert")) continue;
            Annotation[] annotations = method.getDeclaredAnnotations();
            Assertions.assertNotNull((Object)annotations);
            Assertions.assertTrue((annotations.length > 0 ? 1 : 0) != 0);
            for (Annotation annotation2 : annotations) {
                Assertions.assertTrue((boolean)AtlasConversionInfo.class.isAssignableFrom(annotation2.annotationType()));
                AtlasConversionInfo atlasConversionInfo = (AtlasConversionInfo)annotation2;
                Assertions.assertNotNull((Object)((Object)atlasConversionInfo.sourceType()));
                Assertions.assertTrue((atlasConversionInfo.sourceType().compareTo(FieldType.BOOLEAN) == 0 ? 1 : 0) != 0);
                Assertions.assertNotNull((Object)((Object)atlasConversionInfo.targetType()));
                for (AtlasConversionConcern atlasConversionConcern : atlasConversionInfo.concerns()) {
                    Assertions.assertNotNull((Object)atlasConversionConcern.getMessage(atlasConversionInfo));
                    Assertions.assertNotNull((Object)atlasConversionConcern.value());
                }
            }
        }
    }
}

