/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.converters.CharacterConverter;
import io.atlasmap.spi.AtlasConversionConcern;
import io.atlasmap.spi.AtlasConversionInfo;
import io.atlasmap.v2.FieldType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CharacterConverterTest {
    private CharacterConverter converter = new CharacterConverter();

    @Test
    public void convertToBoolean() {
        Character c = Character.valueOf(Character.forDigit(1, 10));
        Boolean t = this.converter.toBoolean(c, null, null);
        Assertions.assertNotNull((Object)t);
        Assertions.assertTrue((boolean)t);
        c = Character.valueOf("T".charAt(0));
        Boolean t2 = this.converter.toBoolean(c, null, null);
        Assertions.assertNotNull((Object)t2);
        Assertions.assertTrue((boolean)t2);
        c = Character.valueOf("t".charAt(0));
        Boolean t3 = this.converter.toBoolean(c, null, null);
        Assertions.assertNotNull((Object)t3);
        Assertions.assertTrue((boolean)t3);
        c = Character.valueOf(Character.forDigit(0, 10));
        Boolean f = this.converter.toBoolean(c, null, null);
        Assertions.assertNotNull((Object)f);
        Assertions.assertFalse((boolean)f);
        c = Character.valueOf("F".charAt(0));
        Boolean f2 = this.converter.toBoolean(c, null, null);
        Assertions.assertNotNull((Object)f2);
        Assertions.assertFalse((boolean)f2);
        c = Character.valueOf("f".charAt(0));
        Boolean f3 = this.converter.toBoolean(c, null, null);
        Assertions.assertNotNull((Object)f3);
        Assertions.assertFalse((boolean)f3);
    }

    @Test
    public void convertToBooleanInvalid() {
        Character c = null;
        this.converter.toBoolean(c, null, null);
        Assertions.assertNull(c);
    }

    @Test
    public void convertToByte() throws Exception {
        byte value = 99;
        Assertions.assertEquals((byte)value, (byte)this.converter.toByte(Character.valueOf('c')));
    }

    @Test
    public void convertToByteOutOfRange() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            byte value = 99;
            Assertions.assertEquals((byte)value, (byte)this.converter.toByte(Character.valueOf('\ud840')));
        });
    }

    @Test
    public void convertToByteNull() throws Exception {
        Assertions.assertNull((Object)this.converter.toByte(null));
    }

    @Test
    public void convertToCharacter() {
        Character c = Character.valueOf('\u0000');
        Character c2 = this.converter.toCharacter(c);
        Assertions.assertNotNull((Object)c2);
        Assertions.assertNotSame((Object)c, (Object)c2);
        Assertions.assertEquals((Character)c, (Character)c2);
    }

    @Test
    public void convertToCharacterNull() {
        Character c = null;
        Character c2 = this.converter.toCharacter(c);
        Assertions.assertNull((Object)c2);
    }

    @Test
    public void convertToDouble() {
        Character c = Character.valueOf(Character.forDigit(0, 10));
        Double d = this.converter.toDouble(c);
        Assertions.assertNotNull((Object)d);
        Assertions.assertEquals((double)48.0, (double)d, (double)0.0);
        c = Character.valueOf('\uffff');
        d = this.converter.toDouble(c);
        Assertions.assertNotNull((Object)d);
        Assertions.assertEquals((double)65535.0, (double)d, (double)0.0);
    }

    @Test
    public void convertToDoubleNull() {
        Character c = null;
        Double d = this.converter.toDouble(c);
        Assertions.assertNull((Object)d);
    }

    @Test
    public void convertToFloat() {
        Character c = Character.valueOf(Character.forDigit(0, 10));
        Float f = this.converter.toFloat(c);
        Assertions.assertNotNull((Object)f);
        Assertions.assertEquals((double)48.0, (double)f.floatValue(), (double)0.0);
        c = Character.valueOf('\uffff');
        f = this.converter.toFloat(c);
        Assertions.assertNotNull((Object)f);
        Assertions.assertEquals((double)65535.0, (double)f.floatValue(), (double)0.0);
    }

    @Test
    public void convertToFloatNull() {
        Character c = null;
        Float f = this.converter.toFloat(c);
        Assertions.assertNull((Object)f);
    }

    @Test
    public void convertToInteger() {
        Character c = Character.valueOf(Character.forDigit(0, 10));
        Integer i = this.converter.toInteger(c);
        Assertions.assertNotNull((Object)i);
        Assertions.assertEquals((double)48.0, (double)i.intValue(), (double)0.0);
        c = Character.valueOf('\uffff');
        i = this.converter.toInteger(c);
        Assertions.assertNotNull((Object)i);
        Assertions.assertEquals((double)65535.0, (double)i.intValue(), (double)0.0);
    }

    @Test
    public void convertToIntegerNull() {
        Character c = null;
        Integer i = this.converter.toInteger(c);
        Assertions.assertNull((Object)i);
    }

    @Test
    public void convertToLong() {
        Character c = Character.valueOf(Character.forDigit(0, 10));
        Long l = this.converter.toLong(c);
        Assertions.assertNotNull((Object)l);
        Assertions.assertEquals((double)48.0, (double)l.longValue(), (double)0.0);
        c = Character.valueOf('\uffff');
        l = this.converter.toLong(c);
        Assertions.assertNotNull((Object)l);
        Assertions.assertEquals((double)65535.0, (double)l.longValue(), (double)0.0);
    }

    @Test
    public void convertToLongNull() {
        Long l = this.converter.toLong(null);
        Assertions.assertNull((Object)l);
    }

    @Test
    public void convertToShort() throws Exception {
        Character c = Character.valueOf(Character.forDigit(0, 10));
        Short s = this.converter.toShort(c);
        Assertions.assertNotNull((Object)s);
        Assertions.assertEquals((double)48.0, (double)s.shortValue(), (double)0.0);
    }

    @Test
    public void convertToShortNull() throws Exception {
        Character c = null;
        Short s = this.converter.toShort(c);
        Assertions.assertNull((Object)s);
    }

    @Test
    public void convertToShortException() throws Exception {
        Assertions.assertThrows(AtlasConversionException.class, () -> {
            Character c = Character.valueOf('\uffff');
            this.converter.toShort(c);
        });
    }

    @Test
    public void convertToString() {
        Character c = Character.valueOf(Character.forDigit(0, 10));
        String s = this.converter.toString(c, null, null);
        Assertions.assertNotNull((Object)s);
        Assertions.assertEquals((Object)"0", (Object)s);
    }

    @Test
    public void convertToStringNull() {
        Character c = null;
        String s = this.converter.toString(c, null, null);
        Assertions.assertNull((Object)s);
    }

    @Test
    public void checkAnnotations() throws Exception {
        Method[] methods;
        Class<CharacterConverter> aClass = CharacterConverter.class;
        for (Method method : methods = aClass.getMethods()) {
            if (method.isSynthetic() || !method.getName().startsWith("convert")) continue;
            Annotation[] annotations = method.getDeclaredAnnotations();
            Assertions.assertNotNull((Object)annotations);
            Assertions.assertTrue((annotations.length > 0 ? 1 : 0) != 0);
            for (Annotation annotation2 : annotations) {
                Assertions.assertTrue((boolean)AtlasConversionInfo.class.isAssignableFrom(annotation2.annotationType()));
                AtlasConversionInfo atlasConversionInfo = (AtlasConversionInfo)annotation2;
                Assertions.assertNotNull((Object)((Object)atlasConversionInfo.sourceType()));
                Assertions.assertTrue((atlasConversionInfo.sourceType().compareTo(FieldType.CHAR) == 0 ? 1 : 0) != 0);
                Assertions.assertNotNull((Object)((Object)atlasConversionInfo.targetType()));
                for (AtlasConversionConcern atlasConversionConcern : atlasConversionInfo.concerns()) {
                    Assertions.assertNotNull((Object)atlasConversionConcern.getMessage(atlasConversionInfo));
                    Assertions.assertNotNull((Object)atlasConversionConcern.value());
                }
            }
        }
    }
}

