/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.converters;

import io.atlasmap.converters.DateConverter;
import io.atlasmap.converters.DateTimeHelper;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DateConverterTest {
    private DateConverter dateConverter = new DateConverter();

    @Test
    public void convertToZonedDateTime() {
        ZonedDateTime zonedDateTime = DateTimeHelper.toZonedDateTime(new Date(), null);
        Assertions.assertNotNull((Object)zonedDateTime);
        Assertions.assertTrue((boolean)(zonedDateTime instanceof ZonedDateTime));
        Assertions.assertTrue((boolean)zonedDateTime.getZone().getId().equals(ZoneId.systemDefault().getId()));
    }

    @Test
    public void convertToZonedDateTimeWithZoneId() {
        ZonedDateTime zonedDateTime = DateTimeHelper.toZonedDateTime(new Date(), "America/New_York");
        Assertions.assertNotNull((Object)zonedDateTime);
        Assertions.assertTrue((boolean)(zonedDateTime instanceof ZonedDateTime));
        Assertions.assertTrue((boolean)zonedDateTime.getZone().getId().equals("America/New_York"));
    }

    @Test
    public void convertToLocalDateTime() {
        LocalDateTime localDateTime = DateTimeHelper.convertDateToLocalDateTime(new Date(), null);
        Assertions.assertNotNull((Object)localDateTime);
        Assertions.assertTrue((boolean)(localDateTime instanceof LocalDateTime));
    }

    @Test
    public void convertToLocalDateTimeWithZoneId() {
        LocalDateTime localDateTime = DateTimeHelper.convertDateToLocalDateTime(new Date(), "America/New_York");
        Assertions.assertNotNull((Object)localDateTime);
        Assertions.assertTrue((boolean)(localDateTime instanceof LocalDateTime));
        Assertions.assertTrue((boolean)localDateTime.atZone(ZoneId.of("America/New_York")).getZone().getId().equals("America/New_York"));
    }

    @Test
    public void convertFromLocalDateTime() {
        Date date = DateTimeHelper.convertLocalDateTimeToDate(LocalDateTime.now(), null);
        Assertions.assertNotNull((Object)date);
        Assertions.assertEquals((long)date.getTime(), (long)date.toInstant().toEpochMilli());
    }

    @Test
    public void convertToLocalTime() {
        LocalTime localTime = DateTimeHelper.convertDateToLocalTime(new Date(), null);
        Assertions.assertNotNull((Object)localTime);
        Assertions.assertTrue((boolean)(localTime instanceof LocalTime));
    }

    @Test
    public void convertToLocalTimeWithZoneId() {
        LocalTime localTime = DateTimeHelper.convertDateToLocalTime(new Date(), "America/New_York");
        Assertions.assertNotNull((Object)localTime);
        Assertions.assertTrue((boolean)(localTime instanceof LocalTime));
    }

    @Test
    public void convertFromLocalTime() {
        Date date = DateTimeHelper.convertLocalTimeToDate(LocalTime.now(), null);
        Assertions.assertNotNull((Object)date);
    }

    @Test
    public void convertToLocalDate() {
        LocalDate localDate = DateTimeHelper.convertDateToLocalDate(new Date(), null);
        Assertions.assertNotNull((Object)localDate);
        Assertions.assertTrue((boolean)(localDate instanceof LocalDate));
    }

    @Test
    public void convertToLocalDateWithZoneId() {
        LocalDate localDate = DateTimeHelper.convertDateToLocalDate(new Date(), "America/New_York");
        Assertions.assertNotNull((Object)localDate);
        Assertions.assertTrue((boolean)(localDate instanceof LocalDate));
    }

    @Test
    public void convertToTimestamp() {
        Timestamp timestamp = this.dateConverter.toSqlTimestamp(new Date());
        Assertions.assertNotNull((Object)timestamp);
        Assertions.assertTrue((boolean)(timestamp instanceof Timestamp));
    }

    @Test
    public void convertToTime() {
        Time time = DateTimeHelper.convertDateToTime(new Date(), null);
        Assertions.assertNotNull((Object)time);
        Assertions.assertTrue((boolean)(time instanceof Time));
    }

    @Test
    public void convertToTimeWithZoneId() {
        Time time = DateTimeHelper.convertDateToTime(new Date(), "America/New_York");
        Assertions.assertNotNull((Object)time);
        Assertions.assertTrue((boolean)(time instanceof Time));
    }

    @Test
    public void convertFromTime() {
        Date date = DateTimeHelper.convertSqlTimeToDate(Time.valueOf(LocalTime.now()), null);
        Assertions.assertNotNull((Object)date);
    }

    @Test
    public void convertFromTimeWithZoneId() {
        Date date = DateTimeHelper.convertSqlTimeToDate(Time.valueOf(LocalTime.now()), "America/New_York");
        Assertions.assertNotNull((Object)date);
    }

    @Test
    public void convertToSqlDate() {
        java.sql.Date date = DateTimeHelper.convertDateToSqlDate(new Date(), null);
        Assertions.assertNotNull((Object)date);
        Assertions.assertTrue((boolean)(date instanceof java.sql.Date));
    }

    @Test
    public void convertFromSqlDate() {
        Date date = DateTimeHelper.convertSqlDateToDate(java.sql.Date.valueOf(LocalDate.now()), null);
        Assertions.assertNotNull((Object)date);
        Assertions.assertTrue((boolean)(date instanceof Date));
    }

    @Test
    public void convertFromSqlDateWithZoneId() {
        Date date = DateTimeHelper.convertSqlDateToDate(java.sql.Date.valueOf(LocalDate.now()), "America/New_York");
        Assertions.assertNotNull((Object)date);
        Assertions.assertTrue((boolean)(date instanceof Date));
    }

    @Test
    public void convertToGregorianCalendar() {
        GregorianCalendar gregorianCalendar = DateTimeHelper.convertDateToGregorianCalendar(new Date(), null);
        Assertions.assertNotNull((Object)gregorianCalendar);
        Assertions.assertTrue((boolean)(gregorianCalendar instanceof GregorianCalendar));
    }

    @Test
    public void convertToGregorianCalendarWithZoneId() {
        GregorianCalendar gregorianCalendar = DateTimeHelper.convertDateToGregorianCalendar(new Date(), "America/New_York");
        Assertions.assertNotNull((Object)gregorianCalendar);
        Assertions.assertTrue((boolean)(gregorianCalendar instanceof GregorianCalendar));
        Assertions.assertTrue((boolean)gregorianCalendar.getTimeZone().getID().equals("America/New_York"));
    }

    @Test
    public void convertToCalendar() {
        Calendar calendar = this.dateConverter.toCalendar(new Date());
        Assertions.assertNotNull((Object)calendar);
        Assertions.assertTrue((boolean)(calendar instanceof GregorianCalendar));
    }

    @Test
    public void convertToString() {
        String dateString = this.dateConverter.toString(new Date());
        Assertions.assertNotNull((Object)dateString);
        Assertions.assertTrue((boolean)(dateString instanceof String));
    }

    @Test
    public void convertToLong() {
        Date now = new Date();
        Long dateAsLong = this.dateConverter.toLong(now);
        Assertions.assertNotNull((Object)dateAsLong);
        Assertions.assertTrue((boolean)(dateAsLong instanceof Long));
        Assertions.assertTrue((now.getTime() == dateAsLong.longValue() ? 1 : 0) != 0);
    }
}

